/*
This work is licensed under the Creative Commons Attribution- NonCommercial 4.0 International License. To view a copy
of this license, visit http://creativecommons.org/licenses/by-nc/4.0/ or send a letter to Creative Commons, 444 Castro
Street, Suite 900, Mountain View, California, 94041, USA.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/* ******* Portal 2 Mod by Desno365 ******* */

//updates variables
const CURRENT_VERSION = "alpha-r004";
var latestVersion;

//initialize variables
var countdownInitialized = 0;
var initialized = true;

//general portals variables
var fireButtonsInitialized = false;
var portalWithUseItem = false;
var velBeforeY = 0;

//orange variables
var generatedPortalOrange = false;
var arrowOrangeLaunched = false;
var orangeThrow;
var xBeforeO = -1, yBeforeO = -1, zBeforeO = -1;
var orangeInformations = [];
var portalShotOrange = new java.util.Vector();

//blue variables
var generatedPortalBlue = false;
var arrowBlueLaunched = false;
var blueThrow;
var xBeforeB = -1, yBeforeB = -1, zBeforeB = -1;
var blueInformations = [];
var portalShotBlue = new java.util.Vector();

//entity support variables
var speeder = true;
var portalsWithEveryEntity = false;

//tip messages displayed variables
var displayedMessageWoodStone = false, displayedMessageNoSound = false, displayedMessagePortalInformations = false, displayedMessageTurretsBeta = false;

//PortalGun gravity and GravityGun variables
var gravityButtonsInitialized = false;
var pickEnabledBool = false;
var currentPickDisplayed = false;
var isPickingEntity = false;
var currentDropDisplayed = false;
var currentGGButtonsDisplayed = false;
var ggMob;

//long fall boots variables
var infiniteHealth = false;
var countdownHealth = 0;
var previousHealth;

//jumper variables
var jumperPower = 6;
var maxPower = 25;

//turrets variables
var turrets = [[], [], [], [], [], [], [], [], [], []];
var spawnedTurretsNumber = 0;

//downloaded custom maps list variables
var mapsManifestDownloaded = " ";
var mapsGuiCodeCount = 0;

//GUI and sounds variables
var currentActivity = com.mojang.minecraftpe.MainActivity.currentMainActivity.get();
var sound1 = new android.media.MediaPlayer();
var sound2 = new android.media.MediaPlayer();
var sound3 = new android.media.MediaPlayer();
var music = new android.media.MediaPlayer();

//images variables
var g = [];
var blueB = "iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAYAAABV7bNHAAAKQWlDQ1BJQ0MgUHJvZmlsZQAASA2dlndUU9kWh8+9N73QEiIgJfQaegkg0jtIFQRRiUmAUAKGhCZ2RAVGFBEpVmRUwAFHhyJjRRQLg4Ji1wnyEFDGwVFEReXdjGsJ7601896a/cdZ39nnt9fZZ+9917oAUPyCBMJ0WAGANKFYFO7rwVwSE8vE9wIYEAEOWAHA4WZmBEf4RALU/L09mZmoSMaz9u4ugGS72yy/UCZz1v9/kSI3QyQGAApF1TY8fiYX5QKUU7PFGTL/BMr0lSkyhjEyFqEJoqwi48SvbPan5iu7yZiXJuShGlnOGbw0noy7UN6aJeGjjAShXJgl4GejfAdlvVRJmgDl9yjT0/icTAAwFJlfzOcmoWyJMkUUGe6J8gIACJTEObxyDov5OWieAHimZ+SKBIlJYqYR15hp5ejIZvrxs1P5YjErlMNN4Yh4TM/0tAyOMBeAr2+WRQElWW2ZaJHtrRzt7VnW5mj5v9nfHn5T/T3IevtV8Sbsz55BjJ5Z32zsrC+9FgD2JFqbHbO+lVUAtG0GQOXhrE/vIADyBQC03pzzHoZsXpLE4gwnC4vs7GxzAZ9rLivoN/ufgm/Kv4Y595nL7vtWO6YXP4EjSRUzZUXlpqemS0TMzAwOl89k/fcQ/+PAOWnNycMsnJ/AF/GF6FVR6JQJhIlou4U8gViQLmQKhH/V4X8YNicHGX6daxRodV8AfYU5ULhJB8hvPQBDIwMkbj96An3rWxAxCsi+vGitka9zjzJ6/uf6Hwtcim7hTEEiU+b2DI9kciWiLBmj34RswQISkAd0oAo0gS4wAixgDRyAM3AD3iAAhIBIEAOWAy5IAmlABLJBPtgACkEx2AF2g2pwANSBetAEToI2cAZcBFfADXALDIBHQAqGwUswAd6BaQiC8BAVokGqkBakD5lC1hAbWgh5Q0FQOBQDxUOJkBCSQPnQJqgYKoOqoUNQPfQjdBq6CF2D+qAH0CA0Bv0BfYQRmALTYQ3YALaA2bA7HAhHwsvgRHgVnAcXwNvhSrgWPg63whfhG/AALIVfwpMIQMgIA9FGWAgb8URCkFgkAREha5EipAKpRZqQDqQbuY1IkXHkAwaHoWGYGBbGGeOHWYzhYlZh1mJKMNWYY5hWTBfmNmYQM4H5gqVi1bGmWCesP3YJNhGbjS3EVmCPYFuwl7ED2GHsOxwOx8AZ4hxwfrgYXDJuNa4Etw/XjLuA68MN4SbxeLwq3hTvgg/Bc/BifCG+Cn8cfx7fjx/GvyeQCVoEa4IPIZYgJGwkVBAaCOcI/YQRwjRRgahPdCKGEHnEXGIpsY7YQbxJHCZOkxRJhiQXUiQpmbSBVElqIl0mPSa9IZPJOmRHchhZQF5PriSfIF8lD5I/UJQoJhRPShxFQtlOOUq5QHlAeUOlUg2obtRYqpi6nVpPvUR9Sn0vR5Mzl/OX48mtk6uRa5Xrl3slT5TXl3eXXy6fJ18hf0r+pvy4AlHBQMFTgaOwVqFG4bTCPYVJRZqilWKIYppiiWKD4jXFUSW8koGStxJPqUDpsNIlpSEaQtOledK4tE20Otpl2jAdRzek+9OT6cX0H+i99AllJWVb5SjlHOUa5bPKUgbCMGD4M1IZpYyTjLuMj/M05rnP48/bNq9pXv+8KZX5Km4qfJUilWaVAZWPqkxVb9UU1Z2qbapP1DBqJmphatlq+9Uuq43Pp893ns+dXzT/5PyH6rC6iXq4+mr1w+o96pMamhq+GhkaVRqXNMY1GZpumsma5ZrnNMe0aFoLtQRa5VrntV4wlZnuzFRmJbOLOaGtru2nLdE+pN2rPa1jqLNYZ6NOs84TXZIuWzdBt1y3U3dCT0svWC9fr1HvoT5Rn62fpL9Hv1t/ysDQINpgi0GbwaihiqG/YZ5ho+FjI6qRq9Eqo1qjO8Y4Y7ZxivE+41smsImdSZJJjclNU9jU3lRgus+0zwxr5mgmNKs1u8eisNxZWaxG1qA5wzzIfKN5m/krCz2LWIudFt0WXyztLFMt6ywfWSlZBVhttOqw+sPaxJprXWN9x4Zq42Ozzqbd5rWtqS3fdr/tfTuaXbDdFrtOu8/2DvYi+yb7MQc9h3iHvQ732HR2KLuEfdUR6+jhuM7xjOMHJ3snsdNJp9+dWc4pzg3OowsMF/AX1C0YctFx4bgccpEuZC6MX3hwodRV25XjWuv6zE3Xjed2xG3E3dg92f24+ysPSw+RR4vHlKeT5xrPC16Il69XkVevt5L3Yu9q76c+Oj6JPo0+E752vqt9L/hh/QL9dvrd89fw5/rX+08EOASsCegKpARGBFYHPgsyCRIFdQTDwQHBu4IfL9JfJFzUFgJC/EN2hTwJNQxdFfpzGC4sNKwm7Hm4VXh+eHcELWJFREPEu0iPyNLIR4uNFksWd0bJR8VF1UdNRXtFl0VLl1gsWbPkRoxajCCmPRYfGxV7JHZyqffS3UuH4+ziCuPuLjNclrPs2nK15anLz66QX8FZcSoeGx8d3xD/iRPCqeVMrvRfuXflBNeTu4f7kufGK+eN8V34ZfyRBJeEsoTRRJfEXYljSa5JFUnjAk9BteB1sl/ygeSplJCUoykzqdGpzWmEtPi000IlYYqwK10zPSe9L8M0ozBDuspp1e5VE6JA0ZFMKHNZZruYjv5M9UiMJJslg1kLs2qy3mdHZZ/KUcwR5vTkmuRuyx3J88n7fjVmNXd1Z752/ob8wTXuaw6thdauXNu5Tnddwbrh9b7rj20gbUjZ8MtGy41lG99uit7UUaBRsL5gaLPv5sZCuUJR4b0tzlsObMVsFWzt3WazrWrblyJe0fViy+KK4k8l3JLr31l9V/ndzPaE7b2l9qX7d+B2CHfc3em681iZYlle2dCu4F2t5czyovK3u1fsvlZhW3FgD2mPZI+0MqiyvUqvakfVp+qk6oEaj5rmvep7t+2d2sfb17/fbX/TAY0DxQc+HhQcvH/I91BrrUFtxWHc4azDz+ui6rq/Z39ff0TtSPGRz0eFR6XHwo911TvU1zeoN5Q2wo2SxrHjccdv/eD1Q3sTq+lQM6O5+AQ4ITnx4sf4H++eDDzZeYp9qukn/Z/2ttBailqh1tzWibakNml7THvf6YDTnR3OHS0/m/989Iz2mZqzymdLz5HOFZybOZ93fvJCxoXxi4kXhzpXdD66tOTSna6wrt7LgZevXvG5cqnbvfv8VZerZ645XTt9nX297Yb9jdYeu56WX+x+aem172296XCz/ZbjrY6+BX3n+l37L972un3ljv+dGwOLBvruLr57/17cPel93v3RB6kPXj/Mejj9aP1j7OOiJwpPKp6qP6391fjXZqm99Oyg12DPs4hnj4a4Qy//lfmvT8MFz6nPK0a0RupHrUfPjPmM3Xqx9MXwy4yX0+OFvyn+tveV0auffnf7vWdiycTwa9HrmT9K3qi+OfrW9m3nZOjk03dp76anit6rvj/2gf2h+2P0x5Hp7E/4T5WfjT93fAn88ngmbWbm3/eE8/syOll+AAAACXBIWXMAABYlAAAWJQFJUiTwAAADymlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iWE1QIENvcmUgNS40LjAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIgogICAgICAgICAgICB4bWxuczpleGlmPSJodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyI+CiAgICAgICAgIDx4bXA6TW9kaWZ5RGF0ZT4yMDE0LTA1LTE5VDE2OjUxOjQxPC94bXA6TW9kaWZ5RGF0ZT4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5BZG9iZSBQaG90b3Nob3AgQ0MgKE1hY2ludG9zaCk8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHhtcDpDcmVhdGVEYXRlPjIwMTQtMDUtMTlUMTY6NTE6NDE8L3htcDpDcmVhdGVEYXRlPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICAgICA8dGlmZjpZUmVzb2x1dGlvbj4xNDQ8L3RpZmY6WVJlc29sdXRpb24+CiAgICAgICAgIDx0aWZmOlJlc29sdXRpb25Vbml0PjI8L3RpZmY6UmVzb2x1dGlvblVuaXQ+CiAgICAgICAgIDx0aWZmOlhSZXNvbHV0aW9uPjE0NDwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPGV4aWY6Q29sb3JTcGFjZT42NTUzNTwvZXhpZjpDb2xvclNwYWNlPgogICAgICAgICA8ZXhpZjpQaXhlbFhEaW1lbnNpb24+NzI8L2V4aWY6UGl4ZWxYRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+NzI8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KxJy/DQAAJvBJREFUeAG1nGuMZdl119d53nfdevZ7ejLT40zPTCI/EgubkGAcy3FQQLESS4ACQhEQ+VP4EgkUCcLjA5EgQgQFkSgCPgRCsAgODiHG8gTHOLGTeGI8gz0z7fH09KO6633f954nv/8+daqrZ7qqIszs7lP33HP22Xvttf7rsdfe53plWdrppbAsyywMY1dtPp9bsxnbdDa2dqtl6SKyKKKNvLQ8NSvD0sI40YnZLDKLZpZzY+qb7edN+8ZWYH/8tbz82iue7e5FduOOWcpzNMsnJ5QoiqzRMIvp8snW1C5f9O07r/ved1z37Nsul9bvFBYHvgUWWrDwrQzum/kz8+wy/UaW+4UV3oLvLfOLzDzPc+1qrMfHq+u+D52nFO/4A4+qV5SJ5RmDPmTQbDazdrtpo/GAz5YVPgwqITClo3TDBtHcpvFNSI+smVyzG5tmL3xlZr/zxaT86mux3Usiy5ZTW/q2zPpXSrt2MYcZDdpqO6aIhvm8tOl0yufc9ndatnkrs7s3fVsMIuvD/Gcen9kH39+27/6urveBVbNGPIFZerBjVvAZDSy31BZpFyb7jkFiRs0gfeq7jiBAiKcUryjU4slFDLISKZXqQJJAOkjFvJzvDG7asWzFbGgjS2xgfVgzKjbsN37ft//4mXH5Oy8t2dr5zJ56zuz6OwO79o7QlqkfI+UyL+wgqFBTEy9KauJ13s8DhOAxYN9Go8Bufz23b3xxYTe/nNnwDsh6xreP/EDDfvCDC+9q88C8BFQlGxZEnhXRwrK0ACUVk9ReDYj62pkIOotBeTG3EC4nCQOCQY1GZHt7O7a62ncoCrrrVs4QWpDZ5sTs3/9WWP7yf0KdvNKeff/CvusvFdZfblu3B3H8yxIYnsHoLDTxuQHx0vKiqOBfM4fLMMpswj2pmhVS1Zk1Wqhf3LVpktrO7oH93n8/Zy8/P7K1aWI//lHfPvZDhbfWg5Dcs2bUsnLedgwSQ2oGqQ99r65V193NR/w5U8VyW1iQA8MCSReepUEMoEpLx1vW8Tt2J0K9Gkv2yd9aKf/Fr2Z2I7hrH/6r5+x73tu11bCwxdbCmaJZXNqCw4OwuAismXoW5WZJ+EAFqgFIEKpXqcEC++ZnoACLEgSBpVyfZykmr7r2ZK9l9w8K+x/Pv2Ev/d6qhVt9+7EPp/ZTfyXy2vOx9aiXtZZsvBhbCFO7rRWswcKmdhcLdcVCbBYAdULK88peBT4K66FZoqNGkLhalxqG+r5ADQCt+cGChoaWTDcsaiNZO0DLS7txu2M/9TNW/q87mf35j+f2Zz6UWiv0bG/SsGHatgswJQdNGUoCfzGmVT8eauuBGmy7K+q/RH2P961rbQ/bA9RmGPoFzCl5PmQAPQTV5d7u4LYVYdtW11dta7e0L/32y/biJ5btWmvVfvqnY+99z05sfvuWXVnFWLVDmw2b0McAmpkdDEF3P3IqLSLUtxMO/eqfypkIyuwmHuuSNYF2gXZ4RW7ToLDbaW6f+JRX/tN/vbB3fqhhf/av57Z8sbCdzS6ew2xpdWazKVKOm+ZlOSgECTyrkoGiDGSnDLbJIFUqxjwsJEfsDATj1Xw8ZxkH0hzMX2EeKuXPUsua6G6UmheFtj++Z1fPNzHmffuVn93GTp23v/mxuX38YzPv6aXABneXrL1eWoRRTzH4UV/2tPGQzatpqQEDgyqi6xv6rG/qHAtp8xx4Bl2bY7DHGL3X0y37Jz+flZ/5n0/au3/C7M99aNOW0MJbd/vWvtqwBTYm2PPtcq+0TdoPgXmAJwxkbFyTMAgUA2iLQNdD9qfyR4fSBC1IPRCJMCNZYHTBWdSILQhDwOiBrJG1m9jDyZ61olUbj8zCzp711xr22U+N7Pl/vmbf/8HM/taP3vG+/6lL1khjmwV71gvPWRObVvpN+pejqow5EDf5oiMEySPV0KqkWDFITNIxniyshwtG7e0Wtu+l6T37u//QK2/sm/3wx1v29PcNbbx7zuImg/cHDOYc0OC0VdhwtG2txroUh7Yq5qhN2RMPfav6kxRrT1oZTs8Ljmg68BPULLQmKmky5BBfBJ5lPFMoPqPfZBzjFWkzvG9REzuZrmDES1s+F9vLf5jYb/9qYt2DyP7R32h5P/h++sruWT+8YPECWhp4yBz1hw8OGGqH/uW5VbBBb2WQu6ObDAZ82yTZtZsHt+zFzYv29//Zcnkn3raP/Ni6fc8HmqjUjs2JeUoZJoxcAwMc0njRCDGEpbVQRakT3poArmoT2w2iYCIDBqBHxUPdXJ9HVxiLGAsdYrLQozZCuNSEwVLbBQFj3FhYMUfyCCYFUVG8Qlzl2c5wH3u5Yps3XrP//HNtW/e79g9+suv9hXcRbNp97N+GxVHgbCEtOyYJSQECcUiiHy/LkrcQJYnWqNqZDWyytGVfvvGM/b2fDctXZpv2l//2RVt/DJeLN0gWAVEtQR72QUb4YMr1po+LbVgK4gL6koYUGFjhpEIQnwIUF6R1kkNVKpTV31xdGCKAVYa+YpAPY2I6ixlAGmWgm0EiFLTO+YA0x1gSnkThEtHE2Fa6hb36wpL92i9Bw/0D+zt/LfN+/KPMBFJUrggJIwILFH3DC5mcEG8pJilA9it4PfAeNWN03YX+4Zp98YV32E/+zHb5Kv3+6R+5YE+9Z4yUxjYG2lGraXOs9+6Y6BdU0DqDIaiTzQBbhEiG2cLA84fDS1ETOMaHJTBGzHMM5LyAU9DkDjFEx4TrCUY5oO9u6luPIwR2KXXnBIO52qONknBg6mEj6XUBlBZATeroY/++cWvJlp4d2Lt+eNOS5cD+7e9vlP/hM0/Q/4HNFikCkAmgPuolyTkTIKSiyhwMIVyxIB1AWd/K1gLiJ5bMcJu9l+wL20/aP/6FVrmFs3/8ucT+1Adu2N6t85YX6xhDjGQ2QvcVBkwZCLD3Y0KmQ732sNwMzpUaJoJM7du5AUmPLjxWMjhaRLUw6qolToibh0+h0TCBCzSSg6KiFBJAL9Miz0ttvphaPi+s2963cn/F3vtejPmdN+yVzwb2rz5Rlv7VDe8nrqNaB3uWdjs2T5u27BONR8s2K6fWYj5JpL2Md8JalISrTeKbA5CRdmzQnNg371+3n/uXi3KLiWDvsa6974cUq1y1Mlszr3nHknKPCBu+Iq0c24N/4SBCRnQFkM8V53DltKOAYacdOfdPO+Q8FOH7xEZCv1A/nyNkBCNZNBBihJ3JG99EgAO79twV5oAd280W9ku/bOXvvs4Urtu1/cEda7VmNkrPWwnSW16buIsoXLBuYAwOkEJJ9OijUqN0Zl/LGvbv/mtavjJYtnGzYf3HU2us7lsy77qJehivozEwgig7xwrXh+wFsnFEV4ZO3//kh+BeH3rurELwILOKGFTQCzkIGCYvJ8GkWc+GQ4x5iokPSrv87ZldeSeI663ZjYOF/fxvFuUfDwgfCG5HM8JZfI0Xk0qYhS5q9zOmEmHZYTqAWx4M4JrZtBzZr38pLD/1hR0jVkcMM3vu3S2LvSWXlljYbRsdNCFnBaYSQIKaDLuQMCVYYHBS7JekXsL8AnSdduSohZ6tD31/+DgdQR4RtdpPQXIu1dU0ASMrdUtQQcJJIvEWLHwC89LGqZg9dn1ofm9qzfOJffqF0n7l80WZdq/aYBuGloq1eKbcZFRzmsuxHQR2TS7vEkSN0Nkvb7ft1z+9b/nyeVuMMussvWqPXYyIR5qWJwcWelcIHuG29F+GjUMGEVBzoNPuU+dSH6nbyYdM1En3dS8DUacekECgTs6Kvpww9F0IwsPR74Tg1m+GoIdxYvFn+7Gdv+DZysa2zff6Fqx49skvtOzzr4bWWQ5tuDPF0OMl2ylzRUAQYnuGzJfScWq7YccWeIJ/87lmeX8XDq8ycw4jO3+uSSDGDB1Aec0pnQOsVSLsZA9ikLDUCgZ5xCSSoEyrBpVAuYT6/3qoHSHhtCMBserfcx6o6hdt4poMbMsl+8S4CfmlrIistcQMMmvZpYurxD+Moz+1faD2i79xv9yP0S9mDHskA0fFJTyngtqsAwzHTC5b2JHEnr8Z2ue/Glu41rUxDi5tjAnbnzJsFjN5Djg1yOaoEqrDZFQ2xx3MHQqOUlI8PNdnDjdPOwq496ijfgZHZqcdsjxVaKIzCpIqUVmhEufN/LTtGGHZeUMbMdZ7NmEgzT7JtD4hAW6+hSH/0g3fPvEHuc1iucaAVApxkIeyMedDf4c2aHSsOd+2X/jsTtkk55NhmPGRVvCwtxTa/QmTnP7Cdgl2AjKK+weZtWIyeDRWAmfpP5G/O5yhxqvJYNaJtrM+jxh9yPC6vto97VDsopgtIZWRyhDDGEUUiqfmskv8SRdD3D9xUzm2wcF566yBjO6I6F7hALY1aaMtG/Zrn3ujfAOXH4OGws9RT+agU/gwPxiS8Fqz5zcv21e2Mlvi2gqR2ZTEVAyBoT/lPgzAPrWKKwR9zLBjUqLlkmMQonLScvEIqqUiyGMauAS1p5Wquqt5WrUT7yEUAjl1JDKcOrsTXeaaAtUgWiKIHWMqG0TXRoCLt44wBzimYp4bXt7uoIJfX3Ttcy9v2AXGe64Hw5OuhZqMWuMKKlbYf3thu2xHG3gxsnikLouY4SHRDHVS43OCnoLAIwJhQdlCaiTOmUKoVPGsO3V/arYI/m9nkZV4qEO+uB7dXAYeECEzHcQ2kjIhiExYHIhIj1R2ikg5bNguAtcCRELO6zNfPig/8mzbW/Ll6icWztKxLYh9/s/WwD5/k1AePZ3ReJIAvwZd4fdHE+Y7eQf4YuAYuQxzSZRZ4C3KQ0KcuCpSq79HfKlZdfzm/7/zo+7pT7QdsufoI2BmrGDSZ25YYMySnLAGbE8mSvfxQLNFhnJqXRDfaLbtq3dJut2bWq/ZBQSpJt4sv0zNPnejLJPWGg0QEBI0LVgOiXypUsMGBFJzAsSA5LCPAZzDceJTJnQy0EeceOSo3zw7f2Slb+GiDHhdFOgeL/qm5BrydIZeaVpPDMN5HAxSXLjiJHi0FIMslgXICORkGD/98rB836U5QQ0RHisstj1K7A9uNkkRECSCli6imOOtxMEcqI2JMEfMzNs95lx0kGIQA1oXPVKhk5hQ3TtO8ttwXsGmahiBPSQuCEyw/jLaUrOMvHqz2cTlpyw8kEJmqqhFhC72aJ862TYOaD2yr9zvkZUgbdKEQUNmw7eZiW9PQUdjYgWpVZdkDKmMJ1rQQEj8sL9PDzimuMkn3sknqTRPSA04E/BWJtW2h5Tl28CVY00emiCFqeIODvWwVN+dAdc9uKSAMscs7GznJPOYpICgNvZ0OhiaLXeswTofeQkbJWv24r2hfe8zLWwQD/7vTXL7gh5N+1j2GXlkn/igjLBDCuOZ5d7bTEhtxLZEGJ8jFamaJJITGApBb0aR2CIm4fze1oIfeqh9xe/HiwLhhMSUkKMp0QRzcm+TcIC5pk/Q2w5atjMOrSG5s16nuUjE+H73Vqd833O5F2akKl66IySgQ90VbM0BKQ8YBFOzRoDHIgwgKbazNbELl1lJJe5JiTyJcZUKcEyVK9e/48UxSBeE77exiB3FQ7ZH/THJOexWtyasBsdohs+8EW9uBwey2jCIRcv5GC/eX2EJiOsQrTx3Mx/a1w+WbW/6hoU7rI+/xsL5kNRkd0wirLWMvmKoWyy1gI5+F6O8T7DFbO0OSzsRqdSQvK+WduUFCq1kigEQVKEI4pxdcj6CxJa7e4gyVRSyKnQ5hOGGH1Vqvp6ooY4pNITBVb9Kcil/pPo+JkB5ZbVRxEOX8kiZb06nnr36jSneG3NCkKtMxryzsMaYucQKCwEwZilft8E6aWJmC/e2Llm4D3BSPBHrZwqKHed90o+aVynRPiaF2uzg4sldb7OS6aG4Vx9n9YJJXkIwofSkomDlfniaAFGMqgbtGICXFNE5BkDfVepVTR83qGfrUt/X95oxb1bduq6L0hGTvJj6k+0RUzQdVJuZMgocMdFySwuHw9xuvrFnIzSjgaYIKfM5Aifd6hL36lMcRaOI3d14dkasKt8awyBRA3NyPFfJmpev4E8+XIMlWxTg9lMmhVKv3V3W41mx8EBXu0fOZKGYiMMRyB8e0rnL6WAQwzqydjI+HB4DcPf5iil7S3mIKUd+nIoVf6v66gqiif0qAWBDCnkX1t70vFZhI8ISMW7ELOne5gxHIyvbdfc1FQkaohU72cTh0I+P8EtF2JoFwOxbg0kZ3hkHpVYdTBM5PgoMb4BuehgfISliVSOlUyUxmq2+m9zJCygxfv5Sg1XKqkHlcmW8M5B2uHwh7iJhIREVoNO6SB4PFgaq6zVT3OcxRkiaTlIOUg/aqLmlNEeAMHWIW7JHElgOs3w+F2x42CLw294hhGYtI2InycLtM9B4Qs6hl3x2yaS64PkMTdI00iMG2ET44VaGPoYwgNRZzgpmIbVhQBkdlqzYJWlkIVxVbrikAUXQC9rcG8xI1k/t8UushzMlEYFKcWjdXCVkiUFSzEU01wvgXqtQxbBqDUw7PFxxDOCs/uRU9ZSdrIq4JrvG9+Phs9Le/FPfKo7BPCc1K2He/fuZ7e9lfGdeFbDSAr+180MLj0nKchFIKbS/ScjD6WgxwWOiqpWfXcKbcIg+BDCo0LIHM1uXA9MauGqEGGJFoiKNhwVXHzgSIIGqyIbj3G5tDq231GL3BikSZoIhOyqq/EIVwWYY/KPC8xoA/x20xZp6LlUz7+FPVhgcfyomucGrMTHxkEmKZYSijASevJTzrAhwStZhNl3YYEwsh4qEAUvgCgxBvmb22qRVslineM4jFgnQhBIDJgZJc/iwEZ4uXIgPBIValKMuleQO6VD6QcW4xQRvIb1WQxg43H6qtTRl/L1l29lj6YTIekZyqdshz9JinYwkuQaakgcFOHRYoaXabqIBSmBSBfRegnCF/igPAFR9rwHmmCOqnffCBqoy57MJGUOE5xjAVcI3Z4gP8LzjER6KtXvncKBd4NM+MBKsIAmmaWpPAX+cyzNXGYgAAKirGQyDNQCCjpiFyDFAMP3CCVVAibEr2COyivIOqVKJZBxL1DEg459pNs96uOKivb0ZE8Dc+sxr+iAqxLB7DD7mU8wqUQFtL9F5hSKw41ThUMXorkZI/SkSXJ5ZJxVF1OHUMQkK+YwJajmBhtIGQxADY2bMn3wjv9VoI6SUmTrGmm5SElbSllBeDweiJoVQrS6HXmXQHRMxKaIq5WYohhAHmhH/aGUxjkm8K0MtZsGxgkEKmnpAhjYrEAGNiduglmfgNhL0vB4oYufHdmrbB6ynd2Ki18CWSRmpaGlHei6qAhAqlLrg0knCVXHoEQMfGHAYyxp1FdNoeoPEBWM8irKQSo6xwoNg5KnITzFn5AGEBmHUk6eCVGIxTvQY3MXx0w5faEq20WP3V9JjZXjECKmWdqdu/HJafUKTEG1gGQf8OOTQKUxwsQQMClEjeU4nNQ3NDUYirIquS20qqVYDVh3FHxPytfO5h1TnMJ1YhCxkS0EmhGl2rXmcDHcgB0ADR6hR86Kp6ozzpot1hAAdWg4WEjPlu3l+NKwQKooiMg9yDFUchplAhZWPru28wg+Vo++0p00UKqxXVOqkSjgchk/YQ5iiZHzOBbk20MeIq3O+ImEYhm6KL7VqcHpUhAr5t6pUg1QCiqFUes5gPBLhCe5ywqQ3ANqKqRpwKSQgCzgQacVgnhKjHbMPW9THnD14QoqYUTEI4w+H3SoGAwwxpFpNVVArF6+cT1FtZHKtMMmEmorGmjHV1OSQcQxcWpS0MNykH2MqKWAEGqSdQVAHe6LoUVJz7o3JnbbY+SzdKtcsjyXmOInyYG1oazXwGCw0cb8alVKtCiLp1j2jNSZVEJwJJJzEEtCjYFTb7BJtNKAcIahq5uiv1KrqvxokNWlO8pWdhB7FYdzStEF96J80Ucke0SrbJ4GpeDWEqCPJCCelhMa3FNNSksyPlMHguzKlYYPpbY/9xIgSJsE9PEChaFJTcOyFXL0iTf0TETqOMohu3NyhdTG0SrLTraMHmTkoQKwePVRD2RLXhhguRICwgNjkpOKEIga7AalhPY4K6ZIrTHfKOdf0T15WKMZgUvSs1sd8ViaqUjHy8AsfGhDqqn3duErtfdQWHUIgWCcml9YhwxEulzPabWNqtICLbksaiguEIC3WqzKDrRFUkan2hRSlPMCIGCCc6iaHk7h7rgKnVEPXpJLKD6k9H+iLh0rfvrnUaNIQxGFtbXH9v7kifUSKX5wdkSkQ50QrY9BBv4GmT7rg6BFWKlr0qX6EI25RGXyjDUKivLeH/TnPebgCl2KITYh5AllkKguJ2jVRyljRSU2wGq0Jra9lJa5bjep/9UEtEVIxQvuUVVcT0wfPCGmyKUgIVahLfV/f1ZZKJmL4rzG69usb1W0ughgGpLYUvei2+oqk6pznWqcTpyj1dOfwq/vuxkrjbZhMYgJwyFtWDDrHWbjSZEmZ6caCi5KGo5eKHroo2yIjXNPkBCFqKY4QoVYqCfHqVIJQ0b3qGXVU6cNxoMhYSt20WxURHhUXChx9U50KDdUlIYRSde8uOaYxMKE3YGBOLKKFmpkLKajubCQdwonaSDuB0kJFByOkjSbqvsCTacEx4lA6dhUTEy75S0wT9m1r3rIFk1EhpqH1LyMvi3nIkY6KDKrQU8PVXXNcEDf4VvFBl91AamZVsHeXH/qj+64O0n5Qjp9X9xXAnlRU+6idN1WCbdUVKlTIOaQdTydTqKJnPZxUomwjWdOcWVKMpCPyQxfYlXaBBURewVjYOwYem33Z/gFyujOmCKwbTbBDet9CUKjQ4NqspIqMjtRBGD2lHBF6Yp0K/ifdrlB70l2Rd3r/NZ/EjqrmMUnSbBWqwERu+kTazBNcrLaK+ijLGsbhxN7BCuEfBUG5I8THBGAkaBXNa0PUIYAqQmpmONH/CYg7eVwP7sjNnVJkoL+VovleXSpmPsxQ5dZxNZiykrw0a/OovU+e6FJARigkYeaxBa9PBHqOqHlAWxP2ZYNJWyKRNhSAuCYh1cOoJHpI9MN91XQ89Hk2As5iwOmdnNW+S0+IIhiNknHycHslgSbm2YU2EZG/BtvGFp2n4YA3l0jaE9miThtMOG9y081bUK6C6zIPtb46Jqn94xTp4lnleP1H1T2jjdprPupRd+0sEmqEHtLx5u4Uc8IKt9dJEXnMcY75X5/6QhzrPU1rkhg7702twzxmkqBnpDzGpC26xJAz7qlihSDFFA9IrSTy4Pujzmr6HnVP146396g6CkS/laIAVqVmDOEg3zQ1qa4rhJJXU05dYNnAvj5ekCaBSUHZJJJmF9UintkTi8R7PYjZfNckOoWjwIztHM5NuracLYA7jEiDqjtQ56cWF+qfXOPMds5AyFkIw2EfdV71JQlXh75rU7pbpIBvOU7qEgy6lk/ZppjxHglvv62RMbvVSuwSW0KueQ3vpTZLbaRvZxA2C0lGoWOOQTUU4E5tONXBWQhwwckRiY86EbGnlDNu13PDk1qoGfiAOfjV2vPAKOWtQ0yM2zQOgzYQ6CVyYCFz0AY5D1aVscLgLGPZ9elpZOeKsW2x6THS9jXFATSmeUqhRD5VYyJT8QpH7zZzHyfMMfL4Bc4VaJ5eTudAPcCT2nBThZNucr2jvZTYlQxBKwgUNZpgFJiOgtlClw1SQ4LlgHtX2J3/HZPcG602bQNmhYyZTGVo56YsyeLmMmar7xqV3mfXSc3T0ogJmwyYmKRPl6uFCwUMVQKf/45pp9B3FCacXOd0BlaSP/lp2ZDTyox8k2bsyLaixQmXWYKkTPCT8jJMrJUcwpv3bBfesJ/addx90OOdW6q4WHAdmzPXrJ6o8knWPV4jmrwZoV4YyAQINmAKeTj4jkMERjnzN8khEmSA56OkXF+rw/qTB/HARjyqzun4qkf9qCerazmOR0UzBDev5FxkV5kKxsd7rSx82XVyQZfJVTdAEUG1rWl7D9MX2Si27jMfI3c7BXJFp7R3D3Lv1oWMyAjVU8LJmXopFY1rPJwALlJFoK7ulcvHi+qqCHunl7Pun/60lP204jOn1OIlckTEVV35MaVH9FWLFm3Sxs9Oc6/NW4gXmGYN2cHbYR6mzGooNVFKtIeujlCxBbC5vFfaU+PMXuZltoz3qTzyKsrXC5KKjSQTn8ldJAY9NJeSdGrWnEb28Xun16+RePyJh89Pf17hoYIUNzOgqnLteota3AkQfBcGfDseiRS6rWOnAgCxRmIo4Q3B84Q87EOgIlzUfmhl0VBB22tn9s59z9tuFGWIv5/TwcxxhSUdICQNE5KUN6oTaEeMOUavrn3LAzyD4We1n4pG6FUWEv/ikmK8BObQr/fVnmDN/ol54TVbsrJ4NMCyjMkRelpSsXXc2Yi8s57usAVNK2TsKbINmPUsu+xf4fXtPVA0w5iDVvI4VTpAkXaifPXhZFuK4hhyKN6j8zMGWMUkD2Pi+LczFfCs9lnY8pQqpDjzwMAl4C6GuU3i/zv3cm+J1GoPO7Ro+7ZGnqNB2meNTLDfIie9AYfHPCQI9me+7QG1c0Dum7yj8exB5t3n7bU5Sx8DjE6hFQilHKFazMr4Hmqf7WF5FK2ycW9nqcOzk/oIyRTq5TtNSoUknJXzTn3y4ktslnqSLTEL0hwRQIkwLyVmpUfdVfJJ2vURluzmXGfRzePd0AM2TGVzfjiA2XwrndtgqbQPb428PV5c+cV3teWurMMqaxuHN9BbhTArYSdsE7VkO5GzR/q5Dhk+vesesUmgQKffXADnUTnLTUsYdXU9VwmhvsI9kKzVz5CMnF6gSagkuygEyzCH/LZIEbPmjuBZSbdYW154m+kKO6m+ezvxBuf4JQgYcw7k6LPDwmjAarJ2jq1obT4GOk0y1W280YLPhHiI/fM2g/KUI2KLy81ebn/xxan3yaeLMg5bdmed6FpE8dq3YowZbhHwuayirLkWSrTE48PExWF+UwTXRaiqbUd9vf5e16mvuxwxF8UcvdZZXa/a0jMhi+kz8sfMC2iUcIS+u6AEXjCeUptdeJNJAIBGfhRlhiN68nZu19mUsLtmdgXG8Xor9oafQkG12u5gRo+gWcbTsg9QAl4pKpTxUgt9uoQ3cbMT16Dn2TU2AuwQBnz0pcL7L+/xyqWU6JOniaeALZ3zj/7de2RahBRPCFSBFKE8aliXYzwCFbRPoWtX1O/xUjOoVlG6ObJxaqeqD4LFNEe0gle6ZFBSf6lSD+877+Kh2NKxT1TcY+vv972WeVdniSUrvIkIbdoXrgxPB7q7HD0M8xLXuyCzA2NDcQ752IIph0tw0xlvVJIhwSgTGpYs+sVQFOPlZqjM97469V66kJZP8yLLyxci6/FqtYJJveEXQKF7PVvPQ6Tmc1pyO15qPhxFB+qeUk0CqvPjf+vHlWc+1C/3IfftUAc0pGJ6izpHG9RvpnCEFuV7lri/1Uns4tbc3nsz8dYYg5zQFTbIB9IWmNoWemBKC3fe4dk2rl97xd07q25nBJauhWFKcUkZg9VSnl6MTfiuNbKs14DDGGn2F19DCu155t1d9mxtYOUB76bHJJqUqi30OqRef6QzRdlaKdC+HQ3kSIUgWuhw//jMCE7dd86Pl/oZF8HzvMNhzUxZZq6JeVI9bXrS74JoPtVAUKo2xzYuGKTg/MwbC7u2Off60BJ1WMHpBk4tr4LwEKi3Sey3dEB3G5sphsUcUktnQQOI05YVQgFn6UV0ChoKsDrjRQ8ZuwgjqIWVJVyjZiUDfgXhyt3MGzabvHRIdr9bGeNA+1W0i0NxK2E+ax7C4RGDpDKOF8c+3Yjcd/5QHDPpk8fcuVTIfYUxelb8cQzjqn40pUooKxwUP7B92MEYOlm2tSfvkMrZXXiPIdwWhsVrM04Yh2m1OW79EhFzFyPew2R0gZwCxjafQri0Hz1iYgarpBran+eEw01tp5NlmUsvedHlddzUGhKY9yANr/cYG3H0csvyi4l390KjvHOR7TAQ0EOvYl5+OWApd0Z80WSLjBs2IxNSDk2O7CkDQoJ4jjeXyv64p6CSWu45MUcPQZfaoiHNcrT5QgwUevTLU8DYWuzyWGcn/SpB4HtAzqSNwEF8l/X3LrJUtnCD2KgNM3swR4nCPoa+D7N7IEp7xJRGoWsxiEBKEaNk4jAFUugngctKD1ydKwbCo9HgLh3xYjAMLewqrwRNGPq5PYLKydxb3Uvs9Ytxef887zNs8NoRG6qWmdeMqKsB+bStnSO1W5dNEVJkJ/hw57UaOgaICdxTQOpQR19CiFa/HHPQLfHjEjZwhNQHWPuC3WyrbJq6fC+xx3ZSr88OuM0LDJrBLrGbVUzo8LB+syjgfEm7Tmi0A1yUVXUH/UEmBEEvIPT0lqEzaaKGM9mfGe5pxMabyYKN+RjjOT5zCFxH5K2HPDWFqQMGP+VaToAxH/E6Nb/Ssk+0fZ9cyr31hh2st3lRlh8eQGJiuDqT7y1RVYX4Eo/sR0qQJmn5EFbnv1VXOzjciqgSdrjygBVax0CEqcVINMMxkJeTLSbZt8ZG98duj7wrOwvry/Yxl5r3G3aRfYjLjHgVSbRgkvZ5t8j/rNJGnz5X3HWpGEYabWHnkROoJKn+3AJ5va8Z/mgljMlGwE9NiALFRkKMBlkFYnpjhqictTO5V8/udhklAWaDxNMybjWHm/5diNodex7u4vXHCTBhXNJm16wGxj+lTeR5fFRVr6Rrf2GubcZgRCouBGkXmBjHnm/WqZAqtkP0aT6FI4IGuM1x/pWJXd3PvSf2QQZOYoYajbAtF1gifobgbIofZy+8m5S2iYwjGWFca49BOeRgVhowKYTx8oxHRQjmC5r1Vhug1eIC5Q6JLhWoNYGvDLk0kBftWaI+nMzx3f34CA/oLWO9Eh4j7RbbYBczBuynSHboTXkN4ABpDpYb5aQfWwqzFAFnSE1r4UKwSKM5dzgiuaDI+AIOYQrXJggmhyEBLwCe253bFaLgtaHCQU22iXcISkt8tgv0EC7a45at1lm77/K8GKLYJpanQvZ92VY+u9Cg8cgGk3N0AnL980e27zD1dXhJxoCLYlkM/uW9tDegAcz1gyK6owcaICWGsTMaFGqmvGs+Qi8mEBEQSzSYDU+prx1eQ5DSZ+/iY3u8SVRMvAkE7kPZfj8sJ0h6DIFCSr1tWEwq8EDajqwdtvqZi2Xe5bo6zLzeFJcsIUCDBqS3CVegQ2GFMT1oMmjt+OtzvQkNUmMZZl67dcwRg9rU7XD0sEFtBtgGCNIQMUdSkloJwYIP/+3/Av/ILXL+KdtzAAAAAElFTkSuQmCC";
var orangeB = "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";
var overlay = "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";
var divider = "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";
var pick = "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";
var drop = "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";
var pickGray = "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";
var dropGray = "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";
var shoot = "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";
var shootGray = "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";


ModPE.setItem(470, "record_11", 0, "传送枪");
Item.setMaxDamage(470, 1000);
Item.addShapedRecipe(470, 1, 0, [
	"f f",
	" d ",
	"f f"], ["f", 265, 0, "d", 264, 0]);

ModPE.setItem(471, "record_13", 0, "黄金传送枪");
Item.setMaxDamage(471, 500);
Item.addShapedRecipe(471, 1, 0, [
	"f f",
	" g ",
	"f f"], ["f", 265, 0, "g", 266, 0]);

ModPE.setItem(472, "record_blocks", 0, "钢铁传送枪");
Item.setMaxDamage(472, 250);
Item.addShapedRecipe(472, 1, 0, [
	"fff",
	"f f",
	"fff"], ["f", 265, 0]);

ModPE.setItem(473, "record_cat", 0, "岩浆传送枪");
Item.setMaxDamage(473, 200);
Item.addShapedRecipe(473, 1, 0, [
	"f f",
	" a ",
	"f f"], ["f", 265, 0, "a", 259, 0]);

ModPE.setItem(474, "record_chirp", 0, "石头和木头传送枪");
Item.setMaxDamage(474, 100);
Item.addShapedRecipe(474, 1, 0, [
	"sws",
	"s s",
	"sws"], ["s", 98, 0, "w", 17, 0]);

ModPE.setItem(477, "record_far", 0, "传送枪");
Item.setMaxDamage(477, 1000);

ModPE.setItem(479, "record_mellohi", 0, "重力枪");
Item.setMaxDamage(479, 400);
Item.addShapedRecipe(479, 1, 0, [
	"frf",
	"r r",
	"frf"], ["f", 265, 0, "r", 331, 0]);

ModPE.setItem(480, "record_stal", 0, "Turrets Options");

ModPE.setItem(478, "record_strad", 0, "炮塔");

ModPE.setItem(475, "record_wait", 0, "传送须知");
Item.addShapedRecipe(475, 1, 0, [
	"   ",
	" w ",
	"   "], ["w", 17, 0]);

ModPE.setItem(476, "record_ward", 0, "重力鞋");
Item.addShapedRecipe(476, 1, 0, [
	"   ",
	"f f",
	"r r"], ["f", 265, 0, "r", 331, 0]);

ModPE.langEdit("item.bootsChain.name", "重力鞋");
Item.setMaxDamage(305, 1500);
Item.addShapedRecipe(305, 1, 0, [
	"   ",
	"   ",
	"l l"], ["l", 476, 0,]);
	
	
	//Block.setShape(blockId, minX, minY, minZ, maxX, maxY, maxZ);

	// Type 1
	//orange z min down
	Block.defineBlock(187, "Orange portal z-min-d", "repeater_off", 0, false, 7);
	Block.setShape(187, 0, 0, 0, 1, 1, 0);
	Block.setDestroyTime(187, 3);
	Block.setRenderLayer(187, 1);
	//Block.setLightLevel(187, 5);
	
	//orange z min up
	Block.defineBlock(188, "Orange portal z-min-up", "repeater_on", 0, false, 7);
	Block.setShape(188, 0, 0, 0, 1, 1, 0);
	Block.setDestroyTime(188, 3);
	Block.setRenderLayer(188, 1);
	//Block.setLightLevel(188, 5);


	// Type 2
	//orange z max down
	Block.defineBlock(189, "Orange portal z-max-d", "repeater_off", 0, false, 7);
	Block.setShape(189, 0, 0, 1, 1, 1, 1);
	Block.setDestroyTime(189, 3);
	Block.setRenderLayer(189, 1);
	//Block.setLightLevel(189, 5);

	//orange z max up
	Block.defineBlock(190, "Orange portal z-max-up", "repeater_on", 0, false, 7);
	Block.setShape(190, 0, 0, 1, 1, 1, 1);
	Block.setDestroyTime(190, 3);
	Block.setRenderLayer(190, 1);
	//Block.setLightLevel(190, 5);


	// Type 3
	//orange y min down
	Block.defineBlock(191, "Orange portal y-min-d", "repeater_off", 0, false, 7);
	Block.setShape(191, 0, 0, 0, 1, 0, 1);
	Block.setDestroyTime(191, 3);
	Block.setRenderLayer(191, 1);
	//Block.setLightLevel(191, 5);

	//orange y min up
	Block.defineBlock(192, "Orange portal y-min-up", "repeater_on", 0, false, 7);
	Block.setShape(192, 0, 0, 0, 1, 0, 1);
	Block.setDestroyTime(192, 3);
	Block.setRenderLayer(192, 1);
	//Block.setLightLevel(192, 5);


	// Type 4
	//orange y max down
	Block.defineBlock(193, "Orange portal y-max-d", "repeater_off", 0, false, 7);
	Block.setShape(193, 0, 1, 0, 1, 1, 1);
	Block.setDestroyTime(193, 3);
	Block.setRenderLayer(193, 1);
	//Block.setLightLevel(193, 5);

	//orange y max up
	Block.defineBlock(194, "Orange portal y-max-up", "repeater_on", 0, false, 7);
	Block.setShape(194, 0, 1, 0, 1, 1, 1);
	Block.setDestroyTime(194, 3);
	Block.setRenderLayer(194, 1);
	//Block.setLightLevel(194, 5);


	// Type 5
	//orange x min down
	Block.defineBlock(195, "Orange portal x-min-d", "repeater_off", 0, false, 7);
	Block.setShape(195, 0, 0, 0, 0, 1, 1);
	Block.setDestroyTime(195, 3);
	Block.setRenderLayer(195, 1);
	//Block.setLightLevel(195, 5);

	//orange x min up
	Block.defineBlock(196, "Orange portal x-min-up", "repeater_on", 0, false, 7);
	Block.setShape(196, 0, 0, 0, 0, 1, 1);
	Block.setDestroyTime(196, 3);
	Block.setRenderLayer(196, 1);
	//Block.setLightLevel(196, 5);


	// Type 6
	//orange x max down
	Block.defineBlock(197, "Orange portal x-max-d", "repeater_off", 0, false, 7);
	Block.setShape(197, 1, 0, 0, 1, 1, 1);
	Block.setDestroyTime(197, 3);
	Block.setRenderLayer(197, 1);
	//Block.setLightLevel(197, 5);

	//orange x max up
	Block.defineBlock(198, "Orange portal x-max-up", "repeater_on", 0, false, 7);
	Block.setShape(198, 1, 0, 0, 1, 1, 1);
	Block.setDestroyTime(198, 3);
	Block.setRenderLayer(198, 1);
	//Block.setLightLevel(198, 5);


	// Type 1
	//blue z min down
	Block.defineBlock(199, "Blue portal z-min-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(199, 0, 0, 0, 1, 1, 0);
	Block.setDestroyTime(199, 3);
	Block.setRenderLayer(199, 1);
	//Block.setLightLevel(199, 5);

	//blue z min up
	Block.defineBlock(200, "Blue portal z-min-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(200, 0, 0, 0, 1, 1, 0);
	Block.setDestroyTime(200, 3);
	Block.setRenderLayer(200, 1);
	//Block.setLightLevel(200, 5);


	// Type 2
	//blue z max down
	Block.defineBlock(201, "Blue portal z-max-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(201, 0, 0, 1, 1, 1, 1);
	Block.setDestroyTime(201, 3);
	Block.setRenderLayer(201, 1);
	//Block.setLightLevel(201, 5);

	//blue z max up
	Block.defineBlock(202, "Blue portal z-max-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(202, 0, 0, 1, 1, 1, 1);
	Block.setDestroyTime(202, 3);
	Block.setRenderLayer(202, 1);
	//Block.setLightLevel(202, 5);


	// Type 3
	//blue y min down
	Block.defineBlock(203, "Blue portal y-min-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(203, 0, 0, 0, 1, 0, 1);
	Block.setDestroyTime(203, 3);
	Block.setRenderLayer(203, 1);
	//Block.setLightLevel(203, 5);

	//blue y min up
	Block.defineBlock(204, "Blue portal y-min-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(204, 0, 0, 0, 1, 0, 1);
	Block.setDestroyTime(204, 3);
	Block.setRenderLayer(204, 1);
	//Block.setLightLevel(204, 5);


	// Type 4
	//blue y max down
	Block.defineBlock(205, "Blue portal y-max-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(205, 0, 1, 0, 1, 1, 1);
	Block.setDestroyTime(205, 3);
	Block.setRenderLayer(205, 1);
	//Block.setLightLevel(205, 5);

	//blue y max up
	Block.defineBlock(206, "Blue portal y-max-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(206, 0, 1, 0, 1, 1, 1);
	Block.setDestroyTime(206, 3);
	Block.setRenderLayer(206, 1);
	//Block.setLightLevel(206, 5);


	// Type 5
	//blue x min down
	Block.defineBlock(207, "Blue portal x-min-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(207, 0, 0, 0, 0, 1, 1);
	Block.setDestroyTime(207, 3);
	Block.setRenderLayer(207, 1);
	//Block.setLightLevel(207, 5);

	//blue x min up
	Block.defineBlock(208, "Blue portal x-min-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(208, 0, 0, 0, 0, 1, 1);
	Block.setDestroyTime(208, 3);
	Block.setRenderLayer(208, 1);
	//Block.setLightLevel(208, 5);


	// Type 6
	//blue x max down
	Block.defineBlock(209, "Blue portal x-max-d", [["enchanting_table_side", 0]], 0, false, 7);
	Block.setShape(209, 1, 0, 0, 1, 1, 1);
	Block.setDestroyTime(209, 3);
	Block.setRenderLayer(209, 1);
	//Block.setLightLevel(209, 5);

	//blue x max up
	Block.defineBlock(210, "Blue portal x-max-up", [["enchanting_table_top", 0]], 0, false, 7);
	Block.setShape(210, 1, 0, 0, 1, 1, 1);
	Block.setDestroyTime(210, 3);
	Block.setRenderLayer(210, 1);
	//Block.setLightLevel(210, 5);


	Block.defineBlock(220, "Portal Jukebox", [["jukebox_side", 0], ["jukebox_top", 0], ["jukebox_side", 0], ["jukebox_side", 0], ["jukebox_side", 0], ["jukebox_side", 0]]);
	Block.setDestroyTime(220, 1);
	Block.defineBlock(221, "Jumper", [["enchanting_table_bottom", 0]]);
	Block.setDestroyTime(221, 1);

	
function selectLevelHook()
{
	initialized = true;
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var portalSaveFolder = new java.io.File(new android.os.Environment.getExternalStorageDirectory() + "/games/com.mojang/minecraftWorlds/" + Level.getWorldDir() + "/portal_mod");
				portalSaveFolder.mkdirs();	
			}catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function newLevel()
{
	g[0] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(orangeB, 0), 0, android.util.Base64.decode(orangeB, 0).length);
	g[1] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(blueB, 0), 0, android.util.Base64.decode(blueB, 0).length);
	g[2] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(overlay, 0), 0, android.util.Base64.decode(overlay, 0).length);
	g[3] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(divider, 0), 0, android.util.Base64.decode(divider, 0).length);
	g[4] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(pick, 0), 0, android.util.Base64.decode(pick, 0).length);
	g[5] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(drop, 0), 0, android.util.Base64.decode(drop, 0).length);
	g[6] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(pickGray, 0), 0, android.util.Base64.decode(pickGray, 0).length);
	g[7] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(dropGray, 0), 0, android.util.Base64.decode(dropGray, 0).length);
	g[8] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(shoot, 0), 0, android.util.Base64.decode(shoot, 0).length);
	g[9] = android.graphics.BitmapFactory.decodeByteArray(android.util.Base64.decode(shootGray, 0), 0, android.util.Base64.decode(shootGray, 0).length);
	

	downloadMapsManifest();
	
	getLatestVersionPortalMod();
	if(latestVersion != CURRENT_VERSION && latestVersion != undefined)
		updateAvailableGUI();

	clientMessage("§fP§9O§fRTAL M§cO§fD " + CURRENT_VERSION + "作者： Desno365.");
	clientMessage("0.9.x版本的传送枪js还处于测试阶段");
	clientMessage("如果你有信息或者bug想反馈 请去百度贴吧反馈给okujtflp 我会反馈给作者");

	ModPE.playSoundFromFile("game-entry1.wav");
}

function leaveGame()
{
	if(fireButtonsInitialized)
	{
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
		run: function()
			{
				popupOrange.dismiss();
				popupBlue.dismiss();
				popupOverlay.dismiss();
				popupPick.dismiss();
				popupDrop.dismiss();
			}
		}));
		fireButtonsInitialized = false;
	}

	if(gravityButtonsInitialized)
	{
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
		run: function()
			{
				popupShoot.dismiss();
				popupDropGG.dismiss();
			}
		}));
		gravityButtonsInitialized = false;
	}

	initialized = false;
	countdownInitialized = 0;

	orangeInformations.length = 0;
	blueInformations.length = 0;
	arrowOrangeLaunched = false;
	arrowBlueLaunched = false;

	pickEnabledBool = false;
	currentPickDisplayed = false;
	isPickingEntity = false;
	currentDropDisplayed = false;
	currentGGButtonsDisplayed = false;

	displayedMessageTurretsBeta = false;
	displayedMessageWoodStone = false;
	displayedMessageNoSound = false;
	displayedMessagePortalInformations = false;

	turrets.lenght = 0;
	turrets = [[], [], [], [], [], [], [], [], [], []];
	spawnedTurretsNumber = 0;
	countdownToTheAttack = 0;

	sound1.reset();
	sound2.reset();
	music.reset();
}

function useItem(x, y, z, itemId, blockId, side, itemDamage)
{
	if(itemId == 474)
	{
		var random = Math.floor((Math.random() * 3) + 1);
		ModPE.playSoundFromFile("portals/portal_open" + random + ".wav");
		if(portalWithUseItem)
		{
			setPortalOrange(Math.floor(x), Math.floor(y), Math.floor(z));
			portalWithUseItem = !portalWithUseItem;
		}else
		{
			setPortalBlue(Math.floor(x), Math.floor(y), Math.floor(z));
			portalWithUseItem = !portalWithUseItem;
		}
		Item.damageCarried();
	}

	if(itemId == 475)
		informationsForPortalGUI();

	if(Level.getTile(x, y, z) == 220)
	{
		jukeboxGUI();
		preventDefault();
	}

	if(itemId == 478)
	{
		if(spawnedTurretsNumber >= 10)
			clientMessage("你现在不能召唤超过10个炮塔");
		else
		{
			ModPE.showTipMessage("用 'Turrets option' 去点击设置");
			if(!(displayedMessageTurretsBeta))
			{
				displayedMessageTurretsBeta = true;
				clientMessage("炮塔还在测试阶段");
			}

			var turret = Level.spawnMob(x + 0.5, y + 0.8, z + 0.5, 11, "mob/turret.png");
			Entity.setHealth(turret, 1);
			Entity.setRenderType(turret, TurretRenderType.renderType);
			turrets[spawnedTurretsNumber][0] = turret;
			turrets[spawnedTurretsNumber][1] = Entity.getX(turrets[spawnedTurretsNumber][0]);
			turrets[spawnedTurretsNumber][2] = Entity.getY(turrets[spawnedTurretsNumber][0]);
			turrets[spawnedTurretsNumber][3] = Entity.getZ(turrets[spawnedTurretsNumber][0]);
			ModPE.showTipMessage("用 'Turrets Options' 点击去设置");
			
			//aggressive
			turrets[spawnedTurretsNumber][4] = 0;

			//angle
			turrets[spawnedTurretsNumber][5] = 90;

			//countdown to the attack
			turrets[spawnedTurretsNumber][6] = 0;

			spawnedTurretsNumber++;
			saveTurrets();
		}
	}
}

function attackHook(attacker, victim)
{
	if(attacker == Player.getEntity())
	{
		//PortalGun gravity
		if(pickEnabledBool && (Player.getCarriedItem() == 470 || Player.getCarriedItem() == 471 || Player.getCarriedItem() == 472 || Player.getCarriedItem() == 473 || Player.getCarriedItem() == 477))
		{
			preventDefault();
			ggMob = victim;
			isPickingEntity = true;
			for(var i = 0; i < spawnedTurretsNumber; i++)
			{
				if(victim == turrets[i][0])
				{
					var random = Math.floor((Math.random() * 10) + 1);
					ModPE.playSoundFromFile("turrets/turret_pickup_" + random + ".wav");
					return;
				}
			}
			ModPE.playSoundFromFile("gravitygun/pickup.ogg");
		}

		//GravityGun
		if(Player.getCarriedItem() == 479 && !isPickingEntity)
		{
			preventDefault();
			ggMob = victim;
			isPickingEntity = true;
			Item.damageCarried();
			for(var i = 0; i < spawnedTurretsNumber; i++)
			{
				if(victim == turrets[i][0])
				{
					var random = Math.floor((Math.random() * 10) + 1);
					ModPE.playSoundFromFile("turrets/turret_pickup_" + random + ".wav");
					return;
				}
			}
			ModPE.playSoundFromFile("gravitygun/pickup.ogg");
		}

		//turrets options
		for(var i = 0; i < spawnedTurretsNumber; i++)
		{
			if(victim == turrets[i][0])
			{
				if(Player.getCarriedItem() == 480)
					turretsOptionsGUI(i);
				else
					ModPE.showTipMessage("你不能攻击炮塔");
				preventDefault();
			}
		}
	}
}

function deathHook(murderer, victim)
{
	//PortalGun gravity and GravityGun
	if(victim == ggMob)
	{
		ModPE.playSoundFromFile("gravitygun/fail.ogg");
		isPickingEntity = false;
	}
	
	//turrets
	for(var i = 0; i < spawnedTurretsNumber; i++)
	{
		if(victim == turrets[i][0])
		{
			turrets.splice(i, 1);
			turrets[9] = [];
			spawnedTurretsNumber--;
			var random = Math.floor((Math.random() * 9) + 1);
			ModPE.playSoundFromFile("turrets/turret_disabled_" + random + ".wav");
			saveTurrets();
		}
	}
}

function entityRemovedHook(entity)
{
	/*//PortalGun's arrows
	for (var i = 0; i < portalShotOrange.size(); i++)
	{
		if (Entity.getX(portalShotOrange.get(i)) == Entity.getX(entity))
		{
			var blockPlacer = portalShotOrange.get(i);
			var x = Entity.getX(blockPlacer);
			var y = Entity.getY(blockPlacer);
			var z = Entity.getZ(blockPlacer);
			
			arrowOrangeLaunched = false;
			
			setPortalOrange(Math.floor(x), Math.floor(y), Math.floor(z));

			portalShotOrange.remove(i);
			i--;
		}
	}
	for (var i = 0; i < portalShotBlue.size(); i++)
	{
		if (Entity.getX(portalShotBlue.get(i)) == Entity.getX(entity))
		{
			var blockPlacer = portalShotBlue.get(i);
			var x = Entity.getX(blockPlacer);
			var y = Entity.getY(blockPlacer);
			var z = Entity.getZ(blockPlacer);
			
			arrowBlueLaunched = false;
			
			setPortalBlue(Math.floor(x), Math.floor(y), Math.floor(z));

			portalShotBlue.remove(i);
			i--;
		}
	}not called on MCPE 0.9.3 and BL 1.7.2, fixed by using modTick()*/

	//PortalGun gravity and GravityGun
	if(entity == ggMob)
	{
		ModPE.playSoundFromFile("gravitygun/fail.ogg");
		isPickingEntity = false;
	}

	//turrets
	for(var i = 0; i < spawnedTurretsNumber; i++)
	{
		if(entity == turrets[i][0])
		{
			turrets.splice(i, 1);
			turrets[9] = [];
			spawnedTurretsNumber--;
			saveTurrets();
		}
	}
	if(Entity.getEntityTypeId(entity) == 81 && checkProximity(Player.getEntity(), entity, 1.4))
		Player.setHealth(Entity.getHealth(Player.getEntity()) - 2);
}

function destroyBlock(x, y, z)
{
	if(Math.floor(x) == orangeInformations[0] && Math.floor(y) == orangeInformations[1] && Math.floor(z) == orangeInformations[2])
	{
		generatedPortalOrange = false;
		Level.setTile(orangeInformations[3], orangeInformations[4], orangeInformations[5], 0);
		savePortalsToDelete();
	}
	if(Math.floor(x) == orangeInformations[3] && Math.floor(y) == orangeInformations[4] && Math.floor(z) == orangeInformations[5])
	{
		generatedPortalOrange = false;
		Level.setTile(orangeInformations[0], orangeInformations[1], orangeInformations[2], 0);
		savePortalsToDelete();
	}

	if(Math.floor(x) == blueInformations[0] && Math.floor(y) == blueInformations[1] && Math.floor(z) == blueInformations[2])
	{
		generatedPortalBlue = false;
		Level.setTile(blueInformations[3], blueInformations[4], blueInformations[5], 0);
		savePortalsToDelete();
	}
	if(Math.floor(x) == blueInformations[3] && Math.floor(y) == blueInformations[4] && Math.floor(z) == blueInformations[5])
	{
		generatedPortalBlue = false;
		Level.setTile(blueInformations[0], blueInformations[1], blueInformations[2], 0);
		savePortalsToDelete();
	}
}

function procCmd(cmd)
{
	var data = cmd.split(" ");
	var command = data[0];
	switch(command)
	{
		case 'portal-gun':
		case 'portalgun':
		case 'Portal-gun':
		case 'PortalGun':
		{
			Player.addItemInventory(470, 1, 0);
			break;
		}
		case 'enable':
		case 'mobs-support':
		case 'Enable':
		case 'Mobs-support':
		{
			warningEveryEntity();
			break;
		}
		case 'disable':
		case 'no-mobs':
		case 'Disable':
		case 'No-mobs':
		{
			portalsWithEveryEntity = false;
			clientMessage("Disabled mobs support.")
			break;
		}
	}
}

function modTick()
{
	//initialized
	if(initialized)
	{
		countdownInitialized++;
		if(countdownInitialized == 40)
		{
			loadPortalsToDelete();
			var mobs = Entity.getAll();
			for(var i in mobs)
			{
				if(Entity.getEntityTypeId(mobs[i]) == 11)
					Entity.remove(mobs[i]);
			}
			loadTurrets();
			initialized = false;
		}
	}

	//player carrying a PortalGun
	if(Player.getCarriedItem() == 470 || Player.getCarriedItem() == 471 || Player.getCarriedItem() == 472 || Player.getCarriedItem() == 473 || Player.getCarriedItem() == 477)
	{
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
			run: function()
			{
				try
				{
					if(!fireButtonsInitialized)
					{
						ModPE.playSoundFromFile("portalgun/portalgun_powerup1.wav");


						popupOrange = new android.widget.PopupWindow();
						var layoutOrange = new android.widget.RelativeLayout(currentActivity);

						var orangeImage = new android.widget.ImageView(currentActivity);
						orangeImage.setImageBitmap(g[0]);
						orangeImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							if(portalShotOrange.size() < 1)
							{
								ModPE.playSoundFromFile("portalgun/portalgun_shoot_red1.wav");
								var gunShootDir = lookDir(getYaw(), getPitch());
								orangeThrow = Level.spawnMob(getPlayerX() + (gunShootDir.x * 2), getPlayerY() + (gunShootDir.y * 2), getPlayerZ() + (gunShootDir.z * 2), 80);
								if(Player.getCarriedItem() == 473)
									Entity.setFireTicks(orangeThrow, 100);
								//Entity.setRenderType(orangeThrow, 18); not working on 0.9.3
								arrowOrangeLaunched = true;
								var speedO = Item.getSpeed();
								setVelX(orangeThrow, gunShootDir.x * speedO);
								setVelY(orangeThrow, gunShootDir.y * speedO);
								setVelZ(orangeThrow, gunShootDir.z * speedO);
								portalShotOrange.addElement(orangeThrow);
								Item.damageCarried();
								if(Player.getCarriedItem() == 470)
									Item.changePortalColor();
							}
						}}));
						layoutOrange.addView(orangeImage);

						popupOrange.setContentView(layoutOrange);
						popupOrange.setWidth(72);
						popupOrange.setHeight(72);
						popupOrange.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupOrange.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, 0);


						popupBlue = new android.widget.PopupWindow();
						var layoutBlue = new android.widget.RelativeLayout(currentActivity);

						var blueImage = new android.widget.ImageView(currentActivity);
						blueImage.setImageBitmap(g[1]);
						blueImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							if(portalShotBlue.size() < 1)
							{
								ModPE.playSoundFromFile("portalgun/portalgun_shoot_blue1.wav");
								var gunShootDir = lookDir(getYaw(), getPitch());
								blueThrow = Level.spawnMob(getPlayerX() + (gunShootDir.x * 2), getPlayerY() + (gunShootDir.y * 2), getPlayerZ() + (gunShootDir.z * 2), 80);
								if(Player.getCarriedItem() == 473)
									Entity.setFireTicks(blueThrow, 100);
								//Entity.setRenderType(blueThrow, 18); not working on 0.9.3
								arrowBlueLaunched = true;
								var speedB = Item.getSpeed();
								setVelX(blueThrow, gunShootDir.x * speedB);
								setVelY(blueThrow, gunShootDir.y * speedB);
								setVelZ(blueThrow, gunShootDir.z * speedB);
								portalShotBlue.addElement(blueThrow);
								Item.damageCarried();
								if(Player.getCarriedItem() == 477)
									Item.changePortalColor();
							}
						}}));
						layoutBlue.addView(blueImage);

						popupBlue.setContentView(layoutBlue);
						popupBlue.setWidth(72);
						popupBlue.setHeight(72);
						popupBlue.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupBlue.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, 0);


						popupOverlay = new android.widget.PopupWindow();
						var layoutOverlay = new android.widget.RelativeLayout(currentActivity);

						var overlayImage = new android.widget.ImageView(currentActivity);
						overlayImage.setImageBitmap(g[2]);
						layoutOverlay.addView(overlayImage);

						popupOverlay.setContentView(layoutOverlay);
						popupOverlay.setWidth(50);
						popupOverlay.setHeight(78);
						popupOverlay.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupOverlay.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.CENTER | android.view.Gravity.CENTER, 0, 0);


						pickEnabledBool = false;
						popupPick = new android.widget.PopupWindow();
						layoutPick = new android.widget.RelativeLayout(currentActivity);

						var pickImage = new android.widget.ImageView(currentActivity);
						pickImage.setImageBitmap(g[6]);
						pickImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							pickEnabledBool = true;
							ModPE.showTipMessage("抓取模式开启 攻击一个生物来抓取");
						}}));
						layoutPick.addView(pickImage);

						popupPick.setContentView(layoutPick);
						popupPick.setWidth(72);
						popupPick.setHeight(40);
						popupPick.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupPick.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);
						

						isPickingEntity = false;
						popupDrop = new android.widget.PopupWindow();
						layoutDrop = new android.widget.RelativeLayout(currentActivity);

						var dropImage = new android.widget.ImageView(currentActivity);
						dropImage.setImageBitmap(g[7]);
						dropImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							ModPE.playSoundFromFile("gravitygun/fail.ogg");
							ModPE.showTipMessage("当你举起一个生物才可以放下");
						}}));
						layoutDrop.addView(dropImage);

						popupDrop.setContentView(layoutDrop);
						popupDrop.setWidth(72);
						popupDrop.setHeight(40);
						popupDrop.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupDrop.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);


						fireButtonsInitialized = true;
					}

					if(pickEnabledBool != currentPickDisplayed)
					{
						if(pickEnabledBool)
						{
							popupPick.dismiss();

							popupPick = new android.widget.PopupWindow();
							layoutPick = new android.widget.RelativeLayout(currentActivity);

							var pickImage = new android.widget.ImageView(currentActivity);
							pickImage.setImageBitmap(g[4]);
							pickImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								pickEnabledBool = false;
								ModPE.showTipMessage("抓取模式关闭");
							}}));
							layoutPick.addView(pickImage);

							popupPick.setContentView(layoutPick);
							popupPick.setWidth(72);
							popupPick.setHeight(40);
							popupPick.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupPick.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);

							currentPickDisplayed = true;
						}else
						{
							popupPick.dismiss();

							popupPick = new android.widget.PopupWindow();
							layoutPick = new android.widget.RelativeLayout(currentActivity);

							var pickImage = new android.widget.ImageView(currentActivity);
							pickImage.setImageBitmap(g[6]);
							pickImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								pickEnabledBool = true;
								ModPE.showTipMessage("抓取模式开启 点击一个生物抓取");
							}}));
							layoutPick.addView(pickImage);

							popupPick.setContentView(layoutPick);
							popupPick.setWidth(72);
							popupPick.setHeight(40);
							popupPick.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupPick.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);

							currentPickDisplayed = false;
						}
					}

					if(isPickingEntity != currentDropDisplayed)
					{
						if(isPickingEntity)
						{
							popupDrop.dismiss();

							popupDrop = new android.widget.PopupWindow();
							layoutDrop = new android.widget.RelativeLayout(currentActivity);

							var dropImage = new android.widget.ImageView(currentActivity);
							dropImage.setImageBitmap(g[5]);
							dropImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.playSoundFromFile("gravitygun/drop.ogg");
								isPickingEntity = false;
							}}));
							layoutDrop.addView(dropImage);

							popupDrop.setContentView(layoutDrop);
							popupDrop.setWidth(72);
							popupDrop.setHeight(40);
							popupDrop.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupDrop.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);

							currentDropDisplayed = true;
						}else
						{
							popupDrop.dismiss();

							popupDrop = new android.widget.PopupWindow();
							layoutDrop = new android.widget.RelativeLayout(currentActivity);

							var dropImage = new android.widget.ImageView(currentActivity);
							dropImage.setImageBitmap(g[7]);
							dropImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.showTipMessage("当你举着生物的时侯才可以把它放下");
							}}));
							layoutDrop.addView(dropImage);

							popupDrop.setContentView(layoutDrop);
							popupDrop.setWidth(72);
							popupDrop.setHeight(40);
							popupDrop.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupDrop.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);

							currentDropDisplayed = false;
						}
					}
				}catch(err)
				{
					clientMessage("Error: " + err);
				}
			}
		}));
	}else
	{
		if(fireButtonsInitialized)
		{
			currentActivity.runOnUiThread(new java.lang.Runnable(
			{
			run: function()
				{
					popupOrange.dismiss();
					popupBlue.dismiss();
					popupOverlay.dismiss();
					popupPick.dismiss();
					popupDrop.dismiss();
				}
			}));
			fireButtonsInitialized = false;
			pickEnabledBool = false;
			isPickingEntity = false;
		}
	}

	//player carrying GravityGun
	if(Player.getCarriedItem() == 479)
	{
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
			run: function()
			{
				try
				{
					if(!gravityButtonsInitialized)
					{
						ModPE.playSoundFromFile("gravitygun/equip.ogg");
						isPickingEntity = false;
						currentGGButtonsDisplayed = false;

						popupShoot = new android.widget.PopupWindow();
						layoutShoot = new android.widget.RelativeLayout(currentActivity);

						var shootImage = new android.widget.ImageView(currentActivity);
						shootImage.setImageBitmap(g[9]);
						shootImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							ModPE.playSoundFromFile("gravitygun/fail.ogg");
							ModPE.showTipMessage("当你举着一个生物才可以把他射出去");
						}}));
						layoutShoot.addView(shootImage);

						popupShoot.setContentView(layoutShoot);
						popupShoot.setWidth(72);
						popupShoot.setHeight(40);
						popupShoot.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupShoot.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);
						

						popupDropGG = new android.widget.PopupWindow();
						layoutDropGG = new android.widget.RelativeLayout(currentActivity);

						var dropGGImage = new android.widget.ImageView(currentActivity);
						dropGGImage.setImageBitmap(g[7]);
						dropGGImage.setOnClickListener(new android.view.View.OnClickListener({
						onClick: function()
						{
							ModPE.playSoundFromFile("gravitygun/fail.ogg");
							ModPE.showTipMessage("当你举着一个生物才可以把它放下");
						}}));
						layoutDropGG.addView(dropGGImage);

						popupDropGG.setContentView(layoutDropGG);
						popupDropGG.setWidth(72);
						popupDropGG.setHeight(40);
						popupDropGG.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
						popupDropGG.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);


						gravityButtonsInitialized = true;
					}

					if(isPickingEntity != currentGGButtonsDisplayed)
					{
						if(isPickingEntity)
						{
							popupDropGG.dismiss();
							popupShoot.dismiss();


							popupShoot = new android.widget.PopupWindow();
							layoutShoot = new android.widget.RelativeLayout(currentActivity);

							var shootImage = new android.widget.ImageView(currentActivity);
							shootImage.setImageBitmap(g[8]);
							shootImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.playSoundFromFile("gravitygun/fire.ogg");
								isPickingEntity = false;
								var shootGgMob = lookDir(getYaw(), getPitch());
								setVelX(ggMob, shootGgMob.x * 3.3);
								setVelY(ggMob, shootGgMob.y * 3.3);
								setVelZ(ggMob, shootGgMob.z * 3.3);
							}}));
							layoutShoot.addView(shootImage);

							popupShoot.setContentView(layoutShoot);
							popupShoot.setWidth(72);
							popupShoot.setHeight(40);
							popupShoot.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupShoot.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);
							

							popupDropGG = new android.widget.PopupWindow();
							layoutDropGG = new android.widget.RelativeLayout(currentActivity);

							var dropGGImage = new android.widget.ImageView(currentActivity);
							dropGGImage.setImageBitmap(g[5]);
							dropGGImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.playSoundFromFile("gravitygun/drop.ogg");
								isPickingEntity = false;
							}}));
							layoutDropGG.addView(dropGGImage);

							popupDropGG.setContentView(layoutDropGG);
							popupDropGG.setWidth(72);
							popupDropGG.setHeight(40);
							popupDropGG.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupDropGG.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);

							
							currentGGButtonsDisplayed = true;
						}else
						{
							popupDropGG.dismiss();
							popupShoot.dismiss();


							popupShoot = new android.widget.PopupWindow();
							layoutShoot = new android.widget.RelativeLayout(currentActivity);

							var shootImage = new android.widget.ImageView(currentActivity);
							shootImage.setImageBitmap(g[9]);
							shootImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.playSoundFromFile("gravitygun/fail.ogg");
								ModPE.showTipMessage("当你举着一个生物才可以把它射出去");
							}}));
							layoutShoot.addView(shootImage);

							popupShoot.setContentView(layoutShoot);
							popupShoot.setWidth(72);
							popupShoot.setHeight(40);
							popupShoot.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupShoot.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, -60);
							

							popupDropGG = new android.widget.PopupWindow();
							layoutDropGG = new android.widget.RelativeLayout(currentActivity);

							var dropGGImage = new android.widget.ImageView(currentActivity);
							dropGGImage.setImageBitmap(g[7]);
							dropGGImage.setOnClickListener(new android.view.View.OnClickListener({
							onClick: function()
							{
								ModPE.playSoundFromFile("gravitygun/fail.ogg");
								ModPE.showTipMessage("当你举起一个生物才可以把它放下去");
							}}));
							layoutDropGG.addView(dropGGImage);

							popupDropGG.setContentView(layoutDropGG);
							popupDropGG.setWidth(72);
							popupDropGG.setHeight(40);
							popupDropGG.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
							popupDropGG.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -60);


							currentGGButtonsDisplayed = false;
						}
					}
				}catch(err)
				{
					clientMessage("Error: " + err);
				}
			}
		}));
	}else
	{
		if(gravityButtonsInitialized)
		{
			currentActivity.runOnUiThread(new java.lang.Runnable(
			{
			run: function()
				{
					popupShoot.dismiss();
					popupDropGG.dismiss();
				}
			}));
			gravityButtonsInitialized = false;
			isPickingEntity = false;
		}
	}

	//PortalGun gravity and GravityGun
	if(isPickingEntity)
	{
		var ggMobDirection = lookDir (Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()));
		if (getPlayerX () + (ggMobDirection.x * 3) - Entity.getX (ggMob) > 0.5 ||  getPlayerX () + (ggMobDirection.x * 3) - Entity.getX (ggMob) < -0.5 || getPlayerY () + (ggMobDirection.y * 3) - Entity.getY (ggMob) > 0.5 ||  getPlayerY () + (ggMobDirection.y * 3) - Entity.getY (ggMob) < -0.5 || getPlayerZ () + (ggMobDirection.z * 3) - Entity.getZ (ggMob) > 0.5 ||  getPlayerZ () + (ggMobDirection.z * 3) - Entity.getZ (ggMob) < -0.5)
		{
			Entity.setVelX(ggMob, (getPlayerX () + (ggMobDirection.x * 3) - Entity.getX(ggMob)) / 5)
			Entity.setVelY(ggMob, (getPlayerY () + (ggMobDirection.y * 3) - Entity.getY(ggMob)) / 5);
			Entity.setVelZ(ggMob, (getPlayerZ () + (ggMobDirection.z * 3) - Entity.getZ(ggMob)) / 5);
		}
		else
		{
			Entity.setVelX(ggMob, 0);
			Entity.setVelY(ggMob, 0);
			Entity.setVelZ(ggMob, 0);
		}
	}

	//player carrying the Portal Wood & Stone item
	if(Player.getCarriedItem() == 474)
	{
		if(!displayedMessageWoodStone)
		{
			ModPE.showTipMessage("Tap on a block to place a Portal.");
			displayedMessageWoodStone = true;
		}
	}else
	{
		if(displayedMessageWoodStone)
			displayedMessageWoodStone = false;
	}

	//player carrying the Portal Informations item
	if(Player.getCarriedItem() == 475)
	{
		if(!displayedMessagePortalInformations)
		{
			ModPE.showTipMessage("Tap on a block to open the GUI.");
			displayedMessagePortalInformations = true;
		}
	}else
	{
		if(displayedMessagePortalInformations)
			displayedMessagePortalInformations = false;
	}

	//arrow is arrived?
	if(arrowOrangeLaunched)
	{
		var xArrowO = Entity.getX(orangeThrow);
		var yArrowO = Entity.getY(orangeThrow);
		var zArrowO = Entity.getZ(orangeThrow);
		if(xBeforeO == xArrowO && yBeforeO == yArrowO && zBeforeO == zArrowO)
		{
			//used for fixing entityRemovedHook()
			for (var i = 0; i < portalShotOrange.size(); i++)
			{
				if (Entity.getX(portalShotOrange.get(i)) == Entity.getX(orangeThrow))
				{
					var blockPlacer = portalShotOrange.get(i);
					var x = Entity.getX(blockPlacer);
					var y = Entity.getY(blockPlacer);
					var z = Entity.getZ(blockPlacer);
			
					arrowOrangeLaunched = false;
			
					setPortalOrange(Math.floor(x), Math.floor(y), Math.floor(z));

					portalShotOrange.remove(i);
					i--;
				}
			}
			
			Entity.remove(orangeThrow);
		}else
		{
			xBeforeO = xArrowO;
			yBeforeO = yArrowO;
			zBeforeO = zArrowO;
		}
	}
	if(arrowBlueLaunched)
	{
		var xArrowB = Entity.getX(blueThrow);
		var yArrowB = Entity.getY(blueThrow);
		var zArrowB = Entity.getZ(blueThrow);
		if(xBeforeB == xArrowB && yBeforeB == yArrowB && zBeforeB == zArrowB)
		{
			for (var i = 0; i < portalShotBlue.size(); i++)
			{
				if (Entity.getX(portalShotBlue.get(i)) == Entity.getX(blueThrow))
				{
					var blockPlacer = portalShotBlue.get(i);
					var x = Entity.getX(blockPlacer);
					var y = Entity.getY(blockPlacer);
					var z = Entity.getZ(blockPlacer);
	
					arrowBlueLaunched = false;
			
					setPortalBlue(Math.floor(x), Math.floor(y), Math.floor(z));

					portalShotBlue.remove(i);
					i--;
				}
			}
			
			Entity.remove(blueThrow);
		}else
		{
			xBeforeB = xArrowB;
			yBeforeB = yArrowB;
			zBeforeB = zArrowB;
		}
	}

	//player is in portal?
	if(generatedPortalBlue && generatedPortalOrange)
	{
		if(orangeInformations[6] == 4)
			entityIsInPortalOrange(Player.getEntity(), Player.getX(), Player.getY(), Player.getZ());
		else
			entityIsInPortalOrange(Player.getEntity(), Player.getX(), Player.getY() - 1, Player.getZ());

		if(blueInformations[6] == 4)
			entityIsInPortalBlue(Player.getEntity(), Player.getX(), Player.getY(), Player.getZ());
		else
			entityIsInPortalBlue(Player.getEntity(), Player.getX(), Player.getY() - 1, Player.getZ());
	}

	//jumper
	if(Level.getTile(Player.getX(), Player.getY() - 2, Player.getZ()) == 221)
	{
		var random = Math.floor((Math.random() * 4) + 3);
		ModPE.playSoundFromFile("jumper/alyx_gun_fire" + random + ".wav");
		var jumperDir = lookDir(getYaw(), getPitch());
		Entity.setVelX(Player.getEntity(), jumperDir.x * jumperPower * 0.3);
		Entity.setVelY(Player.getEntity(), jumperPower * 0.3);
		Entity.setVelZ(Player.getEntity(), jumperDir.z * jumperPower * 0.3);
	}

	//jumper and portals for mobs
	if(portalsWithEveryEntity)
	{
		if(speeder)
		{
			var mobs = Entity.getAll()
			for(var i in mobs)
			{
				var e = mobs[i];
				var eX = Entity.getX(e);
				var eY = Entity.getY(e);
				var eZ = Entity.getZ(e);

				//jumper
				if(Level.getTile(eX, eY - 0.9, eZ) == 221)
				{
					var random = Math.floor((Math.random() * 4) + 3);
					ModPE.playSoundFromFile("jumper/alyx_gun_fire" + random + ".wav");
					var jumperDir = lookDir(Entity.getYaw(e), Entity.getPitch(e));
					Entity.setVelX(e, jumperDir.x * jumperPower * 0.3);
					Entity.setVelY(e, jumperPower * 0.3);
					Entity.setVelZ(e, jumperDir.z * jumperPower * 0.3);
				}

				//portal
				if(generatedPortalOrange && generatedPortalBlue)
				{
					entityIsInPortalOrange(e, eX, eY + 0.1, eZ);
					entityIsInPortalBlue(e, eX, eY + 0.1, eZ);
				}
			}
			speeder = false;
		}else
			speeder = true;
	}

	//long fall boots
	if(infiniteHealth)
	{
		if(Level.getTile(Player.getX(), Player.getY() - 2, Player.getZ()))
		{
			countdownHealth++;
			if(countdownHealth == 1)
			{
				var random = Math.floor((Math.random() * 2) + 1);
				ModPE.playSoundFromFile("long_fall_boots/futureshoes" + random + ".wav");
			}
			if(countdownHealth == 2)
			{
				Player.setHealth(20);
				infiniteHealth = false;
				countdownHealth = 0;
				Player.setHealth(previousHealth);
				if(Player.getArmorSlotDamage(3) >= 1400)
					ModPE.showTipMessage("Long fall boots are about to break. Damage: " + Player.getArmorSlotDamage(3) + ".");
				if(Player.getArmorSlot(3) != 305)
					ModPE.showTipMessage("Long fall boots are broken.");
			}
		}
	}
	if(Player.getArmorSlot(3) == 305)
	{
		if(Entity.getVelY(Player.getEntity()) <= -0.6 && !infiniteHealth)
		{
			previousHealth = Entity.getHealth(Player.getEntity());
			if(previousHealth > 20)
			{
				previousHealth = 20;
			}
			Player.setHealth(9999);
			infiniteHealth = true;
		}
	}

	//turrets
	for(var i = 0; i < spawnedTurretsNumber; i++)
	{
		if(!(ggMob == turrets[i][0] && isPickingEntity))
		{
			//Entity.setPosition(turrets[i][0], turrets[i][1], Entity.getY(turrets[i][0]), turrets[i][3]);
			Entity.setVelX(turrets[i][0], 0);
			Entity.setVelY(turrets[i][0], 0);
			Entity.setVelZ(turrets[i][0], 0);
			//Entity.setRot(turrets[i][0], turrets[i][5], turrets[i][5]);

			if((turrets[i][4] == 1) && checkProximity(Player.getEntity(), turrets[i][0], 10))
			{
				turrets[i][6]++;
				if(turrets[i][6] == 1)
				{
					var random = Math.floor((Math.random() * 9) + 1);
					ModPE.playSoundFromFile("turrets/turret_active_" + random + ".wav");
					turrets[i][6] = turrets[i][6] + 5;
				}
				if(turrets[i][6] % 15 == 0 && turrets[i][6] >= 30)
				{
					var shotYaw = Math.atan2((Entity.getZ(turrets[i][0]) - Player.getZ()), (Entity.getX(turrets[i][0]) - Player.getX()));
					var turretShot = lookDir((((shotYaw * 180) / Math.PI) - 90), 0);
					var shotArrow = Level.spawnMob(Entity.getX(turrets[i][0]) + (-turretShot.x), Entity.getY(turrets[i][0]) + 1, Entity.getZ(turrets[i][0]) + (-turretShot.z), 81);
					Entity.setVelX(shotArrow, -turretShot.x * 2);
					Entity.setVelY(shotArrow, turretShot.y * 2);
					Entity.setVelZ(shotArrow, -turretShot.z * 2);
					var random = Math.floor((Math.random() * 4) + 3);
					ModPE.playSoundFromFile("jumper/alyx_gun_fire" + random + ".wav");
				}
			}else
			{
				if(turrets[i][6] != 0)
				{
					turrets[i][6] = 0;
					var random = Math.floor((Math.random() * 3) + 1);
					ModPE.playSoundFromFile("turrets/turret_search_" + random + ".wav");
				}
			}
		}
	}

	//momentum
	velBeforeY = Entity.getVelY(Player.getEntity());
}


//############################################################################
//Added functions
//############################################################################

function vector3d(x, y, z)
{
	this.x = x;
	this.y = y;
	this.z = z;
}

function lookDir(yaw, pitch)
{
	var direction = new vector3d(0, 0, 0);
	direction.y = -Math.sin(java.lang.Math.toRadians(pitch));
	direction.x = -Math.sin(java.lang.Math.toRadians(yaw)) * Math.cos(java.lang.Math.toRadians(pitch));
	direction.z = Math.cos(java.lang.Math.toRadians (yaw)) * Math.cos(java.lang.Math.toRadians(pitch));
	return direction;
}

function setPortalOrange(x, y ,z)
{
	var pX = Player.getX();
	var pY = Player.getY();
	var pZ = Player.getZ();

	if(Level.getTile(x, y ,z) != 0)
	{
		//USE ITEM AND SNOWBALL
		if(Level.getTile(x, y + 1, z) != 0)
		{
			if(Math.abs(pX - x) > Math.abs(pZ - z))
			{
				if(x < pX)
				{
					if(Level.getTile(x + 1, y ,z) == 0 && Level.getTile(x + 1, y + 1 ,z) == 0)
					{

						Level.setTile(x + 1, y, z, 195, 0);
						Level.setTile(x + 1, y + 1, z, 196, 0);
						savePortalAndDeleteOrange(x+1, y, z, x+1, y+1, z);
						orangeInformations[6] = 5;
					}
				}else
				{
					if(Level.getTile(x - 1, y ,z) == 0 && Level.getTile(x - 1, y + 1 ,z) == 0)
					{

						Level.setTile(x - 1, y, z, 197, 0);
						Level.setTile(x - 1, y + 1, z, 198, 0);
						savePortalAndDeleteOrange(x-1, y, z, x-1, y+1, z);
						orangeInformations[6] = 6;
					}
				}
			}else
			{
				if(z < pZ)
				{
					if(Level.getTile(x, y ,z + 1) == 0 && Level.getTile(x, y + 1 ,z + 1) == 0)
					{

						Level.setTile(x, y, z + 1, 187, 0);
						Level.setTile(x, y + 1, z + 1, 188, 0);
						savePortalAndDeleteOrange(x, y, z+1, x, y+1, z+1);
						orangeInformations[6] = 1;
					}
				}else
				{
					if(Level.getTile(x, y ,z - 1) == 0 && Level.getTile(x, y + 1 ,z - 1) == 0)
					{

						Level.setTile(x, y, z - 1, 189, 0);
						Level.setTile(x, y + 1, z - 1, 190, 0);
						savePortalAndDeleteOrange(x, y, z-1, x, y+1, z-1);
						orangeInformations[6] = 2;
					}
				}
			}
		}else
		{
			if(Level.getTile(x, y + 1, z + 1) == 0)
			{

				Level.setTile(x, y + 1, z, 192);
				Level.setTile(x, y + 1, z + 1, 191);
				savePortalAndDeleteOrange(x, y+1, z, x, y+1, z+1);
				orangeInformations[6] = 3;
			}else
			if(Level.getTile(x, y + 1, z - 1) == 0)
			{

				Level.setTile(x, y + 1, z, 191);
				Level.setTile(x, y + 1, z - 1, 192);	
				savePortalAndDeleteOrange(x, y+1, z, x, y+1, z-1);
				orangeInformations[6] = 3;
			}
		}
	}else
	{
		//ARROW
		if(Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
		{
			if(Level.getTile(x, y - 1, z) != 0)
			{
				Level.setTile(x, y, z, 192);
				Level.setTile(x, y, z + 1, 191);
				savePortalAndDeleteOrange(x, y, z, x, y, z+1);
				orangeInformations[6] = 3;
				return;
			}else
			if(Level.getTile(x, y + 1, z) != 0)
			{
				Level.setTile(x, y, z, 194);
				Level.setTile(x, y, z + 1, 193);
				savePortalAndDeleteOrange(x, y, z, x, y, z+1);
				orangeInformations[6] = 4;
				return;
			}
		}else
		{
			if(Level.getTile(x + 1, y, z) != 0 && Level.getTile(x - 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 197, 0);
					Level.setTile(x, y + 1, z, 198, 0);
					savePortalAndDeleteOrange(x, y, z, x, y+1, z);
					orangeInformations[6] = 6;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 198, 0);
						Level.setTile(x, y - 1, z, 197, 0);
						savePortalAndDeleteOrange(x, y, z, x, y-1, z);
						orangeInformations[6] = 6;
						return;
					}
				}
			}
			if(Level.getTile(x, y, z + 1) != 0 && Level.getTile(x, y, z - 1) == 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 189, 0);
					Level.setTile(x, y + 1, z, 190, 0);
					savePortalAndDeleteOrange(x, y, z, x, y+1, z);
					orangeInformations[6] = 2;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 190, 0);
						Level.setTile(x, y - 1, z, 189, 0);
						savePortalAndDeleteOrange(x, y, z, x, y-1, z);
						orangeInformations[6] = 2;
						return;
					}
				}
			}
			if(Level.getTile(x - 1, y, z) != 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 195, 0);
					Level.setTile(x, y + 1, z, 196, 0);
					savePortalAndDeleteOrange(x, y, z, x, y+1, z);
					orangeInformations[6] = 5;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 196, 0);
						Level.setTile(x, y - 1, z, 195, 0);
						savePortalAndDeleteOrange(x, y, z, x, y-1, z);
						orangeInformations[6] = 5;
						return;
					}
				}
			}
			if(Level.getTile(x, y, z - 1) != 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 187, 0);
					Level.setTile(x, y + 1, z, 188, 0);
					savePortalAndDeleteOrange(x, y, z, x, y+1, z);
					orangeInformations[6] = 1;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 188, 0);
						Level.setTile(x, y - 1, z, 187, 0);
						savePortalAndDeleteOrange(x, y, z, x, y-1, z);
						orangeInformations[6] = 1;
						return;
					}
				}
			}
			if(pX < x && pZ < z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 197, 0);
						Level.setTile(x, y + 1, z, 198, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 6;
					return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 198, 0);
							Level.setTile(x, y - 1, z, 197, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 6;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 189, 0);
						Level.setTile(x, y + 1, z, 190, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 2;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 190, 0);
							Level.setTile(x, y - 1, z, 189, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 2;
							return;
						}
					}
				}
			}
			if(pX < x && pZ >= z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 197, 0);
						Level.setTile(x, y + 1, z, 198, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 6;
					return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 198, 0);
							Level.setTile(x, y - 1, z, 197, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 6;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 187, 0);
						Level.setTile(x, y + 1, z, 188, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 1;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 188, 0);
							Level.setTile(x, y - 1, z, 187, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 1;
							return;
						}
					}
				}
			}
			if(pX >= x && pZ >= z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 195, 0);
						Level.setTile(x, y + 1, z, 196, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 5;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 196, 0);
							Level.setTile(x, y - 1, z, 195, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 5;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 187, 0);
						Level.setTile(x, y + 1, z, 188, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 1;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 188, 0);
							Level.setTile(x, y - 1, z, 187, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 1;
							return;
						}
					}
				}
			}
			if(pX >= x && pZ < z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 195, 0);
						Level.setTile(x, y + 1, z, 196, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 5;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 196, 0);
							Level.setTile(x, y - 1, z, 195, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 5;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 189, 0);
						Level.setTile(x, y + 1, z, 190, 0);
						savePortalAndDeleteOrange(x, y, z, x, y+1, z);
						orangeInformations[6] = 2;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 190, 0);
							Level.setTile(x, y - 1, z, 189, 0);
							savePortalAndDeleteOrange(x, y, z, x, y-1, z);
							orangeInformations[6] = 2;
							return;
						}
					}
				}
			}
		}
	}
}

function setPortalBlue(x, y ,z)
{
	var pX = Player.getX();
	var pY = Player.getY();
	var pZ = Player.getZ();

	if(Level.getTile(x, y ,z) != 0)
	{
		// USE ITEM AND SNOWBALL
		if(Level.getTile(x, y + 1, z) != 0)
		{
			if(Math.abs(pX - x) > Math.abs(pZ - z))
			{
				if(x < pX)
				{
					if(Level.getTile(x + 1, y ,z) == 0 && Level.getTile(x + 1, y + 1 ,z) == 0)
					{

						Level.setTile(x + 1, y, z, 207, 0);
						Level.setTile(x + 1, y + 1, z, 208, 0);
						savePortalAndDeleteBlue(x+1, y, z, x+1, y+1, z);
						blueInformations[6] = 5;
					}
				}else
				{
					if(Level.getTile(x - 1, y ,z) == 0 && Level.getTile(x - 1, y + 1 ,z) == 0)
					{

						Level.setTile(x - 1, y, z, 209, 0);
						Level.setTile(x - 1, y + 1, z, 210, 0);
						savePortalAndDeleteBlue(x-1, y, z, x-1, y+1, z);
						blueInformations[6] = 6;
					}
				}
			}else
			{
				if(z < pZ)
				{
					if(Level.getTile(x, y ,z + 1) == 0 && Level.getTile(x, y + 1 ,z + 1) == 0)
					{

						Level.setTile(x, y, z + 1, 199, 0);
						Level.setTile(x, y + 1, z + 1, 200, 0);
						savePortalAndDeleteBlue(x, y, z+1, x, y+1, z+1);
						blueInformations[6] = 1;
					}
				}else
				{
					if(Level.getTile(x, y ,z - 1) == 0 && Level.getTile(x, y + 1 ,z - 1) == 0)
					{

						Level.setTile(x, y, z - 1, 201, 0);
						Level.setTile(x, y + 1, z - 1, 202, 0);
						savePortalAndDeleteBlue(x, y, z-1, x, y+1, z-1);
						blueInformations[6] = 2;
					}
				}
			}
		}else
		{
			if(Level.getTile(x, y + 1,z + 1) == 0)
			{

				Level.setTile(x, y + 1, z, 204, 0);
				Level.setTile(x, y + 1, z + 1, 203, 0);
				savePortalAndDeleteBlue(x, y+1, z, x, y+1, z+1);
				blueInformations[6] = 3;
			}else
			if(Level.getTile(x, y + 1,z - 1) == 0)
			{

				Level.setTile(x, y + 1, z, 203, 0);
				Level.setTile(x, y + 1, z - 1, 204, 0);	
				savePortalAndDeleteBlue(x, y+1, z, x, y+1, z-1);
				blueInformations[6] = 3;
			}
		}
	}else
	{
		//ARROW
		if(Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
		{
			if(Level.getTile(x, y - 1, z) != 0)
			{
				Level.setTile(x, y, z, 204);
				Level.setTile(x, y, z + 1, 203);
				savePortalAndDeleteBlue(x, y, z, x, y, z+1);
				blueInformations[6] = 3;
			return;
			}else
			if(Level.getTile(x, y + 1, z) != 0)
			{
				Level.setTile(x, y, z, 206);
				Level.setTile(x, y, z + 1, 205);
				savePortalAndDeleteBlue(x, y, z, x, y, z+1);
				blueInformations[6] = 4;
				return;
			}
		}else
		{
			if(Level.getTile(x + 1, y, z) != 0 && Level.getTile(x - 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 209, 0);
					Level.setTile(x, y + 1, z, 210, 0);
					savePortalAndDeleteBlue(x, y, z, x, y+1, z);
					blueInformations[6] = 6;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 210, 0);
						Level.setTile(x, y - 1, z, 209, 0);
						savePortalAndDeleteBlue(x, y, z, x, y-1, z);
						blueInformations[6] = 6;
						return;
					}
				}
			}
			if(Level.getTile(x, y, z + 1) != 0 && Level.getTile(x, y, z - 1) == 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 201, 0);
					Level.setTile(x, y + 1, z, 202, 0);
					savePortalAndDeleteBlue(x, y, z, x, y+1, z);
					blueInformations[6] = 2;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 202, 0);
						Level.setTile(x, y - 1, z, 201, 0);
						savePortalAndDeleteBlue(x, y, z, x, y-1, z);
						blueInformations[6] = 2;
						return;
					}
				}
			}
			if(Level.getTile(x - 1, y, z) != 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x, y, z - 1) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 207, 0);
					Level.setTile(x, y + 1, z, 208, 0);
					savePortalAndDeleteBlue(x, y, z, x, y+1, z);
					blueInformations[6] = 5;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 208, 0);
						Level.setTile(x, y - 1, z, 207, 0);
						savePortalAndDeleteBlue(x, y, z, x, y-1, z);
						blueInformations[6] = 5;
						return;
					}
				}
			}
			if(Level.getTile(x, y, z - 1) != 0 && Level.getTile(x, y, z + 1) == 0 && Level.getTile(x + 1, y, z) == 0 && Level.getTile(x - 1, y, z) == 0)
			{

				if(Level.getTile(x, y + 1, z) == 0)
				{
					Level.setTile(x, y, z, 199, 0);
					Level.setTile(x, y + 1, z, 200, 0);
					savePortalAndDeleteBlue(x, y, z, x, y+1, z);
					blueInformations[6] = 1;
					return;
				}else
				{
					if(Level.getTile(x, y - 1, z) == 0)
					{
						Level.setTile(x, y, z, 200, 0);
						Level.setTile(x, y - 1, z, 199, 0);
						savePortalAndDeleteBlue(x, y, z, x, y-1, z);
						blueInformations[6] = 1;
						return;
					}
				}
			}
			if(pX < x && pZ < z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 209, 0);
						Level.setTile(x, y + 1, z, 210, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 6;
					return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 210, 0);
							Level.setTile(x, y - 1, z, 209, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 6;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 201, 0);
						Level.setTile(x, y + 1, z, 202, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 2;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 202, 0);
							Level.setTile(x, y - 1, z, 201, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 2;
							return;
						}
					}
				}
			}
			if(pX < x && pZ >= z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 209, 0);
						Level.setTile(x, y + 1, z, 210, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 6;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 210, 0);
							Level.setTile(x, y - 1, z, 209, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 6;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 199, 0);
						Level.setTile(x, y + 1, z, 200, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 1;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 200, 0);
							Level.setTile(x, y - 1, z, 199, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 1;
							return;
						}
					}
				}
			}
			if(pX >= x && pZ >= z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 207, 0);
						Level.setTile(x, y + 1, z, 208, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 5;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 208, 0);
							Level.setTile(x, y - 1, z, 207, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 5;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 199, 0);
						Level.setTile(x, y + 1, z, 200, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 1;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 200, 0);
							Level.setTile(x, y - 1, z, 199, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 1;
							return;
						}
					}
				}
			}
			if(pX >= x && pZ < z)
			{
				if(Math.abs(pX - x) > Math.abs(pZ - z))
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 207, 0);
						Level.setTile(x, y + 1, z, 208, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 5;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 208, 0);
							Level.setTile(x, y - 1, z, 207, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 5;
							return;
						}
					}
				}else
				{

					if(Level.getTile(x, y + 1, z) == 0)
					{
						Level.setTile(x, y, z, 201, 0);
						Level.setTile(x, y + 1, z, 202, 0);
						savePortalAndDeleteBlue(x, y, z, x, y+1, z);
						blueInformations[6] = 2;
						return;
					}else
					{
						if(Level.getTile(x, y - 1, z) == 0)
						{
							Level.setTile(x, y, z, 202, 0);
							Level.setTile(x, y - 1, z, 201, 0);
							savePortalAndDeleteBlue(x, y, z, x, y-1, z);
							blueInformations[6] = 2;
							return;
						}
					}
				}
			}
		}
	}
}

function savePortalAndDeleteOrange(x, y, z, x1, y1, z1)
{
	if(generatedPortalOrange)
	{
		Level.setTile(orangeInformations[0], orangeInformations[1], orangeInformations[2], 0);
		Level.setTile(orangeInformations[3], orangeInformations[4], orangeInformations[5], 0);
	}
	orangeInformations[0] = x;
	orangeInformations[1] = y;
	orangeInformations[2] = z;
	orangeInformations[3] = x1;
	orangeInformations[4] = y1;
	orangeInformations[5] = z1;
	generatedPortalOrange = true;
	savePortalsToDelete();
}

function savePortalAndDeleteBlue(x, y, z, x1, y1, z1)
{
	if(generatedPortalBlue)
	{
		Level.setTile(blueInformations[0], blueInformations[1], blueInformations[2], 0);
		Level.setTile(blueInformations[3], blueInformations[4], blueInformations[5], 0);
	}
	blueInformations[0] = x;
	blueInformations[1] = y;
	blueInformations[2] = z;
	blueInformations[3] = x1;
	blueInformations[4] = y1;
	blueInformations[5] = z1;
	generatedPortalBlue = true;
	savePortalsToDelete();
}

function entityIsInPortalOrange(entity, x, y, z)
{
	if((x > orangeInformations[0] && x < (orangeInformations[0] + 1) && y > orangeInformations[1] && y < (orangeInformations[1] + 1) && z > orangeInformations[2] && z < (orangeInformations[2] + 1)) || (x > orangeInformations[3] && x < (orangeInformations[3] + 1) && y > orangeInformations[4] && y < (orangeInformations[4] + 1) && z > orangeInformations[5] && z < (orangeInformations[5] + 1)))
	{
		var random = Math.floor((Math.random() * 2) + 1);
		ModPE.playSoundFromFile("portals/portal_exit" + random + ".wav");
		if(orangeInformations[6] == 2)
		{
			if(blueInformations[6] == 2)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
		}else

		if(orangeInformations[6] == 1)
		{
			if(blueInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);	
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
		}else

		if(orangeInformations[6] == 3)
		{
			if(blueInformations[6] == 2)
			{
				Entity.setRot(entity, 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				if(entity == Player.getEntity())
					Entity.setVelZ(entity, velBeforeY);
				else
					Entity.setVelZ(entity, -0.2);
				Entity.setVelY(entity, 0);
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, 360, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				if(entity == Player.getEntity())
					Entity.setVelZ(entity, -velBeforeY);
				else
					Entity.setVelZ(entity, 0.2);
				Entity.setVelY(entity, 0);
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				if(entity == Player.getEntity())
					Entity.setVelY(entity, -velBeforeY);
				else
					Entity.setVelY(entity, 0.5);
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				if(entity == Player.getEntity())
					Entity.setVelY(entity, Entity.getVelY(velBeforeY) - 0.15);
				else
					Entity.setVelY(entity, 0);
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				if(entity == Player.getEntity())
					Entity.setVelX(entity, -velBeforeY);
				else
					Entity.setVelX(entity, 0.2);
				Entity.setVelY(entity, 0);
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, 450, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				if(entity == Player.getEntity())
					Entity.setVelX(entity, velBeforeY);
				else
					Entity.setVelX(entity, -0.2);
				Entity.setVelY(entity, 0);
			}
		}else

		if(orangeInformations[6] == 4)
		{
			if(blueInformations[6] == 2)
			{
				Entity.setRot(entity, 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				Entity.setVelZ(entity, -0.2);
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, 360, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				Entity.setVelZ(entity, 0.2);
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, 0.5);
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, Entity.getVelY(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, 0.2);
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, 450, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -0.2);
			}
		}else

		if(orangeInformations[6] == 5)
		{
			if(blueInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);	
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
		}else

		if(orangeInformations[6] == 6)
		{
			if(blueInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] - 1);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(blueInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 1);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(blueInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(blueInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 0.5, blueInformations[1] - 0.05, blueInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);
			}
			if(blueInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] + 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(blueInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, blueInformations[0] - 1, blueInformations[1] + 2, blueInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
		}
	}
}

function entityIsInPortalBlue(entity, x, y, z)
{
	if((x > blueInformations[0] && x < (blueInformations[0] + 1) && y > blueInformations[1] && y < (blueInformations[1] + 1) && z > blueInformations[2] && z < (blueInformations[2] + 1)) || (x > blueInformations[3] && x < (blueInformations[3] + 1) && y > blueInformations[4] && y < (blueInformations[4] + 1) && z > blueInformations[5] && z < (blueInformations[5] + 1)))
	{
		var random = Math.floor((Math.random() * 2) + 1);
		ModPE.playSoundFromFile("portals/portal_exit" + random + ".wav");
		if(blueInformations[6] == 2)
		{
			if(orangeInformations[6] == 2)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
		}else

		if(blueInformations[6] == 1)
		{
			if(orangeInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);	
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
		}else

		if(blueInformations[6] == 3)
		{
			if(orangeInformations[6] == 2)
			{
				Entity.setRot(entity, 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				if(entity == Player.getEntity())
					Entity.setVelZ(entity, velBeforeY);
				else
					Entity.setVelZ(entity, -0.2);
				Entity.setVelY(entity, 0);
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, 360, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				if(entity == Player.getEntity())
					Entity.setVelZ(entity, -velBeforeY);
				else
					Entity.setVelZ(entity, 0.2);
				Entity.setVelY(entity, 0);
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				if(entity == Player.getEntity())
					Entity.setVelY(entity, -velBeforeY);
				else
					Entity.setVelY(entity, 0.5);
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				if(entity == Player.getEntity())
					Entity.setVelY(entity, Entity.getVelY(velBeforeY) - 0.15);
				else
					Entity.setVelY(entity, 0);
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				if(entity == Player.getEntity())
					Entity.setVelX(entity, -velBeforeY);
				else
					Entity.setVelX(entity, 0.2);
				Entity.setVelY(entity, 0);
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, 450, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				if(entity == Player.getEntity())
					Entity.setVelX(entity, velBeforeY);
				else
					Entity.setVelX(entity, -0.2);
				Entity.setVelY(entity, 0);
			}
		}else

		if(blueInformations[6] == 4)
		{
			if(orangeInformations[6] == 2)
			{
				Entity.setRot(entity, 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				Entity.setVelZ(entity, -0.2);
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, 360, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				Entity.setVelZ(entity, 0.2);
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, 0.5);
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelY(entity, Entity.getVelY(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));	
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, 0.2);
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, 450, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -0.2);
			}
		}else

		if(blueInformations[6] == 5)
		{
			if(orangeInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);	
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
		}else

		if(blueInformations[6] == 6)
		{
			if(orangeInformations[6] == 2)
			{	
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] - 1);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelZ(entity, -Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 1)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 90, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 1);
				Entity.setVelX(entity, -Entity.getVelZ(entity));
				Entity.setVelZ(entity, Entity.getVelX(entity));
			}
			if(orangeInformations[6] == 3)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelZ(entity));
				Entity.setVelY(entity, 0.6);
				Entity.setVelZ(entity, -0.4);	
			}
			if(orangeInformations[6] == 4)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 270, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 0.5, orangeInformations[1] - 0.05, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, 0);
				Entity.setVelY(entity, -0.15);
				Entity.setVelZ(entity, 0);
			}
			if(orangeInformations[6] == 5)
			{
				Entity.setRot(entity, Entity.getYaw(entity), Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] + 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, Entity.getVelX(entity));
				Entity.setVelZ(entity, Entity.getVelZ(entity));
			}
			if(orangeInformations[6] == 6)
			{
				Entity.setRot(entity, Entity.getYaw(entity) + 180, Entity.getPitch(entity));
				Entity.setPosition(entity, orangeInformations[0] - 1, orangeInformations[1] + 2, orangeInformations[2] + 0.5);
				Entity.setVelX(entity, -Entity.getVelX(entity));
				Entity.setVelZ(entity, -Entity.getVelZ(entity));
			}
		}
	}
}

ModPE.playSoundFromFile = function(fileName)
{
	try
	{
		if(sound1.isPlaying() == false)
		{
			sound1.reset();
			sound1.setDataSource(new android.os.Environment.getExternalStorageDirectory() + "/portal-sounds/" + fileName);
			sound1.prepare();
			sound1.start();
			return;
		}
		if(sound2.isPlaying() == false)
		{
			sound2.reset();
			sound2.setDataSource(new android.os.Environment.getExternalStorageDirectory() + "/portal-sounds/" + fileName);
			sound2.prepare();
			sound2.start();
			return;
		}else
		{
			sound3.reset();
			sound3.setDataSource(new android.os.Environment.getExternalStorageDirectory() + "/portal-sounds/" + fileName);
			sound3.prepare();
			sound3.start();
		}
	}catch(err)
	{
		if(!displayedMessageNoSound)
		{
			ModPE.showTipMessage("Portal: Sounds not installed!");
			displayedMessageNoSound = true;
		}
	}
}

ModPE.playMusicFromFile = function(fileName)
{
	try
	{
		music.reset();
		music.setDataSource(new android.os.Environment.getExternalStorageDirectory() + "/portal-sounds/music/" + fileName);
		music.prepare();
		music.start();
		ModPE.showTipMessage("Portal: Playing music...");
	}
	catch(err)
	{
		ModPE.showTipMessage("Portal: Sounds not installed!");
	}
}

ModPE.stopMusic = function()
{
	if(music.isPlaying() == true)
	{
		music.reset();
		ModPE.showTipMessage("Portal: Stopping music...");
	}
}

Item.getSpeed = function()
{
	if(Player.getCarriedItem() == 470)
		return 2;
	if(Player.getCarriedItem() == 477)
		return 2;
	if(Player.getCarriedItem() == 471)
		return 1.5;
	if(Player.getCarriedItem() == 472)
		return 1;
	if(Player.getCarriedItem() == 473)
		return 1;
}

Item.damageCarried = function()
{
	var maxDamage;
	if(Player.getCarriedItem() == 470)
		maxDamage = 1000;
	if(Player.getCarriedItem() == 471)
		maxDamage = 500;
	if(Player.getCarriedItem() == 472)
		maxDamage = 250;
	if(Player.getCarriedItem() == 473)
		maxDamage = 200;
	if(Player.getCarriedItem() == 474)
		maxDamage = 100;
	if(Player.getCarriedItem() == 477)
		maxDamage = 1000;
	if(Player.getCarriedItem() == 479)
		maxDamage = 400;
	if(Player.getCarriedItemData() < maxDamage)
		Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), Player.getCarriedItemData() + 1);
	else
	{
		Level.playSoundEnt(Player.getEntity(), "random.break", 100, 30);
		if(Player.getCarriedItemCount() == 1)
			Player.clearInventorySlot(Player.getSelectedSlotId());
		else
			Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount() - 1, 0);
	}
}

Item.changePortalColor = function()
{
	if(Player.getCarriedItem() == 470 || Player.getCarriedItem() == 477)
	{
		if(Player.getCarriedItem() == 470)
			Entity.setCarriedItem(Player.getEntity(), 477, Player.getCarriedItemCount(), Player.getCarriedItemData());
		else
			Entity.setCarriedItem(Player.getEntity(), 470,  Player.getCarriedItemCount(), Player.getCarriedItemData());
	}
}

function loadPortalsToDelete()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var portalLoadFile = java.io.File(new android.os.Environment.getExternalStorageDirectory() + "/games/com.mojang/minecraftWorlds/" + Level.getWorldDir() + "/portal_mod/portals.dat");
				if(portalLoadFile.exists())
				{
					var loadedText = "";
					var streamInput = new java.io.FileInputStream(portalLoadFile);
					var bufferedReader = new java.io.BufferedReader(new java.io.InputStreamReader(streamInput));
					var row = "";
					while((row = bufferedReader.readLine()) != null) 
					{
						loadedText += row;
					}
					var arrayToDelete = loadedText.split(" ");
					if(arrayToDelete[0] == "generatedPortalOrange=1")
					{
						Level.setTile(arrayToDelete[3], arrayToDelete[5], arrayToDelete[7], 1);
						Level.setTile(arrayToDelete[9], arrayToDelete[11], arrayToDelete[13], 1);
						Level.setTile(arrayToDelete[3], arrayToDelete[5], arrayToDelete[7], 0);
						Level.setTile(arrayToDelete[9], arrayToDelete[11], arrayToDelete[13], 0);
						generatedPortalOrange = false;
					}
					if(arrayToDelete[1] == "generatedPortalBlue=1")
					{
						Level.setTile(arrayToDelete[15], arrayToDelete[17], arrayToDelete[19], 1);
						Level.setTile(arrayToDelete[21], arrayToDelete[23], arrayToDelete[25], 1);
						Level.setTile(arrayToDelete[15], arrayToDelete[17], arrayToDelete[19], 0);
						Level.setTile(arrayToDelete[21], arrayToDelete[23], arrayToDelete[25], 0);
						generatedPortalBlue = false;
					}
					bufferedReader.close();
					savePortalsToDelete();
				}
			}catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function savePortalsToDelete()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var portalSaveFile = new java.io.File(new android.os.Environment.getExternalStorageDirectory() + "/games/com.mojang/minecraftWorlds/" + Level.getWorldDir() + "/portal_mod/portals.dat");
				if(portalSaveFile.exists())
					portalSaveFile.delete();
				portalSaveFile.createNewFile();
				var streamOutput = new java.io.FileOutputStream(portalSaveFile);
				var streamWriter = new java.io.OutputStreamWriter(streamOutput);
				if(generatedPortalOrange)
				{
					var toSaveGeneratedOrange = "1";
					var oX = orangeInformations[0];
					var oY = orangeInformations[1];
					var oZ = orangeInformations[2];
					var oX1 = orangeInformations[3];
					var oY1 = orangeInformations[4];
					var oZ1 = orangeInformations[5];
				}else
				{
					var toSaveGeneratedOrange = "0";
					var oX = "null";
					var oY = "null";
					var oZ = "null";
					var oX1 = "null";
					var oY1 = "null";
					var oZ1 = "null";
				}
				if(generatedPortalBlue)
				{
					var toSaveGeneratedBlue = "1";
					var bX = blueInformations[0];
					var bY = blueInformations[1];
					var bZ = blueInformations[2];
					var bX1 = blueInformations[3];
					var bY1 = blueInformations[4];
					var bZ1 = blueInformations[5];
				}else
				{
					var toSaveGeneratedBlue = "0";
					var bX = "null";
					var bY = "null";
					var bZ = "null";
					var bX1 = "null";
					var bY1 = "null";
					var bZ1 = "null";
				}
				streamWriter.append("generatedPortalOrange=" + toSaveGeneratedOrange + " " +
					"generatedPortalBlue=" + toSaveGeneratedBlue  +

					" oX " + oX +
					" oY " + oY +
					" oZ " + oZ +
					" oX1 " + oX1 +
					" oY1 " + oY1 +
					" oZ1 " + oZ1 +

					
					" bX " + bX +
					" bY " + bY +
					" bZ " + bZ +
					" bX1 " + bX1 +
					" bY1 " + bY1 +
					" bZ1 " + bZ1  );
				streamWriter.close();
				streamOutput.close();
			}catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function getLatestVersionPortalMod()
{
	try
	{
		var versionFile = new java.io.File(android.os.Environment.getExternalStorageDirectory().getAbsolutePath() + "/games/com.mojang/minecraftpe/portalUpdatesFile.dat");
		if(versionFile.exists())
			versionFile.delete();
		versionFile.createNewFile();
		var streamVersionOutput = new java.io.FileOutputStream(versionFile);
		var download = android.net.http.AndroidHttpClient.newInstance("getLatestVersionPortalMod()").execute(new org.apache.http.client.methods.HttpGet("https://raw.githubusercontent.com/Desno365/MCPE-scripts/master/portalMOD-version")).getEntity().writeTo(streamVersionOutput);
		streamVersionOutput.close();
		if(versionFile.exists())
		{
			var loadedVersion = "";
			var streamVersionInput = new java.io.FileInputStream(versionFile);
			var bufferedVersionReader = new java.io.BufferedReader(new java.io.InputStreamReader(streamVersionInput));
			var rowVersion = "";
			while((rowVersion = bufferedVersionReader.readLine()) != null)
			{
				loadedVersion += rowVersion;
			}
			latestVersion = loadedVersion.split(" ");
			bufferedVersionReader.close();
			versionFile.delete();
		}
	}catch(err)
	{
		clientMessage("Error: " + err);
	}
}

function downloadMapsManifest()
{
	try
	{
		var mapsManifestFile = new java.io.File(android.os.Environment.getExternalStorageDirectory().getAbsolutePath() + "/games/com.mojang/minecraftpe/customMaps.manifest");
		if(mapsManifestFile.exists())
			mapsManifestFile.delete();
		mapsManifestFile.createNewFile();
		var streamOutputMapsManifest = new java.io.FileOutputStream(mapsManifestFile);
		var downloadManifest = android.net.http.AndroidHttpClient.newInstance("downloadMapsManifest()").execute(new org.apache.http.client.methods.HttpGet("https://raw.githubusercontent.com/Desno365/MCPE-scripts/master/portalMOD-mapsManifest")).getEntity().writeTo(streamOutputMapsManifest);
		streamOutputMapsManifest.close();
		if(mapsManifestFile.exists())
		{
			var streamInputMapsManifest = new java.io.FileInputStream(mapsManifestFile);
			var bufferedReaderMapsManifest = new java.io.BufferedReader(new java.io.InputStreamReader(streamInputMapsManifest));
			var rowMapsManifest = "";
			while((rowMapsManifest = bufferedReaderMapsManifest.readLine()) != null)
			{
				mapsManifestDownloaded += rowMapsManifest;
			}
			bufferedReaderMapsManifest.close();
			mapsManifestFile.delete();
		}
	}catch(err)
	{
		clientMessage("Error: " + err);
	}
}

function addTurretRenderType(renderer)
{
	var model = renderer.getModel();
 
	var head = model.getPart("head");
	var body = model.getPart("body");
	var rArm = model.getPart("rightArm");
	var lArm = model.getPart("leftArm");
	var rLeg = model.getPart("rightLeg");
	var lLeg = model.getPart("leftLeg");
 
	head.clear();
 
	body.clear();
	body.setTextureOffset(25,15);
	body.addBox(0,0,0,3,11,6);
	body.setTextureOffset(54,0);	
	body.addBox(-1,1,1,1,9,4);
	body.setTextureOffset(54,0);	
	body.addBox(3,1,1,1,9,4);
	body.setTextureOffset(44,30);	
	body.addBox(1,5,-0.5,1,1,1);
 
	lLeg.clear();
  lLeg.setTextureOffset(49,17);
  lLeg.addBox(1,-1,5,1,2,1);
  lLeg.setTextureOffset(49,17);
  lLeg.addBox(1,1,2,1,1,4);
  lLeg.setTextureOffset(25,21);
  lLeg.addBox(0.5,1,-1,2,1,3);
  lLeg.setTextureOffset(49,17);
  lLeg.addBox(1,2,-1,1,6,1);

	rLeg.clear();
  rLeg.setTextureOffset(49,17);
  rLeg.addBox(1,-1,5,1,2,1);
  rLeg.setTextureOffset(49,17);
  rLeg.addBox(1,1,2,1,1,4);
  rLeg.setTextureOffset(25,21);
  rLeg.addBox(0.5,1,-1,2,1,3);
  rLeg.setTextureOffset(49,17);
  rLeg.addBox(1,2,-1,1,6,1);

	rArm.clear();
  rArm.setTextureOffset(49,17);
  rArm.addBox(6,11,4,1,1,2);
  rArm.setTextureOffset(49,17);
  rArm.addBox(6,10,5,1,1,1);
  rArm.setTextureOffset(25,21);
  rArm.addBox(5.5,9,5,2,1,4);
  rArm.setTextureOffset(49,17);
  rArm.addBox(6,10,8,1,8,1);

	lArm.clear();
}
var TurretRenderType = Renderer.createHumanoidRenderer();
addTurretRenderType(TurretRenderType);

function checkProximity(entity1, entity2, distance)
{
	if(!(Math.abs(Entity.getX(entity1) - Entity.getX(entity2)) <= distance))
		return false;
	if(!(Math.abs(Entity.getY(entity1) - Entity.getY(entity2)) <= distance))
		return false;
	if(!(Math.abs(Entity.getZ(entity1) - Entity.getZ(entity2)) <= distance))
		return false;
	return true;
}

function loadTurrets()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var turretLoadFile = java.io.File(new android.os.Environment.getExternalStorageDirectory() + "/games/com.mojang/minecraftWorlds/" + Level.getWorldDir() + "/portal_mod/turrets.dat");
				if(turretLoadFile.exists())
				{
					var loadedTurretText = "";
					var streamInputTurret = new java.io.FileInputStream(turretLoadFile);
					var bufferedReaderTurret = new java.io.BufferedReader(new java.io.InputStreamReader(streamInputTurret));
					var rowTurret = "";
					while((rowTurret = bufferedReaderTurret.readLine()) != null) 
					{
						loadedTurretText += rowTurret;
					}
					var arrayTurret = loadedTurretText.split(" ");

					spawnedTurretsNumber = arrayTurret[0];
					for(var i = 0; i < spawnedTurretsNumber; i++)
					{
						var maxI = (i + 1) * 6;
						turrets[i][1] = arrayTurret[maxI - 5];
						turrets[i][2] = arrayTurret[maxI - 4];
						turrets[i][3] = arrayTurret[maxI - 3];
						turrets[i][4] = arrayTurret[maxI - 2];
						turrets[i][5] = arrayTurret[maxI - 1];
						turrets[i][6] = arrayTurret[maxI];

						var turret = Level.spawnMob(turrets[i][1], turrets[i][2], turrets[i][3], 11, "mob/turret.png");
						turrets[i][0] = turret;
						Entity.setHealth(turrets[i][0], 1);
						Entity.setRenderType(turrets[i][0], TurretRenderType.renderType);
					}

					bufferedReaderTurret.close();
					saveTurrets();
				}
			}catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function saveTurrets()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var turretSaveFile = new java.io.File(new android.os.Environment.getExternalStorageDirectory() + "/games/com.mojang/minecraftWorlds/" + Level.getWorldDir() + "/portal_mod/turrets.dat");
				if(turretSaveFile.exists())
					turretSaveFile.delete();
				turretSaveFile.createNewFile();
				var streamOutputTurret = new java.io.FileOutputStream(turretSaveFile);
				var streamWriterTurret = new java.io.OutputStreamWriter(streamOutputTurret);
				
				streamWriterTurret.append(spawnedTurretsNumber + " ");
				for(var i = 0; i < spawnedTurretsNumber; i++)
				{
					streamWriterTurret.append(turrets[i][1] + " " + turrets[i][2] + " " + turrets[i][3] + " " + turrets[i][4] + " " + turrets[i][5] + " " + turrets[i][6] + " ");
				}
				streamWriterTurret.close();
				streamOutputTurret.close();
			}catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

//############################################################################
//GUI functions
//############################################################################

function informationsForPortalGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutInfo = new android.widget.LinearLayout(currentActivity);
				layoutInfo.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollInfo = new android.widget.ScrollView(currentActivity);
				scrollInfo.addView(layoutInfo);
			
				var popupInfo = new android.app.Dialog(currentActivity); 
				popupInfo.setContentView(scrollInfo);
				popupInfo.setTitle(new android.text.Html.fromHtml("P<font color=#1E90FF>O</font>RTAL 2 M<font color=#FFA500>O</font>D by Desno365"));

				var infoText = new android.widget.TextView(currentActivity);
				infoText.setText(new android.text.Html.fromHtml("Welcome to the P<font color=#1E90FF>O</font>RTAL 2 M<font color=#FFA500>O</font>D by Desno365!<br>"));
				layoutInfo.addView(infoText);

				var informationsButton = new android.widget.Button(currentActivity); 
				informationsButton.setText("Informations"); 
				informationsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationsGUI();
						popupInfo.dismiss();
					}
				});
				layoutInfo.addView(informationsButton);

				var divider1Image = new android.widget.ImageView(currentActivity); 			 
 				divider1Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider1Image);

				var settingsButton = new android.widget.Button(currentActivity); 
				settingsButton.setText("Settings"); 
				settingsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						settingsGUI();
						popupInfo.dismiss();
					}
				});
				layoutInfo.addView(settingsButton);
				
				var divider2Image = new android.widget.ImageView(currentActivity); 			 
 				divider2Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider2Image);
				
				var customMapsButton = new android.widget.Button(currentActivity); 
				customMapsButton.setText("Custom maps for the mod"); 
				customMapsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						customMapsGUI();
						popupInfo.dismiss();	
					}
				});
				layoutInfo.addView(customMapsButton);

				var divider3Image = new android.widget.ImageView(currentActivity); 			 
 				divider3Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider3Image);

				var updatesButton = new android.widget.Button(currentActivity); 
				updatesButton.setText("Check for updates"); 
				updatesButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						if(latestVersion == CURRENT_VERSION)
						{
							android.widget.Toast.makeText(currentActivity,"You have the latest version.",0).show();
						}else
						{
							updateAvailableGUI();
							popupInfo.dismiss();
						}
					}
				});
				layoutInfo.addView(updatesButton);
				
				var divider4Image = new android.widget.ImageView(currentActivity); 			 
 				divider4Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider4Image);
				
				var officialThreadButton = new android.widget.Button(currentActivity); 
				officialThreadButton.setText("Visit the official thread"); 
				officialThreadButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						visitThread();
						popupInfo.dismiss();	
					}
				});
				layoutInfo.addView(officialThreadButton);

				var divider5Image = new android.widget.ImageView(currentActivity); 			 
 				divider5Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider5Image);

				var donateButton = new android.widget.Button(currentActivity); 
				donateButton.setText("Support the developer"); 
				donateButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						supportGUI();
						popupInfo.dismiss();	
					}
				});
				layoutInfo.addView(donateButton);
				
				var divider6Image = new android.widget.ImageView(currentActivity); 			 
 				divider6Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider6Image);

				var creditsButton = new android.widget.Button(currentActivity); 
				creditsButton.setText("Credits"); 
				creditsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						var layoutCredits = new android.widget.LinearLayout(currentActivity);
						layoutCredits.setOrientation(android.widget.LinearLayout.VERTICAL);

						var scrollCredits = new android.widget.ScrollView(currentActivity);
						scrollCredits.addView(layoutCredits);
			
						var popupCredits = new android.app.Dialog(currentActivity); 
						popupCredits.setContentView(scrollCredits);
						popupCredits.setTitle(new android.text.Html.fromHtml("Credits"));

						var creditsText = new android.widget.TextView(currentActivity);
						creditsText.setText(new android.text.Html.fromHtml("<br>The most part of the code used in this mod was created by me (Desno365) but I would like to thank some people that helped me to make this mod better and better:<br><br>" +
						"- <b>mcpemodder</b> for helping me making the code when the PortalGun shoots.<br>" +
						"- <b>iChun</b> for a few images extracted from his mod.<br>" +
						"- <b>TBPM</b> for his idea of decoding images with base64.<br>" +
						"- <b>minecrave79</b> for helping me for the damage code for the PortalGuns.<br>" +
						"- <b>MyNameIsAnti</b> that made for me a fantastic render for the turret.<br>" +
						"- <b>Thecactigod</b> that made some lines of code for this mod.<br>" +
						"- <b>MC_miner_bros</b> for some beautiful textures."));
						layoutCredits.addView(creditsText);
						
						var exitCreditsButton = new android.widget.Button(currentActivity); 
						exitCreditsButton.setText("Close"); 
						exitCreditsButton.setOnClickListener(new android.view.View.OnClickListener()
						{
							onClick: function()
							{
								popupCredits.dismiss();
							}
						});
						layoutCredits.addView(exitCreditsButton);
						
						
						popupCredits.show();
					}
				});
				layoutInfo.addView(creditsButton);

				var divider7Image = new android.widget.ImageView(currentActivity); 			 
 				divider7Image.setImageBitmap(g[3]);
				layoutInfo.addView(divider7Image);

				var exitInfoButton = new android.widget.Button(currentActivity); 
				exitInfoButton.setText("Close"); 
				exitInfoButton.setOnClickListener(new android.view.View.OnClickListener()
				{ 
					onClick: function()
					{ 
						popupInfo.dismiss();
					}
				}); 
				layoutInfo.addView(exitInfoButton); 
				

				popupInfo.show();
			
			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function informationsGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutInformations = new android.widget.LinearLayout(currentActivity);
				layoutInformations.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollInformations = new android.widget.ScrollView(currentActivity);
				scrollInformations.addView(layoutInformations);
			
				var popupInformations = new android.app.Dialog(currentActivity); 
				popupInformations.setContentView(scrollInformations);
				popupInformations.setTitle("Informations");

				var informations1Text = new android.widget.TextView(currentActivity);
				informations1Text.setText(new android.text.Html.fromHtml("<b>Portal guns:</b>" +
					"<br>-<i>PortalGun</i>: bullet speed: 40 block/second, max damage: 1000" +
					"<br>-<i>PortalGun Gold</i>: bullet speed: 30 block/second, max damage: 500" +
					"<br>-<i>PortalGun Iron</i>: bullet speed: 20 block/second, max damage: 250" +
					"<br>-<i>PortalGun Lava</i>: bullet speed: 20 block/second, max damage: 200" +
					"<br>-<i>PortalGun Wood & Stone</i>: Tap on a block to place a portal. max damage: 100"));
				layoutInformations.addView(informations1Text);

				var dividerInformations1Image = new android.widget.ImageView(currentActivity); 			 
 				dividerInformations1Image.setImageBitmap(g[3]);
				layoutInformations.addView(dividerInformations1Image);

				var informations2Text = new android.widget.TextView(currentActivity);
				informations2Text.setText(new android.text.Html.fromHtml("<b>Other Items:</b>" +
					"<br>-<i>GravityGun</i>: Hit a mob with this item to pick it, then you can bring it everywhere or shoot it." +
					"<br>-<i>Turret</i>: Tap on a block with this item to spawn a turret." +
					"<br>-<i>Turrets options</i>: Hit a turret with this item to display the options GUI." +
					"<br>-<i>Long fall boots</i>: When you fall from a great height these boots prevent damage to you." +
					"<br>-<i>Jumper</i>: When someone go above this block he will make a powerful jump." + 
					"<br>-<i>Portal Jukebox</i>: Tap this block to open the GUI that consent you to listen to the beautiful songs of the Portal game."));
				layoutInformations.addView(informations2Text);
				
				var dividerInformations2Image = new android.widget.ImageView(currentActivity); 			 
 				dividerInformations2Image.setImageBitmap(g[3]);
				layoutInformations.addView(dividerInformations2Image);
				
				var informations3Text = new android.widget.TextView(currentActivity);
				informations3Text.setText(new android.text.Html.fromHtml("<b>Tips and tricks:</b>" +
					"<br>-<i>Easter egg</i>: There is an easter egg hidden in the 'Portal Informations' GUI, try to find it! ;-)." +
					"<br>Can't find it? Try to long press all the buttons in the GUI."));
				layoutInformations.addView(informations3Text);

				var backInformationsButton = new android.widget.Button(currentActivity); 
				backInformationsButton.setText("Back"); 
				backInformationsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationsForPortalGUI();
						popupInformations.dismiss();
					}
				});
				layoutInformations.addView(backInformationsButton);
				
				var exitInformationsButton = new android.widget.Button(currentActivity); 
				exitInformationsButton.setText("Close"); 
				exitInformationsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupInformations.dismiss();
					}
				});
				layoutInformations.addView(exitInformationsButton);
				

				popupInformations.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function settingsGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutSettings = new android.widget.LinearLayout(currentActivity);
				layoutSettings.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollSettings = new android.widget.ScrollView(currentActivity);
				scrollSettings.addView(layoutSettings);
			
				var popupSettings = new android.app.Dialog(currentActivity); 
				popupSettings.setContentView(scrollSettings);
				popupSettings.setTitle("Settings");
				
				var mapSettingsButton = new android.widget.Button(currentActivity); 
				mapSettingsButton.setText("Options for custom-map-makers"); 
				mapSettingsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						mapMakerSettingsGUI();
						popupSettings.dismiss();
					}
				});
				layoutSettings.addView(mapSettingsButton);
				
				var dividerSettings1Image = new android.widget.ImageView(currentActivity); 			 
 				dividerSettings1Image.setImageBitmap(g[3]);
				layoutSettings.addView(dividerSettings1Image);

				var setEntitySupportButton = new android.widget.Button(currentActivity);
				if(portalsWithEveryEntity)
				{
					setEntitySupportButton.setText("Disable mobs support for portals and jumpers"); 
					setEntitySupportButton.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function()
						{
							android.widget.Toast.makeText(currentActivity,"Disabled mobs support.",0).show();
							portalsWithEveryEntity = false;
							popupSettings.dismiss();
						}
					});
					layoutSettings.addView(setEntitySupportButton);
				}
				if(!portalsWithEveryEntity)
				{
					setEntitySupportButton.setText("Enable mobs support for portals and jumpers"); 
					setEntitySupportButton.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function()
						{
							warningEveryEntity();
							popupSettings.dismiss();
						}
					});
					layoutSettings.addView(setEntitySupportButton);
				}

				var setJumperPowerButton = new android.widget.Button(currentActivity); 
				setJumperPowerButton.setText("Set Jumper power"); 
				setJumperPowerButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						jumperPowerPicker();
						popupSettings.dismiss();
					}
				});
				setJumperPowerButton.setLongClickable(true);
				setJumperPowerButton.setOnLongClickListener(new android.view.View.OnLongClickListener()
				{
					onLongClick: function()
					{
						android.widget.Toast.makeText(currentActivity,"Easter egg: max jumper power set to 100! :D",0).show();
						maxPower = 100;
						jumperPower = 100;
						jumperPowerPicker();
						popupSettings.dismiss();
						return true;
					}
				});
				layoutSettings.addView(setJumperPowerButton);
				
				var dividerSettings2Image = new android.widget.ImageView(currentActivity); 			 
 				dividerSettings2Image.setImageBitmap(g[3]);
				layoutSettings.addView(dividerSettings2Image);

				var backSettingsButton = new android.widget.Button(currentActivity); 
				backSettingsButton.setText("Back"); 
				backSettingsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationsForPortalGUI();
						popupSettings.dismiss();
					}
				});
				layoutSettings.addView(backSettingsButton);

				var exitSettingsButton = new android.widget.Button(currentActivity); 
				exitSettingsButton.setText("Close"); 
				exitSettingsButton.setOnClickListener(new android.view.View.OnClickListener()
				{ 
					onClick: function()
					{ 
						popupSettings.dismiss();
					}
				}); 
				layoutSettings.addView(exitSettingsButton); 
				

				popupSettings.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function mapMakerSettingsGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutMapMaker = new android.widget.LinearLayout(currentActivity);
				layoutMapMaker.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollMapMaker = new android.widget.ScrollView(currentActivity);
				scrollMapMaker.addView(layoutMapMaker);
			
				var popupMapMaker = new android.app.Dialog(currentActivity); 
				popupMapMaker.setContentView(scrollMapMaker);
				popupMapMaker.setTitle("Map-makers settings");
				
				var mapMakerText = new android.widget.TextView(currentActivity);
				mapMakerText.setText("Do you want to make a custom map for the Portal 2 Mod? You are in the right section.");
				layoutMapMaker.addView(mapMakerText);
				
				var suggestionMapMakerButton = new android.widget.Button(currentActivity); 
				suggestionMapMakerButton.setText("Suggestions for map-makers"); 
				suggestionMapMakerButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						suggestionsMapMakerGUI();
						popupMapMaker.dismiss();
					}
				});
				layoutMapMaker.addView(suggestionMapMakerButton);
				
				var dividerMapMaker1Image = new android.widget.ImageView(currentActivity); 			 
 				dividerMapMaker1Image.setImageBitmap(g[3]);
				layoutMapMaker.addView(dividerMapMaker1Image);
				
				var equipmentButton = new android.widget.Button(currentActivity); 
				equipmentButton.setText("Get Aperture Lab equipment"); 
				equipmentButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						Player.addItemInventory(220, 4, 0);
						Player.addItemInventory(221, 64, 0);
						Player.addItemInventory(480, 1, 0);
						Player.addItemInventory(478, 1, 0);
						android.widget.Toast.makeText(currentActivity,"Equipment added to the inventory.",0).show();
						popupMapMaker.dismiss();
					}
				});
				layoutMapMaker.addView(equipmentButton);
				
				var dividerMapMaker2Image = new android.widget.ImageView(currentActivity); 			 
 				dividerMapMaker2Image.setImageBitmap(g[3]);
				layoutMapMaker.addView(dividerMapMaker2Image);
				
				var backMapMakerButton = new android.widget.Button(currentActivity); 
				backMapMakerButton.setText("Back"); 
				backMapMakerButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						settingsGUI();
						popupMapMaker.dismiss();
					}
				});
				layoutMapMaker.addView(backMapMakerButton);

				var exitMapMakerButton = new android.widget.Button(currentActivity); 
				exitMapMakerButton.setText("Close"); 
				exitMapMakerButton.setOnClickListener(new android.view.View.OnClickListener()
				{ 
					onClick: function()
					{ 
						popupMapMaker.dismiss();
					}
				}); 
				layoutMapMaker.addView(exitMapMakerButton); 
				
				
				popupMapMaker.show();
			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function suggestionsMapMakerGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutSuggestions = new android.widget.LinearLayout(currentActivity);
				layoutSuggestions.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollSuggestions = new android.widget.ScrollView(currentActivity);
				scrollSuggestions.addView(layoutSuggestions);
			
				var popupSuggestions = new android.app.Dialog(currentActivity); 
				popupSuggestions.setContentView(scrollSuggestions);
				popupSuggestions.setTitle("Suggestions");

				var suggestions1Text = new android.widget.TextView(currentActivity);
				suggestions1Text.setText(new android.text.Html.fromHtml("<br>-You shouldn't give to the player the 'Portal Informations' item, because with this item the player can obtain the Aperture Lab equipment and use it for complete the chambers in an easier way.<br><br>" +
					"-If one or more of your levels/chambers require mobs support you can place a sign and say to the player that he have to type in chat '/enable' or 'mobs-support' to play this level/chamber, then he can disable the mobs support setting by typing in chat 'disable' or 'no-mobs'.<br><br>" +
					"-You should place the 'Portal Jukebox' at the start or at the end of your map.<br><br>" + 
					"-When you finish the map you can upload it and make a thread at the minecraftforum.net site, if you do this you can send me the link and I will add your map in the first post of the Portal 2 Mod thread and in the 'Custom maps' section of this GUI.<br><br>" +
					"<b>P.S.</b>: of course these are only suggestions, you can do whatever you want with your custom map ;-)"));
				layoutSuggestions.addView(suggestions1Text);

				var backSuggestionsButton = new android.widget.Button(currentActivity); 
				backSuggestionsButton.setText("Back"); 
				backSuggestionsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						mapMakerSettingsGUI();
						popupSuggestions.dismiss();
					}
				});
				layoutSuggestions.addView(backSuggestionsButton);
				
				var exitSuggestionsButton = new android.widget.Button(currentActivity); 
				exitSuggestionsButton.setText("Close"); 
				exitSuggestionsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupSuggestions.dismiss();
					}
				});
				layoutSuggestions.addView(exitSuggestionsButton);
				

				popupSuggestions.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function warningEveryEntity()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutWarningEntity = new android.widget.LinearLayout(currentActivity);
				layoutWarningEntity.setOrientation(android.widget.LinearLayout.VERTICAL);
				
				var popupWarningEntity = new android.app.AlertDialog.Builder(currentActivity);
				popupWarningEntity.setView(layoutWarningEntity);
				popupWarningEntity.setTitle("Activate mobs support");

				var infoTextWarningEntity = new android.widget.TextView(currentActivity);
				infoTextWarningEntity.setText("WARNING: This can slow down your device!");
				infoTextWarningEntity.setTextColor(android.graphics.Color.RED);
				layoutWarningEntity.addView(infoTextWarningEntity);

				var infoTextWarningEntity1 = new android.widget.TextView(currentActivity);
				infoTextWarningEntity1.setText("By activating this option, the CPU will be used more (every 1/10 of a second many lines of code will be executed)." +
					"\nI suggest you to activate this option only if you have a quad-core or a octa-core CPU." +
					"\nHowever when you exit the game this option is reset, so if you have problems after activating it just close BlockLauncher and re-open it.");
				layoutWarningEntity.addView(infoTextWarningEntity1);
			
				popupWarningEntity.setPositiveButton("Continue", new android.content.DialogInterface.OnClickListener(){
					onClick: function(viewarg)
					{
						portalsWithEveryEntity = true;
						android.widget.Toast.makeText(currentActivity,"Activated mobs support!",0).show();
					}});

				popupWarningEntity.setNegativeButton("Cancel", new android.content.DialogInterface.OnClickListener(){
					onClick: function(viewarg)
					{
						android.widget.Toast.makeText(currentActivity,"Cancel",0).show();
					}});
			

				popupWarningEntity.show();

			}catch (err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device.");
			}
		}
	});
}

function jumperPowerPicker()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutJumperPower = new android.widget.LinearLayout(currentActivity);
				layoutJumperPower.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollJumperPower = new android.widget.ScrollView(currentActivity);
				scrollJumperPower.addView(layoutJumperPower);
			
				var popupJumperPower = new android.app.Dialog(currentActivity); 
				popupJumperPower.setContentView(scrollJumperPower);
				popupJumperPower.setTitle("Portal Jumper power");

				var powerText = new android.widget.TextView(currentActivity);
				powerText.setText("Set the power (default is 6)");
				layoutJumperPower.addView(powerText);

				var powerChooser = new android.widget.NumberPicker(currentActivity);
				powerChooser.setMaxValue(maxPower);
				powerChooser.setMinValue(1);
				powerChooser.setValue(jumperPower);
				layoutJumperPower.addView(powerChooser);

				var setPowerButton = new android.widget.Button(currentActivity); 
				setPowerButton.setText("Set power"); 
				setPowerButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						android.widget.Toast.makeText(currentActivity, "Power: " + (powerChooser.getValue()) , 0).show();
						jumperPower = (powerChooser.getValue());
					}
				});
				layoutJumperPower.addView(setPowerButton);

				var backJumperPowerButton = new android.widget.Button(currentActivity); 
				backJumperPowerButton.setText("Back"); 
				backJumperPowerButton.setOnClickListener(new android.view.View.OnClickListener()
				{ 
					onClick: function()
					{
						settingsGUI();
						popupJumperPower.dismiss();
					}
				}); 
				layoutJumperPower.addView(backJumperPowerButton);

				var exitJumperPowerButton = new android.widget.Button(currentActivity); 
				exitJumperPowerButton.setText("Close"); 
				exitJumperPowerButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupJumperPower.dismiss();
					}
				});
				layoutJumperPower.addView(exitJumperPowerButton);

				popupJumperPower.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function customMapsGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutCustomMaps = new android.widget.LinearLayout(currentActivity);
				layoutCustomMaps.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollCustomMaps = new android.widget.ScrollView(currentActivity);
				scrollCustomMaps.addView(layoutCustomMaps);
			
				var popupCustomMaps = new android.app.Dialog(currentActivity); 
				popupCustomMaps.setContentView(scrollCustomMaps);
				popupCustomMaps.setTitle("Custom maps");
				
				var infoTextCustomMaps = new android.widget.TextView(currentActivity);
				infoTextCustomMaps.setText("Here you can find the link of some custom maps for the Portal 2 Mod.\n" +
					"If you made a custom map and you uploaded it to minecraftforum.net, I can add your map here, just send me the link of your thread.\n" +
					"P.S.: you need an active Internet connection to display the list of custom maps.");
				infoTextCustomMaps.setTextSize(12);
				layoutCustomMaps.addView(infoTextCustomMaps);
				
				var dividerCustomMaps1Image = new android.widget.ImageView(currentActivity); 			 
 				dividerCustomMaps1Image.setImageBitmap(g[3]);
				layoutCustomMaps.addView(dividerCustomMaps1Image);
				
				
				mapsGuiCodeCount = 1;
				eval(mapsManifestDownloaded);

				
				var dividerCustomMaps2Image = new android.widget.ImageView(currentActivity); 			 
 				dividerCustomMaps2Image.setImageBitmap(g[3]);
				layoutCustomMaps.addView(dividerCustomMaps2Image);
				
				var backCustomMapsButton = new android.widget.Button(currentActivity); 
				backCustomMapsButton.setText("Back"); 
				backCustomMapsButton.setOnClickListener(new android.view.View.OnClickListener()
				{ 
					onClick: function()
					{
						informationsForPortalGUI();
						popupCustomMaps.dismiss();
					}
				}); 
				layoutCustomMaps.addView(backCustomMapsButton);

				var exitCustomMapsButton = new android.widget.Button(currentActivity); 
				exitCustomMapsButton.setText("Close"); 
				exitCustomMapsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupCustomMaps.dismiss();
					}
				});
				layoutCustomMaps.addView(exitCustomMapsButton);
				
				
				popupCustomMaps.show();
			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});		
}

function getMapsGuiCode(title, url)
{
	mapsGuiCodeCount++;
	var guiCodeToReturn = 'var infoTextMap' + mapsGuiCodeCount + ' = new android.widget.TextView(currentActivity); infoTextMap' + mapsGuiCodeCount + '.setText("' + title + '"); layoutCustomMaps.addView(infoTextMap' + mapsGuiCodeCount + '); var linkCustomMap' + mapsGuiCodeCount + 'Button = new android.widget.Button(currentActivity); linkCustomMap' + mapsGuiCodeCount + 'Button.setText("View map thread"); linkCustomMap' + mapsGuiCodeCount + 'Button.setOnClickListener(new android.view.View.OnClickListener(){ onClick: function(){ android.widget.Toast.makeText(currentActivity,"Opening the URL...",0).show(); var intentViewMapThread = new android.content.Intent(currentActivity); intentViewMapThread.setAction(android.content.Intent.ACTION_VIEW); intentViewMapThread.setData(android.net.Uri.parse("' + url + '")); currentActivity.startActivity(intentViewMapThread); popupCustomMaps.dismiss();}}); layoutCustomMaps.addView(linkCustomMap' + mapsGuiCodeCount + 'Button); var dividerTextMap' + mapsGuiCodeCount + ' = new android.widget.TextView(currentActivity); dividerTextMap' + mapsGuiCodeCount + '.setText(" "); layoutCustomMaps.addView(dividerTextMap' + mapsGuiCodeCount + '); ';
	return guiCodeToReturn;
}

function updateAvailableGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutUpdates = new android.widget.LinearLayout(currentActivity);
				layoutUpdates.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollUpdates = new android.widget.ScrollView(currentActivity);
				scrollUpdates.addView(layoutUpdates);
							
				var popupUpdates = new android.app.Dialog(currentActivity); 
				popupUpdates.setContentView(scrollUpdates);
				popupUpdates.setTitle(new android.text.Html.fromHtml("P<font color=#1E90FF>O</font>RTAL M<font color=#FFA500>O</font>D: new version"));

				var updatesText = new android.widget.TextView(currentActivity);
				updatesText.setText(new android.text.Html.fromHtml("New version available, you have the " + CURRENT_VERSION + " version and the latest version is " + latestVersion + ".<br>" +
					"You can download it at the minecraftforum.net thread (press the button to visit it)."));
				layoutUpdates.addView(updatesText);
							
				var threadButton = new android.widget.Button(currentActivity); 
				threadButton.setText("Visit thread"); 
				threadButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						visitThread();
						popupUpdates.dismiss();
					}
				});
				layoutUpdates.addView(threadButton);
				
				var backButton = new android.widget.Button(currentActivity); 
				backButton.setText("Back"); 
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationsForPortalGUI();
						popupUpdates.dismiss();
					}
				});
				layoutUpdates.addView(backButton);
				
				var exitButton = new android.widget.Button(currentActivity); 
				exitButton.setText("Close"); 
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupUpdates.dismiss();
					}
				});
				layoutUpdates.addView(exitButton);
				
				
				popupUpdates.show();
			}catch (err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function visitThread()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				android.widget.Toast.makeText(currentActivity,"Opening the URL...",0).show();
				var intentBrowser = new android.content.Intent(currentActivity);
				intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
				intentBrowser.setData(android.net.Uri.parse("http://www.minecraftforum.net/topic/2690534-modbeta-portal-2-mod-portal-gun-r001-by-desno365/"));
				currentActivity.startActivity(intentBrowser);
			}catch (err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function supportGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutSupport = new android.widget.LinearLayout(currentActivity);
				layoutSupport.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollSupport= new android.widget.ScrollView(currentActivity);
				scrollSupport.addView(layoutSupport);
			
				var popupSupport = new android.app.Dialog(currentActivity); 
				popupSupport.setContentView(scrollSupport);
				popupSupport.setTitle("Support me");

				var infoTextSupport = new android.widget.TextView(currentActivity);
				infoTextSupport.setText("Hello! My name is Dennis (also known as Desno365), I'm 17 years old and I'm trying to learn programming languages. I love modding too, and of course I do this for free. But if you want you can support me and make a donation or view an ad." +
					"\nThanks! :)");
				layoutSupport.addView(infoTextSupport);
				
				var adSupportButton = new android.widget.Button(currentActivity); 
				adSupportButton.setText("View an ad to support me"); 
				adSupportButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						android.widget.Toast.makeText(currentActivity,"Opening the URL...",0).show();
						var intentBrowser = new android.content.Intent(currentActivity);
						intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
						intentBrowser.setData(android.net.Uri.parse("http://adf.ly/qO9TU"));
						currentActivity.startActivity(intentBrowser);
						popupSupport.dismiss();
					}
				});
				layoutSupport.addView(adSupportButton);
				
				var donateSupportButton = new android.widget.Button(currentActivity); 
				donateSupportButton.setText("Make a donation"); 
				donateSupportButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						android.widget.Toast.makeText(currentActivity,"Opening the URL...",0).show();
						var intentBrowser = new android.content.Intent(currentActivity);
						intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
						intentBrowser.setData(android.net.Uri.parse("http://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=GBEMKJBA3Z7PG"));
						currentActivity.startActivity(intentBrowser);
						popupSupport.dismiss();
					}
				});
				layoutSupport.addView(donateSupportButton);
				
				var dividerTextSupport = new android.widget.TextView(currentActivity);
				dividerTextSupport.setText(" ");
				layoutSupport.addView(dividerTextSupport);
				
				var backSupportButton = new android.widget.Button(currentActivity); 
				backSupportButton.setText("Back"); 
				backSupportButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationsForPortalGUI();
						popupSupport.dismiss();
					}
				});
				layoutSupport.addView(backSupportButton);
				
				var exitSupportButton = new android.widget.Button(currentActivity); 
				exitSupportButton.setText("Close"); 
				exitSupportButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupSupport.dismiss();
					}
				});
				layoutSupport.addView(exitSupportButton);
				

				popupSupport.show();

			}catch (err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device.");
			}
		}
	});
}

function jukeboxGUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutJukebox = new android.widget.LinearLayout(currentActivity);
				layoutJukebox.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollJukebox = new android.widget.ScrollView(currentActivity);
				scrollJukebox.addView(layoutJukebox);
			
				var popupJukebox = new android.app.Dialog(currentActivity); 
				popupJukebox.setContentView(scrollJukebox);
				popupJukebox.setTitle(new android.text.Html.fromHtml("P<font color=#1E90FF>o</font>rtal Jukeb<font color=#FFA500>o</font>x"));

				var portalText = new android.widget.TextView(currentActivity);
				portalText.setText("Portal songs:");
				layoutJukebox.addView(portalText);

				var stillButton = new android.widget.Button(currentActivity); 
				stillButton.setText("Still alive"); 
				stillButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						ModPE.playMusicFromFile("portal_still_alive.mp3");
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(stillButton);

				var radioButton = new android.widget.Button(currentActivity); 
				radioButton.setText("Radio loop"); 
				radioButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						ModPE.playMusicFromFile("looping_radio_mix.wav");
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(radioButton);

				var dividerJukebox1Image = new android.widget.ImageView(currentActivity); 			 
 				dividerJukebox1Image.setImageBitmap(g[3]);
				layoutJukebox.addView(dividerJukebox1Image);

				var portal2Text = new android.widget.TextView(currentActivity);
				portal2Text.setText("Portal 2 songs:");
				layoutJukebox.addView(portal2Text);

				var wantButton = new android.widget.Button(currentActivity); 
				wantButton.setText("Want you gone"); 
				wantButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						ModPE.playMusicFromFile("portal_want_you_gone.mp3");
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(wantButton);

				var caraMiaAddioButton = new android.widget.Button(currentActivity); 
				caraMiaAddioButton.setText("Turret song - Cara Mia Addio"); 
				caraMiaAddioButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						ModPE.playMusicFromFile("portal_turret_song.mp3");
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(caraMiaAddioButton);

				var dividerJukebox2Image = new android.widget.ImageView(currentActivity); 			 
 				dividerJukebox2Image.setImageBitmap(g[3]);
				layoutJukebox.addView(dividerJukebox2Image);

				var controlsText = new android.widget.TextView(currentActivity);
				controlsText.setText("Controls");
				layoutJukebox.addView(controlsText);

				var stopMusicButton = new android.widget.Button(currentActivity); 
				stopMusicButton.setText("Stop Music"); 
				stopMusicButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						ModPE.stopMusic();
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(stopMusicButton);

				var exitJukeboxButton = new android.widget.Button(currentActivity); 
				exitJukeboxButton.setText("Close"); 
				exitJukeboxButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupJukebox.dismiss();
					}
				});
				layoutJukebox.addView(exitJukeboxButton);


				popupJukebox.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

function turretsOptionsGUI(ID)
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layoutTurretsOptions = new android.widget.LinearLayout(currentActivity);
				layoutTurretsOptions.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scrollTurretsOptions = new android.widget.ScrollView(currentActivity);
				scrollTurretsOptions.addView(layoutTurretsOptions);
			
				var popupTurretsOptions = new android.app.Dialog(currentActivity); 
				popupTurretsOptions.setContentView(scrollTurretsOptions);
				popupTurretsOptions.setTitle("Turret option");

				if(turrets[ID][4] == 1)
				{
					var aggressiveTurretsOptionsButton = new android.widget.Button(currentActivity); 
					aggressiveTurretsOptionsButton.setText("Aggressive: ON\n" +
						"Press the button to disable aggressive");
					aggressiveTurretsOptionsButton.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function()
						{
							turrets[ID][4] = 0;
							saveTurrets();
							popupTurretsOptions.dismiss();
						}
					});
				}else
				{
					var aggressiveTurretsOptionsButton = new android.widget.Button(currentActivity); 
					aggressiveTurretsOptionsButton.setText("Aggressive: OFF\n" +
						"Press the button to enable aggressive");
					aggressiveTurretsOptionsButton.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function()
						{
							turrets[ID][4] = 1;
							saveTurrets();
							popupTurretsOptions.dismiss();
						}
					});
				}
				layoutTurretsOptions.addView(aggressiveTurretsOptionsButton);

				var exitTurretsOptionsButton = new android.widget.Button(currentActivity); 
				exitTurretsOptionsButton.setText("Close"); 
				exitTurretsOptionsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popupTurretsOptions.dismiss();
					}
				});
				layoutTurretsOptions.addView(exitTurretsOptionsButton);


				popupTurretsOptions.show();

			}catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device. Report this error in the official minecraftforum.net thread, please.");
			}
		}
	});
}

