/*
 * Decompiled with CFR 0.152.
 */
package com.thedespite.noshelter;

import com.thedespite.noshelter.EntityCreeperDang;
import com.thedespite.noshelter.EntityEndherman;
import com.thedespite.noshelter.EntitySpiderBro;
import com.thedespite.noshelter.EntityZombieGoast;
import com.thedespite.noshelter.NoShelterMain;
import com.thedespite.noshelter.SpookySkellington;
import com.thedespite.noshelter.ZombieBlock;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EventHandlerClass {
    public static EventHandlerClass instance;
    public static boolean USE_INVASIONS;
    public static long INVASION_FREQUENCY;
    public static int INVASION_SPAWN_PER_TICK;
    public static boolean USE_DEBUG;
    public static int SKY_HIGH;
    public static int BASE_SPAWN_TIME;
    private boolean isD = false;
    private long reportedDate = -1L;
    static WorldServer w;
    long next = 0L;
    private final Lock lock = new ReentrantLock();
    Random rnd;
    MinecraftServer ms;
    ArrayList<PlayerDif> pDifs = new ArrayList();

    public PlayerDif GetPD(EntityPlayer p, boolean update) {
        for (int i = 0; i < this.pDifs.size(); ++i) {
            if (!this.pDifs.get((int)i).name.equals(p.getDisplayName())) continue;
            PlayerDif ret = this.pDifs.get(i);
            if (update) {
                ret.ticks = p.field_70173_aa;
            }
            return ret;
        }
        PlayerDif pd = new PlayerDif(p);
        int days = p.field_70173_aa / 24000;
        int dif = 3 * Math.max(0, 20 - days) + BASE_SPAWN_TIME;
        pd.nextSpawn = p.field_70173_aa + dif;
        this.pDifs.add(pd);
        return pd;
    }

    public void RemoveIfDied(EntityPlayer p) {
        PlayerDif pd = this.GetPD(p, false);
        if (pd.ticks > p.field_70173_aa) {
            int days = pd.ticks / 24000;
            int newDays = Math.min(days - 3, 20);
            newDays = Math.max(0, newDays);
            p.field_70173_aa = newDays * 24000;
            EventHandlerClass.BroadcastMsg(this.ms, "Player: " + String.valueOf(p.getDisplayName() + " new personal dif: " + String.valueOf(newDays)), true);
            int dif = 3 * Math.max(0, 20 - newDays) + BASE_SPAWN_TIME;
            pd.nextSpawn = p.field_70173_aa + dif;
        }
    }

    private void SpawnMobsForPlayer(EntityPlayer p) {
        this.RemoveIfDied(p);
        PlayerDif pd = this.GetPD(p, true);
        int days = p.field_70173_aa / 24000;
        int dif = 3 * Math.max(0, 20 - days) + BASE_SPAWN_TIME;
        pd.dif = dif *= 20;
        if (p.field_70173_aa > pd.nextSpawn) {
            this.SpawnMobs(p, pd);
            pd.nextSpawn = p.field_70163_u > (double)SKY_HIGH ? p.field_70173_aa + dif / 2 : p.field_70173_aa + dif;
        }
    }

    private void SpawnMobs(EntityPlayer p, PlayerDif pd) {
        int yMax = w.func_72940_L() - 10;
        boolean spawned = false;
        int tries = 0;
        while (!spawned && tries < 10) {
            int y;
            ++tries;
            int x = (int)(p.field_70165_t + (double)this.rnd.nextInt(64) - 32.0);
            int z = (int)(p.field_70161_v + (double)this.rnd.nextInt(64) - 32.0);
            int normalBlock = -1;
            boolean forceSpawn = false;
            if (p.field_70163_u < 64.0) {
                y = w.func_72935_r() ? (int)(p.field_70163_u - 64.0) : (int)(p.field_70163_u - 64.0);
                if (y < 0) {
                    y = 0;
                }
                while (y < yMax && !w.func_147437_c(x, y, z)) {
                    ++y;
                }
            } else if (p.field_70163_u > (double)SKY_HIGH) {
                forceSpawn = true;
                x = (int)(p.field_70165_t + (double)this.rnd.nextInt(32) - 16.0);
                z = (int)(p.field_70161_v + (double)this.rnd.nextInt(32) - 16.0);
                int dif = (int)Math.sqrt(Math.pow((double)x - p.field_70165_t, 2.0) + Math.pow((double)z - p.field_70161_v, 2.0));
                y = (int)(p.field_70163_u - (double)dif - 2.0);
            } else {
                normalBlock = 0;
                for (y = yMax; y > 0 && !this.CanSpawnHere(x, y, z); --y) {
                }
            }
            if (forceSpawn) {
                this.SpawnSkyIsland(x, y, z);
                EventHandlerClass.BroadcastMsg(this.ms, "Spawning sky island at y: " + String.valueOf(y), true);
            }
            if (!forceSpawn && (y == yMax || !this.CanSpawnHere(x, y + normalBlock, z) || w.func_72957_l(x, y + normalBlock + 1, z) >= 10)) continue;
            EventHandlerClass.BroadcastMsg(this.ms, "Spawn at: " + String.valueOf(y + 2) + ". Tries: " + String.valueOf(tries) + ". " + "Dif: " + String.valueOf(pd.dif) + ". Bas: " + String.valueOf(BASE_SPAWN_TIME), true);
            spawned = true;
            for (int i = 0; i < INVASION_SPAWN_PER_TICK; ++i) {
                int xx = x;
                int yy = y;
                int zz = z;
                yy += 2 + i;
                int r = this.rnd.nextInt(32);
                if (r == 0 && NoShelterMain.CREEPER_ENABLED) {
                    this.SpawnCD(xx, yy, zz);
                    continue;
                }
                if (r == 1 && NoShelterMain.FUCKENSPIDER_ENABLED) {
                    this.SpawnSB(xx, yy, zz);
                    continue;
                }
                if (r == 2 && NoShelterMain.SKELETON_ENABLED) {
                    EventHandlerClass.SpawnSS(xx, yy, zz);
                    continue;
                }
                if (r == 3 && i < 3 && NoShelterMain.ENDERMAN_ENABLED) {
                    this.SpawnEHM(xx, yy, zz);
                    i = 5;
                    continue;
                }
                if (!NoShelterMain.ZOMBIE_ENABLED) continue;
                this.SpawnZG(xx, yy, zz);
            }
        }
        if (tries >= 10) {
            EventHandlerClass.BroadcastMsg(this.ms, "Try limit exceeded", true);
        }
    }

    private void SpawnSkyIsland(int x, int y, int z) {
        for (int a = x - 4; a < x + 4; ++a) {
            for (int b = z - 4; b < z + 4; ++b) {
                if (!w.func_147437_c(a, y, b)) continue;
                w.func_147449_b(a, y, b, ZombieBlock.self);
            }
        }
    }

    private boolean CanSpawnHere(int x, int y, int z) {
        return !w.func_147437_c(x, y, z);
    }

    @SubscribeEvent
    public void tickEvent(TickEvent event) {
        if (event.type == TickEvent.Type.SERVER) {
            if (this.ms == null || this.ms != FMLCommonHandler.instance().getMinecraftServerInstance()) {
                this.ms = FMLCommonHandler.instance().getMinecraftServerInstance();
            }
            for (int i = 0; i < this.ms.field_71305_c.length; ++i) {
                if (this.ms.field_71305_c[i] == null || this.ms.field_71305_c[i].field_73010_i.size() <= 0) continue;
                w = this.ms.field_71305_c[i];
            }
            if (w == null) {
                return;
            }
            if (this.rnd == null) {
                this.rnd = new Random();
            }
            instance = this;
            long date = w.func_72820_D() / 24000L;
            long thclk = w.func_72820_D() / 12000L;
            if (date != this.reportedDate) {
                EventHandlerClass.BroadcastMsg(this.ms, "Day: " + date, true);
                this.reportedDate = date;
            }
            boolean isDay = false;
            if (thclk % 2L == 0L) {
                isDay = true;
            }
            if (!this.isD && date != 0L && date % INVASION_FREQUENCY == 0L && !isDay && USE_INVASIONS) {
                this.isD = true;
                EventHandlerClass.BroadcastMsg(this.ms, "Invasion Start", false);
            } else if (isDay && this.isD) {
                this.isD = false;
                EventHandlerClass.BroadcastMsg(this.ms, "Invasion End", false);
            }
            if (this.isD) {
                for (int i = 0; i < EventHandlerClass.w.field_73010_i.size(); ++i) {
                    EntityPlayer p = (EntityPlayer)EventHandlerClass.w.field_73010_i.get(i);
                    this.SpawnMobsForPlayer(p);
                }
            }
        }
    }

    private void SpawnZG(double x, double y, double z) {
        EntityZombieGoast ezg = new EntityZombieGoast((World)w);
        ezg.func_70012_b(x, y, z, 0.0f, 0.0f);
        w.func_72838_d((Entity)ezg);
    }

    private void SpawnCD(double x, double y, double z) {
        EntityCreeperDang ecd = new EntityCreeperDang((World)w);
        ecd.func_70012_b(x, y, z, 0.0f, 0.0f);
        w.func_72838_d((Entity)ecd);
    }

    private void SpawnSB(double x, double y, double z) {
        EntitySpiderBro esb = new EntitySpiderBro((World)w);
        esb.func_70012_b(x, y, z, 0.0f, 0.0f);
        w.func_72838_d((Entity)esb);
    }

    public static void SpawnSS(double x, double y, double z) {
        SpookySkellington ss = new SpookySkellington((World)w);
        ss.func_70012_b(x, y, z, 0.0f, 0.0f);
        w.func_72838_d((Entity)ss);
    }

    private void SpawnEHM(double x, double y, double z) {
        EntityEndherman ehm = new EntityEndherman((World)w);
        ehm.func_70012_b(x, y, z, 0.0f, 0.0f);
        w.func_72838_d((Entity)ehm);
    }

    public static void BroadcastMsg(MinecraftServer server, String message, boolean debug) {
        if (USE_DEBUG || !debug) {
            ChatComponentText msg = new ChatComponentText(message);
            server.func_71203_ab().func_148539_a((IChatComponent)msg);
        }
    }

    static {
        USE_INVASIONS = true;
        INVASION_FREQUENCY = 2L;
        INVASION_SPAWN_PER_TICK = 5;
        USE_DEBUG = false;
        SKY_HIGH = 96;
        BASE_SPAWN_TIME = 40;
    }

    class PlayerDif {
        public String name;
        public int ticks;
        public int dif;
        public int nextSpawn;

        public PlayerDif(EntityPlayer p) {
            this.name = p.getDisplayName();
            this.ticks = p.field_70173_aa;
        }
    }
}

