/*
 * Decompiled with CFR 0.152.
 */
package com.thedespite.noshelter;

import com.thedespite.noshelter.BaseSpawnCommand;
import com.thedespite.noshelter.DifficultyCommand;
import com.thedespite.noshelter.EntityCreeperDang;
import com.thedespite.noshelter.EntityEndherman;
import com.thedespite.noshelter.EntitySpiderBro;
import com.thedespite.noshelter.EntityZombieGoast;
import com.thedespite.noshelter.EventHandlerClass;
import com.thedespite.noshelter.SpookySkellington;
import com.thedespite.noshelter.ZombieBlock;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="noshelter", version="2.1")
public class NoShelterMain {
    public static final String MODID = "noshelter";
    public static final String VERSION = "2.1";
    public static final double FOLLOW_DISTANCE = 50.0;
    public static int[] BLACKLISTED_BLOCKS;
    public static boolean ZOMBIE_ENABLED;
    public static boolean ENDERMAN_ENABLED;
    public static boolean FUCKENSPIDER_ENABLED;
    public static boolean CREEPER_ENABLED;
    public static boolean SKELETON_ENABLED;
    public static boolean EXPLODINGARROW_ENABLED;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BaseSpawnCommand());
        event.registerServerCommand((ICommand)new DifficultyCommand());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Property invasionEnabledProp = config.get("Invasion Config", "UseInvasions", true);
        boolean bUseInvasions = invasionEnabledProp.getBoolean();
        invasionEnabledProp.comment = "Are invasions enabled? Default: true";
        EventHandlerClass.USE_INVASIONS = bUseInvasions;
        Property invasionEveryNNightsProp = config.get("Invasion Config", "InvasionEvery_n_Nights", 2);
        int iInvasionEveryN = invasionEveryNNightsProp.getInt();
        invasionEveryNNightsProp.comment = "The frequency of invasions. Default: 2, means invasion every other night.";
        EventHandlerClass.INVASION_FREQUENCY = iInvasionEveryN;
        Property invasionSpawnPerTickProp = config.get("Invasion Config", "InvasionSpawnPerTick", 5);
        int iInvasionSpawnPerTick = invasionSpawnPerTickProp.getInt();
        invasionSpawnPerTickProp.comment = "The number of enemies to spawn at once. Default: 5";
        EventHandlerClass.INVASION_SPAWN_PER_TICK = iInvasionSpawnPerTick;
        Property debugProp = config.get("Debug", "UseDebug", false);
        boolean bUseDebug = debugProp.getBoolean();
        debugProp.comment = "Are you debugging this? Default: false";
        EventHandlerClass.USE_DEBUG = bUseDebug;
        Property zombieBlockBreakSpeedProp = config.get("Mob Config", "ZombieBlockBreakSpeed", 1.0);
        float fZombieBlockBreakSpeed = (float)zombieBlockBreakSpeedProp.getDouble();
        zombieBlockBreakSpeedProp.comment = "The speed at which zombies dig through blocks. Default: 1.0";
        EntityZombieGoast.ZOMBIE_BLOCK_BREAK_SPEED = fZombieBlockBreakSpeed;
        Property zombieEnabledProp = config.get("Mob Config", "ZombieEnabled", true);
        ZOMBIE_ENABLED = zombieEnabledProp.getBoolean();
        zombieEnabledProp.comment = "Are you using NoShelter Zombies? Default: true";
        Property spiderEnabledProp = config.get("Mob Config", "SpiderEnabled", true);
        FUCKENSPIDER_ENABLED = spiderEnabledProp.getBoolean();
        spiderEnabledProp.comment = "Are you using NoShelter Spiders? Default: true";
        Property skeletonEnabledProp = config.get("Mob Config", "SkeletonEnabled", true);
        SKELETON_ENABLED = skeletonEnabledProp.getBoolean();
        skeletonEnabledProp.comment = "Are you using NoShelter Skeletons? Default: true";
        Property endermanEnabledProp = config.get("Mob Config", "EndermanEnabled", true);
        ENDERMAN_ENABLED = endermanEnabledProp.getBoolean();
        endermanEnabledProp.comment = "Are you using NoShelter Endermen? Default: true";
        Property creeperEnabledProp = config.get("Mob Config", "CreeperEnabled", true);
        CREEPER_ENABLED = creeperEnabledProp.getBoolean();
        creeperEnabledProp.comment = "Are you using NoShelter Creeper? Default: true";
        Property explodArrowEnabledProp = config.get("Mob Config", "ExplodingArrowsEnabled", true);
        EXPLODINGARROW_ENABLED = explodArrowEnabledProp.getBoolean();
        explodArrowEnabledProp.comment = "Skeletons use Exploding Arrows? Default: true";
        int[] blacklist = new int[]{};
        Property blacklistedBlocksProp = config.get("Blocks", "BlacklistedBlocks", blacklist);
        blacklist = blacklistedBlocksProp.getIntList();
        blacklistedBlocksProp.comment = "Write IDs for blocks that zombies do not break";
        BLACKLISTED_BLOCKS = blacklist;
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int i;
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClass());
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerClass());
        EntityRegistry.registerModEntity(EntityZombieGoast.class, (String)"ZombieGoast", (int)0, (Object)this, (int)120, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityCreeperDang.class, (String)"SmartCreeper", (int)1, (Object)this, (int)120, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntitySpiderBro.class, (String)"SpiderBro", (int)2, (Object)this, (int)120, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(SpookySkellington.class, (String)"SpookySkellington", (int)3, (Object)this, (int)120, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityEndherman.class, (String)"Endherman", (int)4, (Object)this, (int)120, (int)1, (boolean)true);
        for (i = 0; i < 1024; ++i) {
            BiomeGenBase bullshit = BiomeGenBase.func_150568_d((int)i);
            if (i != 0 && (bullshit == null || bullshit == BiomeGenBase.field_76771_b)) break;
            if (ZOMBIE_ENABLED) {
                EntityRegistry.addSpawn(EntityZombieGoast.class, (int)200, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
                EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
            }
            if (FUCKENSPIDER_ENABLED) {
                EntityRegistry.addSpawn(EntitySpiderBro.class, (int)50, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
                EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
            }
            if (ENDERMAN_ENABLED) {
                EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
            }
            if (CREEPER_ENABLED) {
                EntityRegistry.addSpawn(EntityCreeperDang.class, (int)100, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
                EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
            }
            if (!SKELETON_ENABLED) continue;
            EntityRegistry.addSpawn(SpookySkellington.class, (int)10, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.func_150568_d((int)i)});
        }
        System.out.println("Number of biomes: " + String.valueOf(i));
        ZombieBlock.InitSelf();
    }

    static {
        ZOMBIE_ENABLED = true;
        ENDERMAN_ENABLED = true;
        FUCKENSPIDER_ENABLED = true;
        CREEPER_ENABLED = true;
        SKELETON_ENABLED = true;
        EXPLODINGARROW_ENABLED = true;
    }
}

