<?php
 namespace Module\ShortLink\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Grid\GridFilter; use ModStart\Support\Concern\HasFields; use Module\Member\Util\MemberCmsUtil; use Module\ShortLink\Util\LinkUtil; class LinkController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $builder) { $builder ->init('link') ->field(function ($builder) { $builder->id('id', 'ID')->width(150); $builder->display('memberUserId', '用户')->hookRendering(function (AbstractField $field, $item, $index) { return AutoRenderedFieldValue::make(MemberCmsUtil::showFromId($item->memberUserId)); }); $builder->display('_shortUrl', '链接')->hookRendering(function (AbstractField $field, $item, $index) { $link = LinkUtil::combileLink($item->urlBase, $item->id); return AutoRenderedFieldValue::make('<a href="' . $link . '" target="_blank">' . $link . '</a>'); }); $builder->display('url', '原URL'); $builder->datetime('expire', '过期')->width(100)->hookRendering(function (AbstractField $field, $item, $index) { if (empty($item->expire)) { $text = '永不过期'; } else { $text = TimeUtil::format($item->expire); } return AutoRenderedFieldValue::make($text); }); $builder->display('created_at', L('Created At')); $builder->display('updated_at', L('Updated At')); }) ->gridFilder(function (GridFilter $filter) { $filter->eq('id', L('ID')); $filter->eq('memberUserId', '用户ID'); }) ->canShow(false)->canEdit(false)->canAdd(false) ->title('短链接'); } }