<?php
 namespace ModStart\Core\RateLimit; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Request; use ModStart\Core\Util\RedisUtil; use Symfony\Component\HttpFoundation\IpUtils; class RateLimitMiddleware { public function handle($request, \Closure $next) { if (RedisUtil::isEnable()) { $ip = Request::ip(); if (modstart_config('systemVisitBlackListEnable', false)) { $list = modstart_config('systemVisitBlackList'); foreach (explode("\n", $list) as $ipRange) { $ipRange = trim($ipRange); if (empty($ipRange)) { continue; } if (IpUtils::checkIp4($ip, $ipRange)) { Log::warning('Firewall.BlackList.Forbidden -> ' . $ipRange . ' - ' . $ip); return 'Access Forbidden (B) !'; } } } if (modstart_config('systemVisitWhiteListEnable', false)) { $list = modstart_config('systemVisitWhiteList'); $pass = false; foreach (explode("\n", $list) as $ipRange) { $ipRange = trim($ipRange); if (empty($ipRange)) { continue; } if (IpUtils::checkIp4($ip, $ipRange)) { $pass = true; break; } } if (!$pass) { Log::warning('Firewall.WhiteList.Forbidden -> ' . $ipRange . ' - ' . $ip); return 'Access Forbidden (W) !'; } } $key = 'F:V:' . $ip; RedisUtil::incr($key); RedisUtil::expire($key, 3600 * 24); } return $next($request); } }