<?php
 namespace App\Http\Controllers\Admin; use App\Util\ESUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Admin\Cms\ConfigCms; use TechSoft\Laravel\Admin\Cms\Field\FieldSwitch; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Util\HtmlUtil; class ESController extends AdminCheckController { public function setting(ConfigCms $configCms) { $ret = $configCms->execute($this, [ 'group' => 'setting', 'pageTitle' => '全文搜索功能设置', 'fields' => [ 'moduleESEnable' => ['type' => FieldSwitch::class, 'title' => '开启全文索引', 'desc' => '需要配置ElasticSearch'], 'moduleESHost' => ['type' => FieldText::class, 'title' => 'ElasticSearchHost', 'desc' => ''], 'moduleESPort' => ['type' => FieldText::class, 'title' => 'ElasticSearch端口', 'desc' => ''], 'moduleESUser' => ['type' => FieldText::class, 'title' => 'ElasticSearch用户', 'desc' => ''], 'moduleESPass' => ['type' => FieldText::class, 'title' => 'ElasticSearch密码', 'desc' => ''], ] ]); if (Request::isPost()) { $client = ESUtil::client(); try { $info = $client->info(); } catch (\Exception $e) { return Response::send(-1, '无法根据您的配置信息连接到ElasticSearch'); } } return $ret; } public function sync() { if (Request::isPost()) { if (!ConfigGet('moduleESEnable', false)) { return Response::send(-1, '请先打开全文索引'); } $input = InputPackage::buildFromInput(); $index = $input->getTrimString('index'); ESUtil::createIndex($index, 'v1'); ESUtil::putAlias($index, 'v1'); switch ($input->getTrimString('action')) { case 'refresh': $stats = ESUtil::statsIndex($index); $data = []; $data['count'] = $stats['total']['docs']['count']; return Response::send(0, 'ok', $data); case 'sync': $nextId = $input->getInteger('nextId', 0); $data = [ 'syncCount' => 0, 'nextId' => 0, ]; switch ($index) { case 'question': $ret = ModelUtil::batch('question', $nextId, 1000); ESUtil::syncQuestions($ret['records']); $data['syncCount'] = count($ret['records']); $data['nextId'] = $ret['nextId']; break; } return Response::send(0, 'ok', $data); } return Response::send(-1, '请求错误'); } return view('admin.es.sync'); } }