<?php
 namespace App\Http\Controllers\Admin; use App\Types\PaperExamStatus; use App\Util\PaperUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldDatetime; use TechSoft\Laravel\Admin\Cms\Field\FieldEmpty; use TechSoft\Laravel\Admin\Cms\Field\FieldSelect; use TechSoft\Laravel\Admin\Cms\Field\FieldSwitch; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminPowerUtil; use TechSoft\Laravel\Assets\AssetsUtil; use Illuminate\Support\Facades\Input; class PaperExamController extends AdminCheckController { private $cmsConfigData = [ 'model' => 'paper_exam', 'pageTitle' => '阅卷管理', 'group' => 'data', 'canDelete' => true, 'canEdit' => true, 'editInNewWindow' => true, 'fields' => [ '_paper' => ['type' => FieldEmpty::class, 'title' => '试卷', 'list' => true,], '_memberUser' => ['type' => FieldEmpty::class, 'title' => '用户', 'list' => true,], 'status' => ['type' => FieldSelect::class, 'title' => '状态', 'list' => true, 'search' => true, 'optionType' => PaperExamStatus::class,], 'isJudge' => ['type' => FieldSwitch::class, 'title' => '已经阅卷', 'list' => true, 'search' => true, 'optionType' => PaperExamStatus::class,], 'startTime' => ['type' => FieldDatetime::class, 'title' => '开始时间', 'list' => true,], 'score' => ['type' => FieldDatetime::class, 'title' => '分数', 'list' => true,], ] ]; public function dataProcessViewField($key, &$record) { switch ($key) { case '_memberUser': $memberUser = ModelUtil::get('member_user', ['id' => $record['memberUserId']]); if (empty($memberUser)) { return '[未知用户]'; } return '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\MemberController@dataView', ['_id' => $record['memberUserId']]) . '"><img src="' . AssetsUtil::fix($memberUser['avatar']) . '" style="width:30px;height:30px;" />' . htmlspecialchars($memberUser['username']) . '</a>'; case '_paper': $paper = ModelUtil::get('paper', ['id' => $record['paperId']]); return '<a target="_blank" href="/paper/view/' . $paper['alias'] . '">' . htmlspecialchars($paper['title']) . '</a>'; } } public function dataList(BasicCms $basicCms) { return $basicCms->executeList($this, $this->cmsConfigData); } public function dataEdit() { $id = Input::get('_id'); $paperExam = ModelUtil::get('paper_exam', ['id' => $id]); $paperExamQuestions = PaperUtil::listPaperExamQuestions($paperExam['id']); if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return Response::send(-1, '演示账号禁止修改信息'); } $data = InputPackage::buildFromInput()->getJson('data'); if (empty($data)) { return Response::send(-1, '提交数据为空'); } $totalScore = 0; $paperExamQuestions = $data; foreach ($paperExamQuestions as $paperExamQuestion) { ModelUtil::update('paper_exam_question', ['id' => $paperExamQuestion['id']], [ 'score' => json_encode($paperExamQuestion['score']) ]); foreach ($paperExamQuestion['score'] as $item) { $totalScore += $item; } } ModelUtil::update('paper_exam', [ 'id' => $paperExam['id'] ], [ 'score' => $totalScore, 'isJudge' => true, ]); return Response::send(0, '提交成功', null, action('\App\Http\Controllers\Admin\PaperExamController@dataList')); } $paper = PaperUtil::getPaper($paperExam['paperId']); $paperQuestions = PaperUtil::listQuestions($paperExam['paperId']); return view('admin.paperExam.edit', compact('id', 'paper', 'paperQuestions', 'paperExamQuestions')); } public function dataDelete() { $_id = Input::get('_id'); if (!is_array($_id)) { $ids = explode(',', $_id); $_id = []; foreach ($ids as $id) { if (empty($id)) { continue; } $_id[] = $id; } } if (empty($_id)) { return Response::send(-1, '_id empty'); } foreach ($_id as $id) { ModelUtil::delete('paper_exam', ['id' => $id]); ModelUtil::delete('paper_exam_question', ['examId' => $id]); } return Response::send(0, 'ok'); } }