<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Util\PaperUtil; use App\Util\QuestionUtil; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; class MemberExamController extends BaseController implements MemberLoginCheck { public function index() { $page = intval(Input::get('page', 1)); if ($page < 1) { $page = 1; } $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $option['where']['memberUserId'] = $this->memberUserId(); $paginateData = ModelUtil::paginate('paper_exam', $page, $pageSize, $option); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); ModelUtil::join($paginateData['records'], 'paperId', '_paper', 'paper', 'id'); $paperExams = $paginateData['records']; return $this->_view('memberExam.index', compact( 'paperExams', 'pageHtml' )); } public function view($id) { $paperExam = PaperUtil::getPaperExam($id); if (empty($paperExam) || $paperExam['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '考试不存在'); } if (!$paperExam['isJudge']) { return Response::send(-1, '正在阅卷,请稍后查看'); } $paperExamQuestions = PaperUtil::listPaperExamQuestions($paperExam['id']); $paper = PaperUtil::getPaper($paperExam['paperId']); if (empty($paper)) { return Response::send(-1, '试卷不存在'); } $paperQuestions = PaperUtil::listQuestions($paper['id']); foreach ($paperQuestions as &$paperQuestion) { $paperQuestion['_questionData'] = QuestionUtil::getQuestionData($paperQuestion['questionId']); } return $this->_view('memberExam.view', compact( 'paper', 'paperQuestions', 'paperExam', 'paperExamQuestions' )); } }