<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Ad\AdUtil; use TechSoft\Laravel\Util\HtmlUtil; class NewsController extends BaseController { public function index() { $page = Input::get('page', 1); $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $categoryId = Input::get('category_id'); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('news', $page, $pageSize, $option); $categories = ModelUtil::model('news_category')->orderBy('sort', 'asc')->get()->toArray(); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $news = $paginateData['records']; foreach ($news as &$new) { $info = HtmlUtil::extractTextAndImages($new['content']); $new['summary'] = $info['text']; } $dataView = []; $dataView['news'] = $news; $dataView['categoryId'] = $categoryId; $dataView['categories'] = $categories; $dataView['pageHtml'] = $pageHtml; $dataView['ads'] = AdUtil::listByPositionWithCache('pcNewsListRight'); return $this->_view('news.list', $dataView); } public function view($id) { $news = ModelUtil::get('news', ['id' => $id]); if (empty($news)) { return Response::send(-1, 'new not found'); } $news['_category'] = ModelUtil::get('news_category', ['id' => $news['categoryId']]); $newsLatest = ModelUtil::model('news')->orderBy('id', 'desc')->limit(6)->get()->toArray(); $dataView = []; $dataView['news'] = $news; $dataView['newsLatest'] = $newsLatest; $dataView['ads'] = AdUtil::listByPositionWithCache('pcNewsViewRight'); return $this->_view('news.view', $dataView); } }