<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Util\ESUtil; use App\Util\QuestionUtil; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Config\ConfigUtil; class SearchController extends BaseController { public function index() { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); return Response::send(0, null, null, '/search/question?keywords=' . urlencode($keywords)); } public function question() { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); $maxPage = ConfigUtil::getInteger('tikuSearchQuestionMaxPage', 20); $page = min($input->getInteger('page', 1), $maxPage); $pageSize = 10; $option = []; if (ConfigUtil::getWithEnv('moduleESEnable', false) && $keywords) { $option = []; $option['search'] = [['keywords' => ['like' => $keywords]]]; $esPaginateData = ESUtil::paginateQuestion($page, $pageSize, $option); $paginateData = []; $paginateData['total'] = $esPaginateData['total']; $paginateData['records'] = QuestionUtil::listQuestions(array_map(function ($item) { return $item['id']; }, $esPaginateData['records'])); $records = $paginateData['records']; } else { $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['questionText', 'like', '%' . $keywords . '%']; $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $records = $paginateData['records']; } $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $viewData = []; $viewData['pageTitle'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索题目“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['pageHtml'] = $pageHtml; return $this->_view('search.question', $viewData); } public function paper() { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); $maxPage = ConfigUtil::getInteger('tikuSearchPaperMaxPage', 20); $page = min($input->getInteger('page', 1), $maxPage); $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['title', 'like', '%' . $keywords . '%']; $paginateData = ModelUtil::paginate('paper', $page, $pageSize, $option); $records = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $viewData = []; $viewData['pageTitle'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索试卷“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['pageHtml'] = $pageHtml; return $this->_view('search.paper', $viewData); } public function vipArticle() { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); $maxPage = ConfigUtil::getInteger('tikuSearchVipArticleMaxPage', 20); $page = min($input->getInteger('page', 1), $maxPage); $pageSize = 10; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['whereOperate'][] = ['title', 'like', '%' . $keywords . '%']; $paginateData = ModelUtil::paginate('vip_article', $page, $pageSize, $option); $records = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $viewData = []; $viewData['pageTitle'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['pageDescription'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['pageKeywords'] = '搜索付费内容“' . htmlspecialchars($keywords) . '”'; $viewData['keywords'] = $keywords; $viewData['records'] = $records; $viewData['pageHtml'] = $pageHtml; return $this->_view('search.vipArticle', $viewData); } }