<?php
 namespace App\Http\Controllers\Main; use App\Constant\PayConstant; use App\Http\Controllers\BaseController; use App\Types\VipArticleOrderStatus; use App\Util\VipArticleUtil; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Ad\AdUtil; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberVip\MemberVipUtil; use TechSoft\Laravel\Oauth\OauthType; use TechSoft\Laravel\Pay\PayUtil; use TechSoft\Laravel\Pay\Services\PayOrderUtil; use TechSoft\Laravel\Pay\Types\PayType; use TechSoft\Laravel\Shop\Types\OrderStatus; use TechSoft\Laravel\Util\HtmlUtil; class VipArticleController extends BaseController { public function index() { $page = Input::get('page', 1); $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $categoryId = Input::get('category_id'); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('vip_article', $page, $pageSize, $option); $categories = ModelUtil::model('vip_article_category')->orderBy('sort', 'asc')->get()->toArray(); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $vipArticles = $paginateData['records']; foreach ($vipArticles as &$new) { $info = HtmlUtil::extractTextAndImages($new['content']); $new['summary'] = $info['text']; } $dataView = []; $dataView['vipArticles'] = $vipArticles; $dataView['categoryId'] = $categoryId; $dataView['categories'] = $categories; $dataView['pageHtml'] = $pageHtml; return $this->_view('vipArticle.list', $dataView); } public function view($id) { $vipArticle = ModelUtil::get('vip_article', ['id' => $id]); if (empty($vipArticle)) { return Response::send(-1, 'vip article not found'); } if (Request::isPost()) { if (!$this->memberUserId()) { return Response::send(-1, '请先登录', null, '/login?redirect=' . urlencode(Request::currentPageUrl())); } $input = InputPackage::buildFromInput(); $payType = $input->getType('payType', PayType::class, null); if (empty($payType)) { return Response::send(-1, '支付方式错误'); } if (!PayUtil::isPayEnable($payType)) { return Response::send(-1, '支付方式未开启'); } $money = $vipArticle['fee']; if ($money < 0.01) { return Response::send(-1, '支付金额为空'); } $vipArticleOrder = ModelUtil::insert('vip_article_order', [ 'status' => VipArticleOrderStatus::WAIT_PAY, 'memberUserId' => $this->memberUserId(), 'articleId' => $vipArticle['id'], 'payFee' => $money, ]); switch ($payType) { case PayType::ALIPAY: $ret = PayOrderUtil::create( PayConstant::VIP_ARTICLE, $vipArticleOrder['id'], $payType, $vipArticleOrder['payFee'], '购买付费文章-' . $vipArticleOrder['id'], '购买付费文章-' . $vipArticleOrder['id'], '/vip_article/' . $vipArticle['id'], ['alipay_wap' => $this->isMobile() ? true : false] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['payRedirect'] = $ret['data']['link']; $data['successRedirect'] = '/vip_article/' . $vipArticle['id']; return Response::send(0, null, $data); case PayType::WECHAT_MOBILE: $openId = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WECHAT_MOBILE); if (empty($openId)) { return Response::send(-1, null, null, '/oauth_login_' . OauthType::WECHAT_MOBILE . '?redirect=' . urlencode(View::shared('base_request_path'))); } $ret = PayOrderUtil::create( PayConstant::VIP_ARTICLE, $vipArticleOrder['id'], $payType, $vipArticleOrder['payFee'], '用户打赏-' . $vipArticleOrder['id'], '用户打赏-' . $vipArticleOrder['id'], '/vip_article/' . $vipArticle['id'], ['openId' => $openId] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['json'] = $ret['data']['json']; $data['successRedirect'] = $ret['data']['successRedirect']; return Response::send(0, null, $data); case PayType::WECHAT: $ret = PayOrderUtil::create( PayConstant::VIP_ARTICLE, $vipArticleOrder['id'], $payType, $vipArticleOrder['payFee'], '用户打赏-' . $vipArticleOrder['id'], '用户打赏-' . $vipArticleOrder['id'], '/vip_article/' . $vipArticle['id'], [] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['codeUrl'] = $ret['data']['codeUrl']; $data['successRedirect'] = $ret['data']['successRedirect']; $data['watchUrl'] = '/vip_article/watch/' . $vipArticleOrder['id']; return Response::send(0, null, $data); default: return Response::send(-1, '支付方式错误'); } } $vipArticle['_category'] = ModelUtil::get('vip_article_category', ['id' => $vipArticle['categoryId']]); $vipArticleLatest = ModelUtil::model('vip_article')->orderBy('id', 'desc')->limit(6)->get()->toArray(); $dataView = []; $dataView['vipArticle'] = $vipArticle; $dataView['vipArticleLatest'] = $vipArticleLatest; $dataView['vipArticleBought'] = VipArticleUtil::hasBought($this->memberUserId(), $vipArticle['id']); return $this->_view('vipArticle.view', $dataView); } public function watch($id) { $order = ModelUtil::get('vip_article_order', ['id' => $id, 'memberUserId' => $this->memberUserId()]); switch ($order['status']) { case OrderStatus::WAIT_PAY: return Response::send(0, null, ['status' => 'new']); case OrderStatus::COMPLETED: return Response::send(0, null, ['status' => 'payed']); case OrderStatus::CANCEL_EXPIRED: return Response::send(0, null, ['status' => 'expired']); default: return Response::send(-1, 'order status error'); } } }