<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ModifyQuestion20200514 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        ini_set("memory_limit", "-1");
        set_time_limit(0);

        Schema::table('question', function (Blueprint $table) {

            $table->string('questionText', 2000)->nullable()->comment('问题（纯文本）');

        });

        foreach (\TechOnline\Laravel\Dao\ModelUtil::all('question', [], ['id', 'question']) as $item) {
            \TechOnline\Laravel\Dao\ModelUtil::update('question', $item['id'], [
                'questionText' => \TechSoft\Laravel\Util\HtmlUtil::text($item['question']),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
