<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('siteFavIco'))}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription'))">
    <meta name="viewport" content="width=device-width, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <link rel="stylesheet" href="https://at.alicdn.com/t/font_359250_hhtsjbon7e.css">
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle')@yield('pageTitleMain') - {{\TechSoft\Laravel\Config\ConfigUtil::get('siteName')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fix('theme/'.\TechSoft\Laravel\Config\ConfigUtil::get('siteTemplate','default').'/pc/css/style.css')}}"/>
    @show
    @section('headAppend')@show
    {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
</head>
<body>
@section('body')

    <header>
        <div class="main-container">
            <nav class="uk-navbar">
                <ul class="uk-navbar-nav uk-navbar-nav-right">
                    @if(\TechSoft\Laravel\MemberVip\MemberVipUtil::isEnable())
                        @if(empty($_memberUser))
                            <li><a href="/member/vip" class="ub-color-vip"><i class="iconfont icon-VIP"></i> 开通会员</a></li>
                        @else
                            <li><a href="/member/vip" class="ub-color-vip"><i class="iconfont icon-VIP"></i> {{$_memberVip?$_memberVip['title']:'会员'}}</a></li>
                        @endif
                    @endif
                    @if(empty($_memberUser))
                        @if(!\TechSoft\Laravel\Config\ConfigUtil::get('registerDisable',false))
                            <li><a href="/register">注册</a></li>
                        @endif
                        <li><a href="/login">登录</a></li>
                    @else
                        <li>
                            <a href="/member/message" class="notice">
                                <i class="uk-icon-bell"></i>
                                <?php $count = \TechSoft\Laravel\MemberMessage\MemberMessageUtil::getUnreadMessageCount($_memberUser['id']); ?>
                                @if($count)
                                    <span class="count" data-member-unread-message-count>{{$count}}</span>
                                @endif
                            </a>
                        </li>
                        <li class="uk-parent" data-uk-dropdown>
                            <a href="javascript:;" class="username">{{\TechSoft\Laravel\Member\MemberUtil::viewName($_memberUser)}}</a>
                            <div class="uk-dropdown uk-dropdown-navbar uk-dropdown-bottom" style="top: 40px; left: 0px;">
                                <ul class="uk-nav uk-nav-navbar">
                                    <li><a href="/member"><i class="uk-icon-user"></i> 个人中心</a></li>
                                    <li><a data-confirm="确定退出?" data-href="/logout"><i class="uk-icon-sign-out"></i> 退出</a></li>
                                </ul>
                            </div>
                        </li>
                    @endif
                </ul>
                <a class="uk-navbar-brand uk-hidden-small" href="/"><img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'))}}" /></a>
                <ul class="uk-navbar-nav">
                    <li @if($base_request_path=='/') class="uk-active" @endif><a href="/">首页</a></li>
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/question')) class="uk-active" @endif><a href="/question">题目</a></li>
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/tags')) class="uk-active" @endif><a href="/tags">专项</a></li>
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/paper')) class="uk-active" @endif><a href="/paper">试卷</a></li>
                    @if(ConfigGet('moduleVipArticleEnable',false))
                        <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/vip_article')) class="uk-active" @endif><a href="/vip_article">付费内容</a></li>
                    @endif
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/news')) class="uk-active" @endif><a href="/news">资讯</a></li>
                </ul>
            </nav>
        </div>
    </header>

    @section('bodyContent')@show

    <footer>
        <div class="main-container">
            <div class="articles">
                @foreach($footerArticles as $footerArticle)
                    <a href="/article/{{$footerArticle['id']}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://beian.miit.gov.cn" target="_blank">{{\TechSoft\Laravel\Config\ConfigUtil::get('siteBeian','[网站备案信息]')}}</a>
                &copy;
                {{\TechSoft\Laravel\Config\ConfigUtil::get('siteDomain')}}
            </div>
        </div>
    </footer>
@show
@section('bodyScript')
    <script src="@assets('assets/main/basic.js')"></script>
@show
@section('bodyAppend')@show
</body>
</html>