@if(!empty($paperQuestionNumber))
    <div class="pb pb-question-view-number">
        <div>
            @if($paperQuestionNumberCount>1)
                第 {{$paperQuestionNumber}}-{{$paperQuestionNumber+$paperQuestionNumberCount-1}} 题
            @else
                第 {{$paperQuestionNumber}} 题
            @endif
            &nbsp;&nbsp;
            <i class="uk-icon-server"></i>{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,\App\Types\QuestionType::GROUP)}}
        </div>
    </div>
@endif
<div class="pb pb-question-view">
    @if(empty($paperQuestionNumber))
        <div class="head">
            <h2>
                {{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,\App\Types\QuestionType::GROUP)}}
            </h2>
        </div>
    @endif
    <div class="body" data-question="group" data-alias="{{$questionData['question']['alias']}}">

        <div class="question">
            <div class="question ub-html">
                {!! $questionData['question']['question'] !!}
            </div>
        </div>

        <div class="question-items">

            <?php $questionItemNumber = 1; ?>
            @foreach($questionData['items'] as $questionItemIndex=>$questionItem)
                @if($questionItem['question']['type']==\App\Types\QuestionType::SINGLE_CHOICE)
                    @include('theme.default.pc.question.viewGroupSingleChoice')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::MULTI_CHOICES)
                    @include('theme.default.pc.question.viewGroupMultiChoices')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::TRUE_FALSE)
                    @include('theme.default.pc.question.viewGroupTrueFalse')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::FILL)
                    @include('theme.default.pc.question.viewGroupFill')
                    <?php $questionItemNumber+=count($questionItem['answers'])-1; ?>
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::TEXT)
                    @include('theme.default.pc.question.viewGroupText')
                @endif
                <?php $questionItemNumber++; ?>
            @endforeach

        </div>

        <div class="question question-analysis">
            <div class="answer-result"></div>
        </div>

    </div>
</div>

