@extends($_frameLayoutView)

@section('pageTitle',$pageTitle)
@section('pageKeywords',$pageKeywords)
@section('pageDescription',$pageDescription)

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li class="uk-active"><span>搜索付费内容 “{{$keywords}}”</span></li>
            </ul>
        </div>

        @include('theme.default.pc.widget.search')

        @include('theme.default.pc.search.tab')

        <div class="pb pb-paper-list">
            <div class="head">
                <h2>搜索结果</h2>
            </div>
            <div class="body">
                <div class="list">
                    @if(empty($records))
                        <div class="empty">
                            暂无记录
                        </div>
                    @endif
                    @foreach($records as $record)
                        <div class="item">
                            <a class="title" href="/vip_article/{{$record['id']}}">{{$record['title']}}</a>
                        </div>
                    @endforeach
                </div>
                <div class="page-container">
                    {!! $pageHtml !!}
                </div>
            </div>
        </div>

    </div>


@endsection