@extends($_frameLayoutView)

@section('pageTitleMain','付费内容')


@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li class="uk-active"><span>付费内容</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-4">
                <div class="pb pb-news-list">
                    <div class="head">
                        <h2>
                            @if($categoryId)
                                @foreach($categories as $category)
                                    @if($category['id']==$categoryId)
                                        {{$category['name']}}
                                    @endif
                                @endforeach
                            @else
                                全部
                            @endif
                        </h2>
                    </div>
                    <div class="body">
                        <div class="list">
                            @foreach($vipArticles as $vipArticle)
                                <div class="item">
                                    <a class="title" href="/vip_article/{{$vipArticle['id']}}">{{$vipArticle['title']}}</a>
                                    <div class="summary">
                                        {{\TechSoft\Laravel\Util\HtmlUtil::text($vipArticle['previewContent'],200)}}
                                    </div>
                                    <div class="tool">
                                        <a class="more" href="/vip_article/{{$vipArticle['id']}}">
                                            [阅读全文]
                                        </a>
                                        <div class="time">{{($vipArticle['updated_at'])}}</div>
                                    </div>
                                </div>
                            @endforeach
                            @if(empty($vipArticles))
                                <div class="empty">暂无记录</div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="page-container">
                    {!! $pageHtml !!}
                </div>

            </div>
            <div class="uk-width-1-4">

                <div class="pb">
                    <div class="body">
                        <div class="pb-search-home mini">
                            <input type="text" placeholder="搜索 付费内容" id="keyword" onkeypress="if(event.keyCode==13){window.location.href='/search/vip_article?keywords='+window.api.util.urlencode($('#keyword').val());}" />
                            <a href="javascript:;" onclick="window.location.href='/search/vip_article?keywords='+window.api.util.urlencode($('#keyword').val());"><span class="uk-icon-search"></span> 搜索</a>
                        </div>
                    </div>
                </div>

                <div class="pb pb-news-category">
                    <div class="body">
                        <a href="/vip_article" @if(!$categoryId) class="active" @endif >全部</a>
                        @foreach($categories as $category)
                            <a href="/vip_article?category_id={{$category['id']}}"  @if($category['id']==$categoryId) class="active" @endif >{{$category['name']}}</a>
                        @endforeach
                    </div>
                </div>

            </div>
        </div>

    </div>

@endsection





