@extends($_frameLayoutView)

@section('pageTitleMain',htmlspecialchars($vipArticle['title']))

@section('bodyScript')
    <script src="@assets('assets/main/pay.js')"></script>
    <script>
        $(function () {
            new window.api.payPage({
                payTypeSelector: '.pay-list > a',
                paySubmitSelector: '[data-pay-submit]',
                payTypeActiveClass: 'cur',
                dialog: window.api.dialog,
                device: 'pc',
                server: '?'
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/vip_article">付费内容</a></li>
                <li class="uk-active"><span>{{$vipArticle['title']}}</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-4">

                <div class="pb pb-news-view">
                    <div class="body">
                        @include('public.shareButtons')
                        <h1>{{$vipArticle['title']}}</h1>
                        <div class="attr">
                            时间：{{($vipArticle['created_at'])}}
                            分类：{{$vipArticle['_category']['name']}}
                        </div>
                        @if($vipArticleBought || (!$vipArticle['fee']>=0.01))
                            @if($vipArticle['fee']>=0.01)
                                <div class="uk-alert uk-alert-success ub-text-center">您已经购买此付费文章</div>
                            @endif
                            <div class="content ub-html">
                                {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($vipArticle['content'],'data-src',true) !!}
                            </div>
                        @else
                            <div class="content ub-html">
                                {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($vipArticle['previewContent'],'data-src',true) !!}
                            </div>
                            <div class="uk-alert uk-alert-warning ub-text-center">
                                <a href="javascript:;" data-uk-modal="{target:'#buyDialog'}">查看全文</a>
                            </div>
                        @endif
                    </div>
                </div>

            </div>
            <div class="uk-width-1-4">

                <div class="pb pb-news-latest">
                    <div class="head">
                        <h2>最新内容</h2>
                    </div>
                    <div class="body">
                        @foreach($vipArticleLatest as $record)
                            <a class="item" href="/vip_article/{{$record['id']}}">
                                <span class="time">{{\Carbon\Carbon::parse($record['created_at'])->format('m-d')}}</span> {{$record['title']}}
                            </a>
                        @endforeach
                    </div>
                </div>

            </div>
        </div>


        <div id="buyDialog" class="uk-modal">
            <div class="uk-modal-dialog">
                <a class="uk-modal-close uk-close"></a>
                <div class="uk-modal-header">
                    支付 ￥{{$vipArticle['fee']}} 购买
                </div>
                <div class="pb-member-vip">
                    @if( \TechSoft\Laravel\Pay\PayUtil::hasPay() )
                        <div class="pay-list">
                            @if(\TechSoft\Laravel\Pay\PayUtil::isAlipayEnable())
                                <a href="javascript:;"
                                   data-type="{{\TechSoft\Laravel\Pay\Types\PayType::ALIPAY}}">
                                    <img src="@assets('assets/lib/img/pay/alipay.jpg')"/>
                                    支付宝
                                </a>
                            @endif
                            @if(\TechSoft\Laravel\Pay\PayUtil::isWechatEnable())
                                <a href="javascript:;"
                                   data-type="{{\TechSoft\Laravel\Pay\Types\PayType::WECHAT}}">
                                    <img src="@assets('assets/lib/img/pay/wechat.jpg')"/>
                                    微信支付
                                </a>
                            @endif
                        </div>
                    @endif
                    <div class="pay-submit">
                        <a href="javascript:;" class="btn btn-primary" data-pay-submit>确定支付</a>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection





