@extends($_frameLayoutView)

@section('bodyScript')
    <script src="@assets('assets/m/home.js')"></script>
@endsection

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('pageTitleMain',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('headerLeft')@endsection

@section('bodyContent')

    <div class="pb-question-list">
        <div class="body">
            @if(empty($latestQuestions))
                <div class="empty">
                    暂无记录
                </div>
            @endif
            @foreach($latestQuestions as $question)
                <div class="item">
                    <div class="title">
                        <a href="/question/view/{{$question['alias']}}">
                            [{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,$question['type'])}}]
                            {{\TechSoft\Laravel\Util\HtmlUtil::text($question['question'],100)}}
                        </a>
                    </div>
                    <div class="tags">
                        <div class="right">
                            <span>正确率 {{$question['testCount']>0?sprintf('%d%%',$question['passCount']*100/$question['testCount']):'-'}}</span>
                            |
                            <span>评论 {{$question['commentCount'] or 0}}</span>
                            |
                            <span>点击 {{$question['clickCount']}}</span>
                        </div>
                        @foreach($question['tag'] as $tag)
                            <a href="/question/list/{{$tag['id']}}" target="_blank">{{$tag['title']}}</a>
                        @endforeach
                    </div>
                </div>
            @endforeach
            <div class="page-container">
                <a style="color:#999;text-align:center;display:block;padding:10px;" href="/question/list">查看更多</a>
            </div>
        </div>
    </div>

@endsection