@extends('theme.theme_a.pc.frame')

@section('pageTitle',\TechSoft\Laravel\Config\ConfigUtil::get('siteName'))

@section('bodyScript')
    <script src="@assets('assets/main/home.js')"></script>
@endsection

@section('bodyContent')

    <div class="ub-search-block">
        <div class="title">
            开始搜索
        </div>
        <div class="sub-title">
            海量题库只为你提供专业搜索
        </div>
        <div class="form">
            <form action="/search" method="get">
                <div class="box">
                    <input type="text" name="keywords" class="form form-lg" placeholder="搜索 题目 / 试卷 / 付费内容" />
                    <button type="submit" class="btn btn-lg"><i class="iconfont icon-search1"></i> 搜索</button>
                </div>
            </form>
        </div>
    </div>

    <div class="main-container">

        <div class="pb pb-question-list">
            <div class="head">
                <h2>最新题目</h2>
            </div>
            <div class="body">
                <div class="empty" style="display:none;">
                    暂无记录
                </div>
                @foreach($latestQuestions as $question)
                    <div class="item">
                        <div class="title">
                            <a href="/question/view/{{$question['alias']}}">
                                [{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,$question['type'])}}]
                                {{\TechSoft\Laravel\Util\HtmlUtil::text($question['question'],100)}}
                            </a>
                        </div>
                        <div class="tags">
                            <div class="right">
                                @if($question['source'])
                                    <span>来源 {{$question['source']}}</span>
                                    |
                                @endif
                                <span>正确率 {{$question['testCount']>0?sprintf('%d%%',$question['passCount']*100/$question['testCount']):'-'}}</span>
                                |
                                <span>评论 {{$question['commentCount'] or 0}}</span>
                                |
                                <span>点击 {{$question['clickCount']}}</span>
                            </div>
                            @foreach($question['tag'] as $tag)
                                <a href="/question/list/{{$tag['id']}}" target="_blank">{{$tag['title']}}</a>
                            @endforeach
                        </div>
                    </div>
                @endforeach
                <a class="more" href="/question/list">
                    查看更多 <i class="uk-icon-angle-double-down"></i>
                </a>
            </div>
        </div>

        <div class="pb pb-partner">
            <div class="head">
                <h2>合作伙伴</h2>
            </div>
            <div class="body">
                <div class="uk-grid">
                    @foreach($partners as $partner)
                        <div class="uk-width-1-10">
                            <a class="item" href="{{$partner['link']}}" target="_blank" title="{{$partner['title']}}">
                                <div class="cover">
                                    <img data-src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($partner['logo'])}}">
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

    </div>


@endsection