<?php
 namespace TechSoft\Laravel\Mod; use Illuminate\Support\Facades\Artisan; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\FileUtil; use TechSoft\Laravel\Config\ConfigUtil; class ModUtil { public static function install($mod) { try { $exists = ConfigUtil::getArray('systemModList', []); if (in_array($mod, $exists)) { return Response::generate(-1, '应用已安装'); } $exitCode = Artisan::call("migrate", ['--path' => "public/mod/$mod/Migrate"]); if (0 !== $exitCode) { return Response::generate(-1, "ERROR:$exitCode"); } $exists = array_unique(array_merge($exists, [$mod])); ConfigUtil::setArray('systemModList', $exists); return Response::generate(0, 'ok'); } catch (\Exception $e) { return Response::generate(-1, $e->getMessage()); } } public static function uninstall($mod) { try { $exists = ConfigUtil::getArray('systemModList', []); if (!in_array($mod, $exists)) { return Response::generate(-1, '应用未安装'); } $exists = array_unique(array_filter($exists, function ($item) use ($mod) { return $item != $mod; })); ConfigUtil::setArray('systemModList', $exists); return Response::generate(0, 'ok'); } catch (\Exception $e) { return Response::generate(-1, $e->getMessage()); } } public static function locals() { $files = FileUtil::listFiles(public_path('mod')); $mods = []; foreach ($files as $file) { $mod = $file['filename']; if (file_exists($path = $file['pathname'] . '/Config/config.php')) { $mods[] = (include $path); } } return $mods; } public static function enables() { $mods = config('mod.system', []); try { $mods = array_merge($mods, ConfigUtil::getArray('systemModList')); } catch (\Exception $e) { } return $mods; } public static function adminMenus($all) { foreach (self::enables() as $mod) { if (file_exists($file = public_path("mod/$mod/Config/admin_menus.php"))) { $one = (include $file); $all = array_merge_recursive($all, $one); } } return $all; } }