<?php
 namespace TechSoft\Laravel\Shop\Jobs; use Illuminate\Support\Facades\Event; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Job\BaseJob; use TechSoft\Laravel\Shop\Events\ShopOrderExpireEvent; use TechSoft\Laravel\Shop\Helpers\ShopLockUtil; use TechSoft\Laravel\Shop\Types\OrderStatus; use Illuminate\Support\Facades\Log; class OrderCancelJob extends BaseJob { public $orderId; public $param; public static function create($orderId, $param = [], $delay = 0) { $job = new OrderCancelJob(); $job->orderId = $orderId; $job->param = $param; $job->onQueue('OrderCancelJob'); if ($delay > 0) { $job->delay($delay); } app('Illuminate\Contracts\Bus\Dispatcher')->dispatch($job); } public function handle() { Log::info('OrderCancelJob.' . sprintf('%05d', getmypid()) . '.Execute ->' . $this->orderId . ' -> ' . json_encode($this->param)); ModelUtil::transactionBegin(); if (!ShopLockUtil::checkoutLockBegin()) { self::create($this->orderId, 5); return; } $order = ModelUtil::getWithLock('order', ['id' => $this->orderId]); if (empty($order)) { ModelUtil::transactionCommit(); ShopLockUtil::checkoutLockEnd(); return; } if ($order['status'] != OrderStatus::CANCEL_QUEUE) { ModelUtil::transactionCommit(); ShopLockUtil::checkoutLockEnd(); return; } $orderGoods = ModelUtil::model('order_goods')->where(['orderId' => $this->orderId])->lockForUpdate()->get()->toArray(); ModelUtil::join($orderGoods, 'goodsSnapshotId', '_goodsSnapshot', 'goods_snapshot', 'id'); foreach ($orderGoods as $orderGood) { if ($orderGood['_goodsSnapshot']['specSpec']) { ModelUtil::change( 'goods_spec', ['goodsId' => $orderGood['goodsId'], 'spec' => $orderGood['_goodsSnapshot']['specSpec'],], 'stock', +$orderGood['amount'] ); Log::info('goods.' . $orderGood['goodsId'] . '.' . $orderGood['_goodsSnapshot']['specSpec'] . ' stock +' . $orderGood['amount']); } else { ModelUtil::change( 'goods', ['id' => $orderGood['goodsId']], 'stock', +$orderGood['amount'] ); Log::info('goods.' . $orderGood['goodsId'] . ' stock +' . $orderGood['amount']); } } if (!empty($this->param['expire'])) { ModelUtil::update('order', ['id' => $this->orderId], ['status' => OrderStatus::CANCEL_EXPIRED]); } else { ModelUtil::update('order', ['id' => $this->orderId], ['status' => OrderStatus::CANCEL]); } ModelUtil::transactionCommit(); ShopLockUtil::checkoutLockEnd(); Event::fire(new ShopOrderExpireEvent($this->orderId)); } }