<?php
 namespace App\Http\Controllers\Admin; use App\Types\QuestionType; use App\Util\ESUtil; use App\Util\QuestionUtil; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Type\TypeUtil; use TechOnline\Laravel\Util\TagUtil; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldSelect; use TechSoft\Laravel\Admin\Cms\Field\FieldTag; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminPowerUtil; use TechSoft\Laravel\Data\DataUtil; use TechSoft\Laravel\Util\HtmlUtil; class QuestionController extends AdminCheckController { private $cmsConfigData = [ 'model' => 'question', 'pageTitle' => '题库', 'group' => 'data', 'canAdd' => true, 'canEdit' => true, 'canDelete' => true, 'canView' => true, 'addInNewWindow' => true, 'editInNewWindow' => true, 'listFilter' => [ 'where' => [ 'parentId' => 0 ] ], 'fields' => [ 'type' => ['type' => FieldSelect::class, 'title' => '类型', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => QuestionType::class, 'search' => true,], 'question' => ['type' => FieldText::class, 'title' => '题目', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'search' => true,], 'tag' => ['type' => FieldTag::class, 'title' => '标签', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'mapModel' => 'question_tag',], 'clickCount' => ['type' => FieldText::class, 'title' => '点击量', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,], 'testCount' => ['type' => FieldText::class, 'title' => '测试量', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,], 'passCount' => ['type' => FieldText::class, 'title' => '通过量', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,], ] ]; private $cmsAction = null; public function dataPostDelete(&$data) { ModelUtil::delete('question_option', ['questionId' => $data['id']]); ModelUtil::delete('question_analysis', ['questionId' => $data['id']]); ModelUtil::delete('question_answer', ['questionId' => $data['id']]); ModelUtil::delete('paper_question', ['questionId' => $data['id']]); } public function dataProcessView(&$item, &$record) { switch ($this->cmsAction) { case 'list': $item['question'] = HtmlUtil::text($record['question'], 100); $item['question'] = '<a href="/question/view/' . $record['alias'] . '" target="_blank">' . $item['question'] . '</a>'; break; case 'view': $item['question'] = View::make('admin.question.viewItem', QuestionUtil::getQuestionData($record['id']))->render(); break; } } public function dataList(BasicCms $basicCms) { $this->cmsAction = 'list'; return $basicCms->executeList($this, $this->cmsConfigData); } private function addOrEdit($id) { if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return Response::send(-1, '演示账号禁止修改信息'); } $input = InputPackage::buildFromInputJson('data'); $question = []; $question['question'] = trim($input->getTrimString('question')); $question['source'] = trim($input->getTrimString('questionSource')); $question['type'] = $input->getType('questionType', QuestionType::class); $question['tag'] = TagUtil::array2String($input->getArray('questionTags')); $question['itemCount'] = 0; $question['questionText'] = HtmlUtil::text($question['question']); $questionAnalysis = []; $questionAnalysis ['analysis'] = trim($input->getTrimString('questionAnalysis')); $questionOptions = []; $questionAnswers = []; $questionItems = []; if (empty($question['question'])) { return Response::send(-1, '题目不能为空'); } if (empty($question['tag'])) { return Response::send(-1, '题目标签为空'); } switch ($question['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $optionMap = [ QuestionType::SINGLE_CHOICE => 'singleChoiceOption', QuestionType::MULTI_CHOICES => 'multiChoicesOption', QuestionType::TRUE_FALSE => 'trueFalseOption', ]; $options = $input->getArray($optionMap[$question['type']]); $questionOptions = []; foreach ($options as $option) { $op = trim($option['option']); if (empty($op)) { continue; } $questionOption = []; $questionOption['isAnswer'] = ($option['isAnswer'] ? true : false); $questionOption['option'] = $op; $questionOptions[] = $questionOption; } if (empty($questionOptions)) { return Response::send(-1, '题目选项为空'); } $answerExists = false; foreach ($questionOptions as $questionOption) { if ($questionOption['isAnswer']) { $answerExists = true; break; } } if (!$answerExists) { return Response::send(-1, '题目未设置答案'); } $question['itemCount'] = 1; break; case QuestionType::FILL: foreach ($input->getArray('fillAnswer', []) as $answer) { $questionAnswers[] = [ 'answer' => $answer['answer'], ]; } if (empty($questionAnswers)) { return Response::send(-1, '题目答案为空'); } $question['itemCount'] = count($questionAnswers); break; case QuestionType::TEXT: $answers = $input->getArray('textAnswer', []); if (empty($answers[0]['answer'])) { return Response::send(-1, '题目答案为空'); } $questionAnswers[] = [ 'answer' => $answers[0]['answer'], ]; $question['itemCount'] = 1; break; case QuestionType::GROUP: $itemCount = 0; foreach ($input->getArray('items', []) as $index => $questionItem) { $item = []; $item['question'] = $questionItem['question']; $item['type'] = $questionItem['type']; switch ($item['type']) { case QuestionType::SINGLE_CHOICE: $item['singleChoiceOption'] = $questionItem['singleChoiceOption']; $itemCount++; break; case QuestionType::MULTI_CHOICES: $item['multiChoicesOption'] = $questionItem['multiChoicesOption']; $itemCount++; break; case QuestionType::TRUE_FALSE: $item['trueFalseOption'] = $questionItem['trueFalseOption']; $itemCount++; break; case QuestionType::FILL: $item['fillAnswer'] = $questionItem['fillAnswer']; $itemCount += count($item['fillAnswer']); break; case QuestionType::TEXT: $item['textAnswer'] = $questionItem['textAnswer']; $itemCount++; break; } $questionItems [] = $item; } if (empty($questionItems)) { return Response::send(-1, '题目为空'); } $question['itemCount'] = $itemCount; break; default: return Response::send(-1, '题目类型未能识别'); } $debugData = [ 'id' => $id, 'question' => $question, 'questionAnalysis' => $questionAnalysis, 'questionOptions' => $questionOptions, 'questionAnswers' => $questionAnswers, 'questionItems' => $questionItems, ]; ModelUtil::transactionBegin(); if ($id) { ModelUtil::update('question', ['id' => $id], $question); $question['id'] = $id; } else { $question['parentId'] = 0; $question['clickCount'] = 0; $question['testCount'] = 0; $question['passCount'] = 0; $question['alias'] = strtolower(Str::random(16)); $question = ModelUtil::insert('question', $question); } if (ConfigGet('moduleESEnable', false)) { ESUtil::syncQuestions([$question]); } if ($id) { ModelUtil::update('question_analysis', ['questionId' => $question['id']], $questionAnalysis); } else { $questionAnalysis['questionId'] = $question['id']; ModelUtil::insert('question_analysis', $questionAnalysis); } if ($id) { ModelUtil::delete('question_option', ['questionId' => $question['id']]); } foreach ($questionOptions as $questionOption) { $questionOption['questionId'] = $question['id']; ModelUtil::insert('question_option', $questionOption); } if ($id) { ModelUtil::delete('question_answer', ['questionId' => $question['id']]); } foreach ($questionAnswers as $questionAnswer) { $questionAnswer['questionId'] = $question['id']; ModelUtil::insert('question_answer', $questionAnswer); } if ($id) { $ids = ModelUtil::values('question', 'id', ['parentId' => $id]); if (!empty($ids)) { foreach ($ids as $idsId) { ModelUtil::delete('question', ['id' => $idsId]); ModelUtil::delete('question_option', ['questionId' => $idsId]); ModelUtil::delete('question_answer', ['questionId' => $idsId]); ModelUtil::delete('question_analysis', ['questionId' => $idsId]); } } } foreach ($questionItems as $questionItem) { $questionItemAdd = ModelUtil::insert('question', [ 'alias' => strtolower(Str::random(16)), 'parentId' => $question['id'], 'question' => $questionItem['question'], 'type' => $questionItem['type'], ]); switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: foreach ($questionItem['singleChoiceOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::MULTI_CHOICES: foreach ($questionItem['multiChoicesOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::TRUE_FALSE: foreach ($questionItem['trueFalseOption'] as $option) { ModelUtil::insert('question_option', [ 'questionId' => $questionItemAdd['id'], 'option' => $option['option'], 'isAnswer' => ($option['isAnswer'] ? true : false), ]); } break; case QuestionType::FILL: foreach ($questionItem['fillAnswer'] as $answer) { ModelUtil::insert('question_answer', [ 'questionId' => $questionItemAdd['id'], 'answer' => $answer['answer'], ]); } break; case QuestionType::TEXT: foreach ($questionItem['textAnswer'] as $answer) { ModelUtil::insert('question_answer', [ 'questionId' => $questionItemAdd['id'], 'answer' => $answer['answer'], ]); } break; } } ModelUtil::transactionCommit(); if ($input->getTrimString('next') == 'true') { return Response::send(0, null, null, action('\App\Http\Controllers\Admin\QuestionController@dataAdd')); } else { return Response::send(0, null, null, action('\App\Http\Controllers\Admin\QuestionController@dataList')); } } $data = [ 'questionType' => QuestionType::SINGLE_CHOICE, 'questionSource' => '', 'question' => '', 'questionTags' => [], 'questionAnalysis' => '', 'singleChoiceOption' => [ ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ], 'multiChoicesOption' => [ ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ['isAnswer' => false, 'option' => ''], ], 'trueFalseOption' => [ ['isAnswer' => false, 'option' => '正确'], ['isAnswer' => false, 'option' => '错误'], ], 'fillAnswer' => [ ['answer' => ''], ], 'textAnswer' => [ ['answer' => ''], ], "items" => [ ], ]; if ($id) { $question = ModelUtil::get('question', ['id' => $id]); $data['questionType'] = $question['type']; $data['questionSource'] = $question['source']; $data['question'] = $question['question']; $data['questionTags'] = TagUtil::string2Array($question['tag']); foreach ($data['questionTags'] as &$questionTag) { $questionTag = intval($questionTag); } $questionAnalysis = ModelUtil::get('question_analysis', ['questionId' => $question['id']]); $data['questionAnalysis'] = $questionAnalysis['analysis']; switch ($question['type']) { case QuestionType::SINGLE_CHOICE: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['singleChoiceOption'] = $options; break; case QuestionType::MULTI_CHOICES: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['multiChoicesOption'] = $options; break; case QuestionType::TRUE_FALSE: $options = []; foreach (ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']) as $item) { $options[] = [ 'isAnswer' => $item['isAnswer'] ? true : false, 'option' => $item['option'], ]; } $data['trueFalseOption'] = $options; break; case QuestionType::FILL: $data["fillAnswer"] = ModelUtil::model('question_answer')->where(['questionId' => $question['id']])->orderBy('id', 'asc')->get()->toArray(); break; case QuestionType::TEXT: $questionAnswer = ModelUtil::get('question_answer', ['questionId' => $question['id']]); $data['textAnswer'] = [ ['answer' => $questionAnswer['answer']] ]; break; case QuestionType::GROUP: $data['items'] = []; $questionItems = ModelUtil::model('question')->where(['parentId' => $question['id']])->orderBy('id', 'asc')->get()->toArray(); foreach ($questionItems as $questionItem) { $item = []; $item['question'] = $questionItem['question']; $item['type'] = $questionItem['type']; switch ($item['type']) { case QuestionType::SINGLE_CHOICE: $item['singleChoiceOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['singleChoiceOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::MULTI_CHOICES: $item['multiChoicesOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['multiChoicesOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::TRUE_FALSE: $item['trueFalseOption'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); foreach ($item['trueFalseOption'] as &$option) { $option['isAnswer'] = ($option['isAnswer'] ? true : false); } break; case QuestionType::FILL: $item["fillAnswer"] = ModelUtil::model('question_answer')->where(['questionId' => $questionItem['id']])->orderBy('id', 'asc')->get()->toArray(); break; case QuestionType::TEXT: $questionAnswer = ModelUtil::get('question_answer', ['questionId' => $questionItem['id']]); $item['textAnswer'] = [ ['answer' => $questionAnswer['answer']] ]; break; } $data["items"][] = $item; } break; } } $groupTags = QuestionUtil::getTags(); return view('admin.question.edit', compact('id', 'groupTags', 'data')); } public function dataAdd() { return $this->addOrEdit(0); } public function dataEdit() { $input = InputPackage::buildFromInput(); $id = $input->getTrimString('_id'); return $this->addOrEdit($id); } public function dataDelete(BasicCms $basicCms) { return $basicCms->executeDelete($this, $this->cmsConfigData); } public function dataView(BasicCms $basicCms) { $this->cmsAction = 'view'; return $basicCms->executeView($this, $this->cmsConfigData); } public function select() { if (Request::isPost()) { $input = InputPackage::buildFromInput(); $page = intval($input->getInteger('page')); $pageSize = 20; $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['where'] ['parentId'] = 0; $input = InputPackage::buildFromInput(); if ($type = $input->getTrimString('type')) { $option['where'] ['type'] = $type; } if ($question = $input->getTrimString('question')) { $option['whereOperate'] [] = ['question', 'like', '%' . $question . '%']; } $tags = $input->getArray('tags', []); if (!empty($tags)) { foreach ($tags as $tag) { $option['whereOperate'] [] = ['tag', 'like', '%:' . $tag . ':%']; } } $list = []; $paginateData = ModelUtil::paginate('question', $page, $pageSize, $option); $records = $paginateData['records']; foreach ($records as &$record) { $item = []; $item['id'] = $record['id']; $question = HtmlUtil::extractTextAndImages($record['question']); $item['question'] = '[' . TypeUtil::name(QuestionType::class, $record['type']) . '] ' . $question['text']; $item['url'] = '/question/view/' . $record['alias']; $list[] = $item; } $data = []; $data['list'] = $list; $data['total'] = $paginateData['total']; $data['pageSize'] = $pageSize; $data['page'] = $page; return Response::generate(0, null, $data); } $groupTags = QuestionUtil::getTags(); return view('admin.question.select', compact('groupTags')); } public function preview() { $ids = InputPackage::buildFromInput()->getArray('ids', []); if (empty($ids)) { return Response::send(0, null, ['list' => []]); } $list = []; foreach ($ids as $id) { $item = []; $questionData = QuestionUtil::getQuestionData($id); if (empty($questionData)) { continue; } $item['id'] = $questionData['question']['id']; $item['html'] = View::make('admin.question.viewItem', $questionData)->render(); $item['itemCount'] = $questionData['question']['itemCount']; $item['questionData'] = $questionData; $score = []; for ($i = 0; $i < $item['itemCount']; $i++) { $score[] = 5; } $item['score'] = $score; $list[] = $item; } return Response::send(0, null, ['list' => $list]); } private function importCheckItem($questionItem, &$questions, $choiceIndex) { if (empty($questionItem['_answer'])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:7'); } switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: if (!isset($choiceIndex[strtoupper($questionItem['_answer'][0])])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:5'); } $index = $choiceIndex[strtoupper($questionItem['_answer'][0])]; if (!isset($questionItem['singleChoiceOption'][$index])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:4'); } $questionItem['singleChoiceOption'][$index]['isAnswer'] = true; break; case QuestionType::MULTI_CHOICES: if (empty($questionItem['_answer'][0])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:6'); } foreach (explode(',', str_replace('，', ',', $questionItem['_answer'][0])) as $answer) { $answer = trim($answer); if (!isset($choiceIndex[strtoupper($answer)])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:3'); } $index = $choiceIndex[strtoupper($answer)]; if (!isset($questionItem['multiChoicesOption'][$index])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:2'); } $questionItem['multiChoicesOption'][$index]['isAnswer'] = true; } break; case QuestionType::TRUE_FALSE: if (empty($questionItem['_answer'][0])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:6'); } $questionItem['trueFalseOption'] = [ ['isAnswer' => $questionItem['_answer'][0] == '正确', 'option' => '正确'], ['isAnswer' => $questionItem['_answer'][0] == '错误', 'option' => '错误'], ]; break; case QuestionType::FILL: if (empty($questionItem['_answer'])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:7'); } foreach ($questionItem['_answer'] as $item) { $questionItem['fillAnswer'][] = ['answer' => $item,]; } break; case QuestionType::TEXT: if (empty($questionItem['_answer'])) { return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:8'); } foreach ($questionItem['_answer'] as $item) { $questionItem['textAnswer'][] = ['answer' => $item,]; } break; default: return Response::generate(-1, '解析第' . (count($questions) + 1) . '题 出错:1'); } $questions[] = $questionItem; return Response::generate(0, 'ok'); } public function import() { if (Request::isPost()) { if (AdminPowerUtil::isDemo()) { return Response::send(-1, '演示账号禁止该操作'); } $file = InputPackage::buildFromInput()->getFilePath('file'); if (empty($file)) { return Response::send(-1, '请上传文件'); } if (!DataUtil::isTempDataPath($file)) { return Response::send(-1, '文件错误'); } $ret = DataUtil::prepareTempDataForLocalUse($file); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $file = $ret['data']['path']; $lines = explode("\n", file_get_contents($file)); $questions = []; $questionItemEmpty = [ 'question' => '', 'type' => null, 'singleChoiceOption' => [ ], 'multiChoicesOption' => [ ], 'trueFalseOption' => [ ], 'fillAnswer' => [ ], 'textAnswer' => [ ], '_answer' => [], ]; $questionItem = $questionItemEmpty; $step = null; $questionTypeMap = [ '[单选题]' => QuestionType::SINGLE_CHOICE, '[多选题]' => QuestionType::MULTI_CHOICES, '[判断题]' => QuestionType::TRUE_FALSE, '[填空题]' => QuestionType::FILL, '[问答题]' => QuestionType::TEXT, ]; $questionControl = [ '[选项]' => 'choice', '[答案]' => 'answer', ]; $choiceIndex = []; for ($i = 0; $i < 26; $i++) { $choiceIndex[chr(ord('A') + $i)] = $i; } foreach ($lines as $lineIndex => $line) { $line = trim($line); if (empty($line)) { continue; } if (isset($questionTypeMap[$line])) { if (!empty($step)) { $this->importCheckItem($questionItem, $questions, $choiceIndex); } $questionItem = $questionItemEmpty; $questionItem['type'] = $questionTypeMap[$line]; $step = 'question'; } else if (isset($questionControl[$line])) { $step = $questionControl[$line]; } else { switch ($step) { case 'question': switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: $questionItem['question'] = $line; break; case QuestionType::TRUE_FALSE: case QuestionType::FILL: case QuestionType::TEXT: $questionItem['question'] = $line; break; default: return Response::send(-1, '第' . ($lineIndex + 1) . '行数据错误:1'); } break; case 'choice': switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: $questionItem['singleChoiceOption'][] = ['isAnswer' => false, 'option' => preg_replace('/^[A-Z]{1}\\.\\s*/', '', $line)]; break; case QuestionType::MULTI_CHOICES: $questionItem['multiChoicesOption'][] = ['isAnswer' => false, 'option' => preg_replace('/^[A-Z]{1}\\.\\s*/', '', $line)]; break; default: return Response::send(-1, '第' . ($lineIndex + 1) . '行数据错误:2'); } break; case 'answer': switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: case QuestionType::FILL: case QuestionType::TEXT: $questionItem['_answer'][] = $line; break; default: return Response::send(-1, '第' . ($lineIndex + 1) . '行数据错误:3'); } break; } } } if (!empty($step)) { $this->importCheckItem($questionItem, $questions, $choiceIndex); } if (empty($questions)) { return Response::send(-1, '没有解析到题目'); } ModelUtil::transactionBegin(); foreach ($questions as $questionItem) { $question = []; $question['question'] = $questionItem['question']; $question['source'] = ''; $question['type'] = $questionItem['type']; $question['tag'] = null; $question['itemCount'] = 0; $question['parentId'] = 0; $question['clickCount'] = 0; $question['testCount'] = 0; $question['passCount'] = 0; $question['alias'] = strtolower(Str::random(16)); $question = ModelUtil::insert('question', $question); switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: foreach ($questionItem['singleChoiceOption'] as $item) { ModelUtil::insert('question_option', [ 'questionId' => $question['id'], 'isAnswer' => $item['isAnswer'], 'option' => $item['option'], ]); } break; case QuestionType::MULTI_CHOICES: foreach ($questionItem['multiChoicesOption'] as $item) { ModelUtil::insert('question_option', [ 'questionId' => $question['id'], 'isAnswer' => $item['isAnswer'], 'option' => $item['option'], ]); } break; case QuestionType::TRUE_FALSE: foreach ($questionItem['trueFalseOption'] as $item) { ModelUtil::insert('question_option', [ 'questionId' => $question['id'], 'isAnswer' => $item['isAnswer'], 'option' => $item['option'], ]); } break; } switch ($questionItem['type']) { case QuestionType::FILL: foreach ($questionItem['fillAnswer'] as $item) { ModelUtil::insert('question_answer', [ 'questionId' => $question['id'], 'answer' => $item['answer'], ]); } break; case QuestionType::TEXT: foreach ($questionItem['textAnswer'] as $item) { ModelUtil::insert('question_answer', [ 'questionId' => $question['id'], 'answer' => $item['answer'], ]); } break; } } ModelUtil::transactionCommit(); return Response::send(0, '导入成功', null, action('\App\Http\Controllers\Admin\QuestionController@dataList')); } return view('admin.question.import'); } public function importTemplate() { $txt = []; $txt[] = "
[单选题]
题目描述
[选项]
A. 选项1
B. 选项2
C. 选项3
D. 选项4
[答案]
A
"; $txt[] = "
[多选题]
题目描述
[选项]
A. 选项1
B. 选项2
C. 选项3
D. 选项4
[答案]
B,C
"; $txt[] = "
[判断题]
题目描述
[答案]
正确/错误
"; $txt[] = "
[填空题]
题目描述（ ）描述（ ）
[答案]
空1
空2
"; $txt[] = "
[问答题]
题目描述
[答案]
题目答案
"; return Response::download( 'template.txt', str_replace("\n", "\r\n", join("\n", $txt)), ['Content-Type' => 'text/plain'] ); } }