<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Oauth\OauthType; class MemberProfileController extends BaseController implements MemberLoginCheck { public function index() { if ($this->isMobile()) { $isWechatAuth = false; if (ConfigUtil::get('oauthWechatEnable', false)) { $isWechatAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WECHAT); } $isQQAuth = false; if (ConfigUtil::get('oauthQQEnable', false)) { $isQQAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::QQ); } $isWeiboAuth = false; if (ConfigUtil::get('oauthWeiboEnable', false)) { $isWeiboAuth = MemberUtil::getOauthOpenId($this->memberUserId(), OauthType::WEIBO); } return $this->_view('memberProfile.index', [ 'isQQAuth' => $isQQAuth, 'isWeiboAuth' => $isWeiboAuth, 'isWechatAuth' => $isWechatAuth, ]); } return Response::send(0, null, null, '/member/profile_basic'); } public function basic() { if (Request::isPost()) { $data = []; $data['gender'] = intval(Input::get('gender')); $data['realname'] = trim(Input::get('realname')); $data['signature'] = trim(Input::get('signature')); $memberUser = $this->memberUser(); if (empty($memberUser['username'])) { $username = trim(Input::get('username')); if ($username) { $existsMemberUser = MemberUtil::getByUsername($username); if (!empty($existsMemberUser)) { return Response::send(-1, '用户名已被占用'); } $data['username'] = $username; } } MemberUtil::update($this->memberUserId(), $data); return Response::send(0, '保存成功'); } return $this->_view('memberProfile.basic'); } }