<?php
 namespace App\Http\Controllers\Main; use App\Constant\PayConstant; use App\Http\Controllers\BaseController; use App\Types\NoteTipStatus; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\MemberVip\MemberVipUtil; use TechSoft\Laravel\Oauth\OauthType; use TechSoft\Laravel\Pay\PayUtil; use TechSoft\Laravel\Pay\Services\PayOrderUtil; use TechSoft\Laravel\Pay\Types\PayType; use TechSoft\Laravel\Shop\Types\OrderStatus; class MemberVipController extends BaseController implements MemberLoginCheck { public function index() { if (Request::isPost()) { $input = InputPackage::buildFromInput(); $payType = $input->getType('payType', PayType::class, null); if (empty($payType)) { return Response::send(-1, '支付方式错误'); } if (!PayUtil::isPayEnable($payType)) { return Response::send(-1, '支付方式未开启'); } $vipId = $input->getInteger('vipId'); if (empty($vipId)) { return Response::send(-1, '请选择会员类型'); } $memberVip = MemberVipUtil::get($vipId); if (empty($memberVip)) { return Response::send(-1, '请选择会员类型'); } $priceInfoRet = $this->calc($vipId)->getData(true); if ($priceInfoRet['code']) { return Response::send(-1, $priceInfoRet['msg']); } $money = $priceInfoRet['data']['price']; if ($money < 0.01) { return Response::send(-1, '支付金额为空0.01'); } $memberVipOrder = ModelUtil::insert('member_vip_order', [ 'status' => OrderStatus::WAIT_PAY, 'memberUserId' => $this->memberUserId(), 'vipId' => $memberVip['id'], 'payFee' => $money, 'expire' => $priceInfoRet['data']['expire'], 'type' => $priceInfoRet['data']['type'], ]); switch ($payType) { case PayType::ALIPAY: $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '开通会员-' . $memberVipOrder['id'], '开通会员-' . $memberVipOrder['id'], '/member/vip', ['alipay_wap' => $this->isMobile() ? true : false] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['payRedirect'] = $ret['data']['link']; $data['successRedirect'] = '/member/vip'; return Response::send(0, null, $data); case PayType::WECHAT_MOBILE: $openId = Session::get('oauthViewOpenId_' . OauthType::WECHAT_MOBILE); if (empty($openId)) { Session::put('autoClickPayType', PayType::WECHAT_MOBILE); return Response::send( -1, null, null, '/oauth_login_' . OauthType::WECHAT_MOBILE . '?view=true&redirect=' . urlencode(View::shared('base_request_path')) ); } $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '用户打赏-' . $memberVipOrder['id'], '用户打赏-' . $memberVipOrder['id'], '/member/vip', ['openId' => $openId] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['json'] = $ret['data']['json']; $data['successRedirect'] = $ret['data']['successRedirect']; return Response::send(0, null, $data); case PayType::WECHAT: $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '用户打赏-' . $memberVipOrder['id'], '用户打赏-' . $memberVipOrder['id'], '/member/vip', [] ); if ($ret['code']) { return Response::send(-1, $ret['msg']); } $data['codeUrl'] = $ret['data']['codeUrl']; $data['successRedirect'] = $ret['data']['successRedirect']; $data['watchUrl'] = '/member/vip_watch/' . $memberVipOrder['id']; return Response::send(0, null, $data); default: return Response::send(-1, '支付方式错误'); } } $memberVips = MemberVipUtil::all(); return $this->_view('memberVip.index', [ 'memberVips' => $memberVips, ]); } public function calc($vipId = 0) { $input = InputPackage::buildFromInput(); $memberVip = $this->memberVip(); if (!$vipId) { $vipId = $input->getInteger('vipId'); } if (empty($vipId)) { return Response::json(-1, '请选择会员'); } $ret = MemberVipUtil::calcPrice($memberVip ? $memberVip['id'] : 0, $this->memberUser('vipExpire'), $vipId); if ($ret['code']) { return Response::json(-1, $ret['msg']); } return Response::json(0, 'ok', $ret['data']); } public function watch($id) { $order = ModelUtil::get('member_vip_order', ['id' => $id, 'memberUserId' => $this->memberUserId()]); switch ($order['status']) { case OrderStatus::WAIT_PAY: return Response::send(0, null, ['status' => 'new']); case OrderStatus::COMPLETED: return Response::send(0, null, ['status' => 'payed']); case OrderStatus::CANCEL_EXPIRED: return Response::send(0, null, ['status' => 'expired']); default: return Response::send(-1, 'order status error'); } } }