<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Util\PaperUtil; use App\Util\QuestionUtil; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Ad\AdUtil; class PaperController extends BaseController { public function index() { $page = intval(Input::get('page', 1)); if ($page < 1) { $page = 1; } $pageSize = 10; $option = []; $option['where'] = []; $option['order'] = ['id', 'desc']; $option['where']['isPublic'] = true; $categoryId = Input::get('category_id'); if ($categoryId) { $option['where']['categoryId'] = $categoryId; } $paginateData = ModelUtil::paginate('paper', $page, $pageSize, $option); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $papers = $paginateData['records']; $paperCategories = PaperUtil::listCategories(); ModelUtil::join($papers, 'categoryId', '_category', 'paper_category', 'id'); return $this->_view('paper.index', [ 'pageHtml' => $pageHtml, 'papers' => $papers, 'paperCategories' => $paperCategories, 'categoryId' => $categoryId, 'ads' => AdUtil::listByPositionWithCache('pcPaperListRight') ]); } public function view($alias) { $paper = PaperUtil::getPaperByAlias($alias); if (empty($paper)) { return Response::send(-1, '试卷不存在'); } if (!$paper['isPublic']) { return Response::send(-1, '试卷未公开'); } $paperQuestions = PaperUtil::listQuestions($paper['id']); foreach ($paperQuestions as &$paperQuestion) { $paperQuestion['_questionData'] = QuestionUtil::getQuestionData($paperQuestion['questionId']); } return $this->_view('paper.view', compact( 'paper', 'paperQuestions' )); } }