<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Types\MemberFavoriteCategory; use App\Types\QuestionType; use App\Util\MemberVipQuotaUtil; use App\Util\QuestionUtil; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\View; use Illuminate\Support\Str; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Util\TagUtil; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Ad\AdUtil; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\MemberFavorite\MemberFavoriteUtil; use TechSoft\Laravel\MemberVip\MemberVipUtil; use TechSoft\Laravel\Util\HtmlUtil; class QuestionController extends BaseController { public function index() { return Response::send(0, null, null, '/question/list'); } public function lists($tags = '') { $input = InputPackage::buildFromInput(); $urlParam = $tags; $questionType = null; $keyword = null; $filterTags = []; foreach (explode('_', $tags) as $tagId) { if (Str::startsWith($tagId, 't')) { $questionType = intval(substr($tagId, 1)); continue; } if (Str::startsWith($tagId, 'k')) { $keyword = trim(substr($tagId, 1)); continue; } $tagId = intval($tagId); if (empty($tagId)) { continue; } $filterTags[] = $tagId; } $tags = $filterTags; if (empty($tags)) { $selectedTags = []; $selectedTagsIds = []; } else { $selectedTags = QuestionUtil::listTagsByIds($tags); $selectedTagsIds = []; foreach ($selectedTags as $selectedTag) { $selectedTagsIds[] = $selectedTag['id']; } } $pageSize = 10; $maxPage = ConfigUtil::getInteger('tikuQuestionMaxPage', 20); $page = min($input->getInteger('page', 1), $maxPage); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; $option['where']['parentId'] = 0; if ($questionType) { $option['where']['type'] = $questionType; } foreach ($selectedTagsIds as $selectedTagsId) { $option['whereOperate'][] = ['tag', 'like', '%:' . $selectedTagsId . ':%']; } if ($keyword) { $option['whereOperate'][] = ['question', 'like', '%' . $keyword . '%']; } $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $questions = $paginateData['records']; $paginateData['total'] = min($paginateData['total'], $maxPage * $pageSize); $pageHtml = PageHtmlUtil::render($paginateData['total'], $pageSize, $page, '?' . Request::mergeQueries(['page' => ['{page}']])); $pageTitle = []; if ($keyword) { $pageTitle[] = '搜索"' . htmlspecialchars($keyword) . '"'; } if (!empty($selectedTags)) { foreach ($selectedTags as $tag) { $pageTitle[] = $tag['title'] . '题库'; } } $pageTitle[] = ConfigUtil::get('siteName'); $pageKeywords = join(' ', $pageTitle); $pageTitle[] = '第' . $page . '页'; $pageTitle = join(' ', $pageTitle); $pageDescription = $pageTitle; $tags = QuestionUtil::getTags(); return $this->_view('question.list', compact( 'tags', 'selectedTags', 'selectedTagsIds', 'questionType', 'questions', 'pageHtml', 'keyword', 'pageTitle', 'pageKeywords', 'pageDescription', 'urlParam' )); } public function commentPost($alias) { if (!$this->memberUserId()) { return Response::send(-1, '没有登录'); } $content = trim(Input::get('content')); $content = HtmlUtil::filter($content); if (empty($content)) { return Response::send(-1, '评论内容不能为空'); } $question = QuestionUtil::getQuestion($alias); if (empty($question)) { return Response::send(-1, 'question empty'); } QuestionUtil::commentPost($this->memberUserId(), $question['id'], $content); QuestionUtil::updateQuestionCommentCount($question['id']); return Response::send(0, '评论成功', null, '[reload]'); } public function view($alias) { $questionData = QuestionUtil::getQuestionData(null, $alias); if (empty($questionData)) { return Response::send(-1, '题目为空'); } $questionData['question']['tag'] = TagUtil::string2Array($questionData['question']['tag']); $questionData['question']['tag'] = TagUtil::mapInfo($questionData['question']['tag'], QuestionUtil::getTagMap()); QuestionUtil::questionClick($questionData['question']['id']); $comments = QuestionUtil::listCommentByQuestionId($questionData['question']['id']); ModelUtil::join($comments, 'memberUserId', '_memberUser', 'member_user', 'id'); $previousQuestion = null; $nextQuestion = null; $param = trim(Input::get('param')); $questionType = null; $keyword = null; $filterTags = []; foreach (explode('_', $param) as $tagId) { if (Str::startsWith($tagId, 't')) { $questionType = intval(substr($tagId, 1)); continue; } if (Str::startsWith($tagId, 'k')) { $keyword = trim(substr($tagId, 1)); continue; } $tagId = intval($tagId); if (empty($tagId)) { continue; } $filterTags[] = $tagId; } $tags = $filterTags; if (empty($tags)) { $selectedTags = []; $selectedTagsIds = []; } else { $selectedTags = QuestionUtil::listTagsByIds($tags); $selectedTagsIds = []; foreach ($selectedTags as $selectedTag) { $selectedTagsIds[] = $selectedTag['id']; } } $pageSize = 1; $page = Input::get('page', 1); $option = []; $option['order'] = ['id', 'desc']; $option['where'] = []; $option['whereOperate'] = []; if ($questionType) { $option['where']['type'] = $questionType; } $option['whereOperate'][] = ['id', '>', $questionData['question']['id']]; foreach ($selectedTagsIds as $selectedTagsId) { $option['whereOperate'][] = ['tag', 'like', '%:' . $selectedTagsId . ':%']; } if ($keyword) { $option['whereOperate'][] = ['question', 'like', '%' . $keyword . '%']; } $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $questions = $paginateData['records']; if (!empty($questions)) { $previousQuestion = $questions[0]; } $option['whereOperate'][0] = ['id', '<', $questionData['question']['id']]; $paginateData = QuestionUtil::paginateQuestion($page, $pageSize, $option); $questions = $paginateData['records']; if (!empty($questions)) { $nextQuestion = $questions[0]; } return $this->_view('question.view', [ 'questionData' => $questionData, 'previousQuestion' => $previousQuestion, 'nextQuestion' => $nextQuestion, 'param' => $param, 'comments' => $comments, 'ads' => AdUtil::listByPositionWithCache('pcQuestionViewRight'), 'hasFavorite' => MemberFavoriteUtil::exists($this->memberUserId(), MemberFavoriteCategory::QUESTION, $questionData['question']['id']) ] ); } public function commentDelete($id) { $comment = ModelUtil::get('question_comment', [ 'id' => $id ]); if (empty($comment)) { return Response::send(-1, '评论不存在'); } if ($comment['memberUserId'] != $this->memberUserId()) { return Response::send(-1, '没有权限'); } ModelUtil::delete('question_comment', ['id' => $comment['id']]); QuestionUtil::updateQuestionCommentCount($comment['questionId']); return Response::send(0, null, null, '[reload]'); } public function answer($alias) { if (!$this->memberUserId()) { return Response::send(-1, '登录后才能查看答案', null, '/login?redirect=' . urlencode(Request::headerGet('Referer'))); } $questionData = QuestionUtil::getQuestionData(null, $alias); if (empty($questionData)) { return Response::send(-1, '题目不存在'); } if (MemberVipUtil::isEnable()) { if ($questionData['question']['type'] != QuestionType::GROUP) { $memberVip = $this->memberVip(); if (empty($memberVip)) { return Response::send(-1, '您的会员不存在，点击立即开通', null, '/member/vip'); } if (MemberVipQuotaUtil::questionViewCountToday($this->memberUserId()) >= $memberVip['quotaQuestionViewDaily']) { return Response::send(-1, '您每天最多只能看' . $memberVip['quotaQuestionViewDaily'] . '个题目，立即升级会员', null, '/member/vip'); } MemberVipQuotaUtil::questionViewPut($this->memberUserId(), $questionData['question']['id']); } else { foreach ($questionData['items'] as $item) { if (MemberVipQuotaUtil::questionViewed($this->memberUserId(), $item['question']['id'])) { return Response::send(-1, '当前题目组的所有问题未查看完成，不能查看题目组解析'); } } } } $answer = InputPackage::buildFromInput()->get('answer'); $answerInfo = QuestionUtil::parseAnswerInfo($questionData, $answer); if ($answerInfo['judge']) { QuestionUtil::increaseQuestionTestCount($questionData['question']['id']); if ($answerInfo['correct']) { QuestionUtil::increaseQuestionPassCount($questionData['question']['id']); } } return Response::send(0, 'ok', [ 'html' => View::make('theme.default.pc.question.answer', [ 'answer' => $answer, 'questionData' => $questionData, 'answerInfo' => $answerInfo, ])->render(), ]); } }