<?php
 namespace App\Util; use App\Types\QuestionType; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Facades\DB; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Util\TagUtil; use TechSoft\Laravel\Util\HtmlUtil; class QuestionUtil { const QUESTION_CACHE_PREFIX = 'question:'; public static function getQuestion($alias) { $question = ModelUtil::get('question', ['alias' => $alias]); return $question; } public static function getQuestionData($questionId, $questionAlias = null) { $data = []; if (null === $questionAlias) { $question = ModelUtil::get('question', ['id' => $questionId]); } else { $question = ModelUtil::get('question', ['alias' => $questionAlias]); } if (empty($question)) { return null; } $data['question'] = $question; $data['analysis'] = ModelUtil::get('question_analysis', ['questionId' => $question['id']]); switch ($question['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $data['options'] = ModelUtil::all('question_option', ['questionId' => $question['id']], ['*'], ['id', 'asc']); case QuestionType::FILL: $data['answers'] = ModelUtil::all('question_answer', ['questionId' => $question['id']], ['*'], ['id', 'asc']); break; case QuestionType::TEXT: $data['answer'] = ModelUtil::get('question_answer', ['questionId' => $question['id']]); break; case QuestionType::GROUP: $questionItems = ModelUtil::all('question', ['parentId' => $question['id']], ['*'], ['id', 'asc']); $data['items'] = []; $itemNumber = 1; foreach ($questionItems as $questionItem) { $item = []; $item['itemNumber'] = $itemNumber; $item['itemCount'] = 1; $item['question'] = $questionItem; switch ($questionItem['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::MULTI_CHOICES: case QuestionType::TRUE_FALSE: $item['options'] = ModelUtil::all('question_option', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); $itemNumber++; break; case QuestionType::FILL: $item['answers'] = ModelUtil::all('question_answer', ['questionId' => $questionItem['id']], ['*'], ['id', 'asc']); $item['itemCount'] = count($item['answers']); $itemNumber += $item['itemCount']; break; case QuestionType::TEXT: $item['answer'] = ModelUtil::get('question_answer', ['questionId' => $questionItem['id']]); $itemNumber++; break; } $data['items'][] = $item; } break; } return $data; } public static function questionClick($questionId) { ModelUtil::update('question', ['id' => $questionId], ['clickCount' => DB::raw('clickCount+1')]); } public static function listQuestionTagWithCache($cacheMinutes = 30) { return Cache::remember(self::QUESTION_CACHE_PREFIX . ':questionTag', $cacheMinutes, function () { return ModelUtil::all('question_tag'); }); } public static function listQuestionTagGroupWithCache($cacheMinutes = 30) { return Cache::remember(self::QUESTION_CACHE_PREFIX . ':questionTagGroup', $cacheMinutes, function () { return ModelUtil::all('question_tag_group', [], ['*'], ['sort', 'asc']); }); } public static function getTags() { $questionTags = self::listQuestionTagWithCache(); $questionTagGroups = self::listQuestionTagGroupWithCache(); $groupTags = []; foreach ($questionTagGroups as &$questionTagGroup) { $group = []; $group['groupId'] = $questionTagGroup['id']; $group['groupTitle'] = $questionTagGroup['title']; $tags = []; foreach ($questionTags as &$questionTag) { if ($questionTag['groupId'] == $questionTagGroup['id']) { $tags[] = [ 'id' => $questionTag['id'], 'title' => $questionTag['title'], ]; } } $group['groupTags'] = $tags; $groupTags[] = $group; } return $groupTags; } public static function getTagMap() { $questionTags = ModelUtil::all('question_tag'); $map = []; foreach ($questionTags as $questionTag) { $map[$questionTag['id']] = $questionTag; } return $map; } public static function listTagsByIds($ids) { return ModelUtil::model('question_tag')->whereIn('id', $ids)->get()->toArray(); } public static function paginateQuestion($page, $pageSize, $option = []) { $option['where']['parentId'] = 0; $paginateData = ModelUtil::paginate('question', $page, $pageSize, $option); $tagMap = self::getTagMap(); foreach ($paginateData['records'] as &$item) { $item['tag'] = TagUtil::string2Array($item['tag']); $item['tag'] = TagUtil::mapInfo($item['tag'], $tagMap); } return $paginateData; } public static function listQuestions($ids) { if (empty($ids)) { return []; } $questions = ModelUtil::allInWithOrder('question', 'id', $ids); $tagMap = self::getTagMap(); foreach ($questions as &$item) { $item['tag'] = TagUtil::string2Array($item['tag']); $item['tag'] = TagUtil::mapInfo($item['tag'], $tagMap); } return $questions; } public static function listCommentByQuestionId($questionId) { $comments = ModelUtil::all('question_comment', ['questionId' => $questionId], ['*'], ['id', 'asc']); return $comments; } public static function commentPost($memberUserId, $questionId, $content) { return ModelUtil::insert('question_comment', [ 'memberUserId' => $memberUserId, 'questionId' => $questionId, 'content' => $content, ]); } public static function updateQuestionCommentCount($questionId) { $commentCount = ModelUtil::count('question_comment', [ 'questionId' => $questionId ]); ModelUtil::update('question', $questionId, [ 'commentCount' => $commentCount ]); } public static function increaseQuestionTestCount($questionId) { ModelUtil::model('question')->where(['id' => $questionId])->increment('testCount'); } public static function increaseQuestionPassCount($questionId) { ModelUtil::model('question')->where(['id' => $questionId])->increment('passCount'); } public static function hasContent($text) { $text = trim(HtmlUtil::text($text)); return !empty($text); } public static function parseAnswerInfo($questionData, $userAnswer) { $judge = false; $correct = false; $answer = null; switch ($questionData['question']['type']) { case QuestionType::SINGLE_CHOICE: case QuestionType::TRUE_FALSE: foreach ($questionData['options'] as $index => $option) { if ($option['isAnswer']) { $answer = chr(ord('A') + $index); break; } } if (!empty($answer)) { $judge = true; if ($answer == $userAnswer) { $correct = true; } } break; case QuestionType::MULTI_CHOICES: $judge = true; $answer = []; foreach ($questionData['options'] as $index => $option) { if ($option['isAnswer']) { $answer[] = chr(ord('A') + $index); } } if (json_encode($answer) == json_encode($userAnswer)) { $correct = true; } break; case QuestionType::FILL: $answer = []; foreach ($questionData['answers'] as $item) { $answer[] = $item['answer']; } break; case QuestionType::TEXT: $answer = $questionData['answer']['answer']; break; } return [ 'judge' => $judge, 'correct' => $correct, 'answer' => $answer, ]; } }