@extends('admin::frame')

@section('pageTitle','全文索引同步')


@section('bodyAppend')
    @parent
    <script>
        $(function () {
            $('[data-refresh]').on('click', function () {
                var $index = $(this).closest('[data-index]');
                window.api.base.post('?', {action: 'refresh', index: $index.attr('data-index')}, function (res) {
                    $index.find('[data-count]').html(res.data.count);
                });
            });
            var sync = function ($index, index, nextId) {
                $index.find('[data-sync-status]').show().html('正在同步（' + index + ',' + nextId + '）');
                window.api.base.post('?', {action: 'sync', index: index, nextId: nextId}, function (res) {
                    if (res.data.syncCount > 0) {
                        setTimeout(function () {
                            sync($index, index, res.data.nextId);
                        }, 100);
                    } else {
                        $index.find('[data-sync-status]').hide();
                        $index.find('[data-refresh]').click();
                        window.api.dialog.tipSuccess('同步完成（' + index + ',' + nextId + '）');
                    }
                });
            };
            $('[data-sync]').on('click', function () {
                var $index = $(this).closest('[data-index]');
                sync($index, $index.attr('data-index'), 0);
            });
        });
    </script>
@endsection

@section('bodyContent')
    <div class="block">
        <div class="body">
            <table class="uk-table uk-table-radius">
                <thead>
                <tr>
                    <th width="100">索引</th>
                    <th width="100">说明</th>
                    <th width="100">数量</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                @foreach(\App\Util\ESUtil::allIndexes() as $index=>$indexName)
                    <tr data-index="{{$index}}">
                        <td>{{$index}}</td>
                        <td>{{$indexName}}</td>
                        <td>
                            <span data-count>-</span>
                        </td>
                        <td>
                            <a href="javascript:;" class="action-btn" data-refresh>刷新</a>
                            <a href="javascript:;" class="action-btn" data-sync>全量同步</a>
                            <span data-sync-status></span>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection