@extends('admin::frame')

@section('pageTitle','后台首页')

@section('adminScript')
    @parent
    @include('soft::admin.dashboardVersion')
@endsection

@section('bodyContent')

    @include('soft::admin.dashboardDemo')

    <div class="uk-grid">
        <div class="uk-width-1-2">
            <div class="admin-block-stat">
                <div class="icon green">
                    <i class="uk-icon-users"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\MemberController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('member_user'))}}
                </a>
                <div class="name">
                    会员总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-2">
            <div class="admin-block-stat">
                <div class="icon gavel">
                    <i class="uk-icon-users"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\PaperExamController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('paper_exam'))}}
                </a>
                <div class="name">
                    考试人次
                </div>
            </div>
        </div>
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon red">
                    <i class="uk-icon-th"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\QuestionController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('question'))}}
                </a>
                <div class="name">
                    题目总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-list"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\NewsController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('news'))}}
                </a>
                <div class="name">
                    资讯总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-3">
            <div class="admin-block-stat">
                <div class="icon dark">
                    <i class="uk-icon-file"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\PaperController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('paper'))}}
                </a>
                <div class="name">
                    试卷总数
                </div>
            </div>
        </div>
    </div>


    @include('soft::admin.dashboardCopyright')

@endsection