@extends('admin::frame')

@section('pageTitle','导入题目')

@section('bodyAppend')
    @parent
    <script>
        $(function(){
            window.api.uploadButton($('#fileUpload'), {
                text: '<div style="line-height:30px;height:30px;font-size:12px;padding:0;background:#EEE;color:#333;"><span class="uk-icon-plus" style="display:inline;line-height:30px;height:30px;"></span> 上传文件</div>',
                swf: __uploadButton.swf,
                server: '{{action('\TechSoft\Laravel\Admin\Controller\DataController@tempDataUpload',['category'=>'file'])}}',
                extensions: 'txt',
                sizeLimit: 5*1024*1024,
                chunkSize: __uploadButton.chunkSize,
                callback: function (file, me) {
                    $('[data-upload-file-path]').val(file.path);
                    $('[data-upload-file-name]').html(file.name).show();
                },
                finish: function () {

                }
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="block admin-form">
        <form action="?" class="uk-form" method="post" data-ajax-form>
            <div style="font-size:13px;">
                <table class="uk-table uk-table-radius uk-table-striped">
                    <tbody>
                    <tr>
                        <td>
                            <div class="line">
                                <div class="label">
                                    <a href="{{action('\App\Http\Controllers\Admin\QuestionController@importTemplate')}}" target="_blank">点击下载TXT模版</a>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="line">
                                <div class="label">
                                    导入题目文件
                                </div>
                                <div class="field">
                                    <div style="width:200px;">
                                        <div style="display:none;" class="uk-alert uk-alert-success" data-upload-file-name></div>
                                        <input type="hidden" name="file" data-upload-file-path />
                                    </div>
                                    <div id="fileUpload" style="width:200px;"></div>
                                </div>
                                <div class="help">
                                    目前支持 单选题、多选题、判断题、填空题、问答题 的单题目导入
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="line">
                                <button type="submit" class="uk-button uk-button-primary">立即导入</button>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </form>
    </div>

@endsection