@if(!empty($paperQuestionNumber))
    <div class="pb pb-question-view-number">
        <div>
            @if($paperQuestionNumberCount>1)
                第 {{$paperQuestionNumber}}-{{$paperQuestionNumber+$paperQuestionNumberCount-1}} 题
            @else
                第 {{$paperQuestionNumber}} 题
            @endif
            &nbsp;&nbsp;
            <i class="uk-icon-server"></i>{{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,\App\Types\QuestionType::GROUP)}}
        </div>
    </div>
@endif
<div class="pb pb-question-view">
    @if(empty($paperQuestionNumber))
        <div class="head">
            <h2>
                {{\TechOnline\Laravel\Type\TypeUtil::name(\App\Types\QuestionType::class,\App\Types\QuestionType::GROUP)}}
            </h2>
        </div>
    @endif
    <div class="body">

        <div class="question">
            <div class="question">
                {!! $questionData['question']['question'] !!}
            </div>
        </div>

        <div class="question-items">

            <?php $questionItemNumber = 1; ?>
            @foreach($questionData['items'] as $questionItemIndex=>$questionItem)
                @if($questionItem['question']['type']==\App\Types\QuestionType::SINGLE_CHOICE)
                    @include('theme.default.pc.memberExam.question.viewGroupSingleChoice')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::MULTI_CHOICES)
                    @include('theme.default.pc.memberExam.question.viewGroupMultiChoices')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::TRUE_FALSE)
                    @include('theme.default.pc.memberExam.question.viewGroupTrueFalse')
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::FILL)
                    @include('theme.default.pc.memberExam.question.viewGroupFill')
                    <?php $questionItemNumber+=count($questionItem['answers'])-1; ?>
                @elseif($questionItem['question']['type']==\App\Types\QuestionType::TEXT)
                    @include('theme.default.pc.memberExam.question.viewGroupText')
                @endif
                <?php $questionItemNumber++; ?>
            @endforeach

        </div>

        <div class="question question-analysis">
            <div class="answer-result">
                <div class="analysis" data-analysis>
                    <div class="analysis-head"><i class="uk-icon-list-alt"></i> 解析</div>
                    <div class="analysis-body ub-html">
                        @if($questionData['analysis']['analysis'])
                            {!! $questionData['analysis']['analysis'] !!}
                        @else
                            <div class="ub-empty">
                                无
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
