<div class="pb pb-question-view-number">
    <div>
        @if($paperQuestionNumberCount>1)
            第 {{$paperQuestionNumber}}-{{$paperQuestionNumber+$paperQuestionNumberCount-1}} 题
        @else
            第 {{$paperQuestionNumber}} 题
        @endif
        &nbsp;&nbsp;
        <i class="uk-icon-dot-circle-o"></i>单选题
    </div>
</div>
<div class="pb pb-question-view">
    <div class="body">

        <div class="question" data-question="singleChoice" data-alias="{{$questionData['question']['alias']}}">
            <div class="question">
                {!! $questionData['question']['question'] !!}
            </div>
            <div class="option">
                <?php $answers = []; ?>
                @foreach($questionData['options'] as $index=>$option)
                    <div class="item" data-choice data-choice-is-answer="{{$option['isAnswer']?'true':'false'}}">
                        <div class="choice">{{chr(ord('A')+$index)}}.</div>
                        {!! $option['option'] !!}
                    </div>
                    <?php
                    if($option['isAnswer']){
                        $answers[]=chr(ord('A')+$index);
                    }
                    ?>
                @endforeach
            </div>
            <div class="answer-result">
                <div class="answer" data-answer>
                    <div class="answer-head"><i class="uk-icon-gavel"></i> 答案</div>
                    <div class="answer-body ub-html">
                        {{join('，',$answers)}}
                    </div>
                </div>
                <div class="my-answer">
                    @if(\App\Util\QuestionExamUtil::isCorrect($questionData['options'],$paperExamQuestions[$paperQuestionIndex]['answer']))
                        <div class="uk-alert uk-alert-success">
                            <div class="label">我的答案</div>
                            {{\App\Util\QuestionExamUtil::optionToAnswerLabel($paperExamQuestions[$paperQuestionIndex]['answer'])}}
                        </div>
                    @else
                        <div class="uk-alert uk-alert-danger">
                            <div class="label">我的答案</div>
                            {{\App\Util\QuestionExamUtil::optionToAnswerLabel($paperExamQuestions[$paperQuestionIndex]['answer'])}}
                        </div>
                    @endif
                </div>
                @if(\App\Util\QuestionUtil::hasContent($questionData['analysis']['analysis']))
                    <div class="analysis" data-analysis>
                        <div class="analysis-head"><i class="uk-icon-list-alt"></i> 解析</div>
                        <div class="analysis-body ub-html">
                            {!! $questionData['analysis']['analysis'] !!}
                        </div>
                    </div>
                @endif
            </div>
        </div>

    </div>
</div>

