@extends($_frameLayoutView)

@section('pageTitleMain','会员中心')

@section('bodyScript')
    <script src="@assets('assets/main/pay.js')"></script>
    <script>
        $(function () {
            new window.api.payPage({
                payTypeSelector: '.pay-list > a',
                paySubmitSelector: '[data-pay-submit]',
                payTypeActiveClass: 'cur',
                dialog: window.api.dialog,
                device: 'pc',
                server: '?',
                postData: function () {
                    return {
                        vipId: $('.pb-member-vip .vip-list .item.active').attr('data-vip-id')
                    };
                }
            });
            var $items = $('.pb-member-vip .vip-list .item');
            $items.on('click', function () {
                $items.removeClass('active');
                $(this).addClass('active');
                window.api.base.post('/member/vip_calc',{vipId:$(this).attr('data-vip-id')},function (res) {
                    $('[data-vip-type]').html(res.data.type);
                    $('[data-vip-price]').html(res.data.price);
                    $('[data-vip-expire]').html(res.data.expire);
                    $('[data-vip-info]').show();
                });
                return false;
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/member/{{$_memberUser['id']}}">我的中心</a></li>
                <li class="uk-active"><span>开通会员</span></li>
            </ul>
        </div>

        <div class="uk-grid pb-member-profile">
            <div class="uk-width-1-6">
                @include('theme.default.pc.memberProfile.menu')
            </div>
            <div class="uk-width-5-6">
                <div class="pb pb-member-vip">
                    <div class="head">
                        <h2>开通/续费会员</h2>
                    </div>
                    <div class="body">
                        <div class="vip-current">
                            @if(!empty($_memberVip))
                                您当前是
                                <span class="ub-color-vip ub-text-bold">{{$_memberVip['title']}}</span>
                                ，
                                过期时间为：{{$_memberUser['vipExpire']}}
                            @endif
                        </div>

                        <div class="vip-list">
                            @foreach($memberVips as $memberVip)
                                @if(!$memberVip['isDefault'])
                                    <div class="item" data-vip-id="{{$memberVip['id']}}">
                                        <div class="title">
                                            {{$memberVip['title']}}
                                        </div>
                                        <div class="price">
                                            ￥{{$memberVip['price']}}
                                        </div>
                                        <div class="content">
                                            {!! $memberVip['content'] !!}
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <div class="pay-price" data-vip-info style="display:none;">
                            <span class="ub-text-warning" data-vip-type>-</span>
                            需要支付 <span class="ub-text-warning">￥</span><span class="ub-text-warning" data-vip-price>-</span>
                            ，
                            购买后<span class="ub-text-warning" data-vip-expire>-</span>过期
                        </div>
                        @if( \TechSoft\Laravel\Pay\PayUtil::hasPay() )
                            <div class="pay-list">
                                @if(\TechSoft\Laravel\Pay\PayUtil::isAlipayEnable())
                                    <a href="javascript:;"
                                       data-type="{{\TechSoft\Laravel\Pay\Types\PayType::ALIPAY}}">
                                        <img src="@assets('assets/lib/img/pay/alipay.jpg')"/>
                                        支付宝
                                    </a>
                                @endif
                                @if(\TechSoft\Laravel\Pay\PayUtil::isWechatEnable())
                                    <a href="javascript:;"
                                       data-type="{{\TechSoft\Laravel\Pay\Types\PayType::WECHAT}}">
                                        <img src="@assets('assets/lib/img/pay/wechat.jpg')"/>
                                        微信支付
                                    </a>
                                @endif
                            </div>
                        @endif
                        <div class="pay-submit">
                            <a href="javascript:;" class="btn btn-primary" data-pay-submit>确定支付</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection