<?php
 namespace TechSoft\Laravel\MemberChat; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Html\HtmlConverter; use TechSoft\Laravel\Html\HtmlType; use TechSoft\Laravel\Html\SimpleEmotionConverterInterceptor; use TechSoft\Laravel\MemberChat\Type\MemberChatMsgType; use TechSoft\Laravel\Util\HtmlUtil; class MemberChatUtil { public static function create($memberUserId, $chatMemberUserId) { $data = [ 'memberUserId' => $memberUserId, 'chatMemberUserId' => $chatMemberUserId, ]; $chat = ModelUtil::get('member_chat', $data); if (empty($chat)) { $chat = ModelUtil::insert('member_chat', $data); } return $chat; } public static function getMemberUserChat($memberUserId, $chatId) { $chat = ModelUtil::get('member_chat', [ 'id' => $chatId, 'memberUserId' => $memberUserId, ]); return $chat; } private static function send($fromMemberUserId, $toMemberUserId, $type, $content) { $chatData = ['memberUserId' => $fromMemberUserId, 'chatMemberUserId' => $toMemberUserId]; $chat = ModelUtil::get('member_chat', $chatData); if (empty($chat)) { $chat = ModelUtil::insert('member_chat', $chatData); } $recvChatData = ['memberUserId' => $toMemberUserId, 'chatMemberUserId' => $fromMemberUserId]; $recvChat = ModelUtil::get('member_chat', $recvChatData); if (empty($recvChat)) { $recvChat = ModelUtil::insert('member_chat', $recvChatData); } $msg = ModelUtil::insert('member_chat_msg', [ 'chatId' => $chat['id'], 'senderMemberUserId' => $fromMemberUserId, 'isRead' => true, 'type' => $type, 'content' => $content, ]); $recvMsg = ModelUtil::insert('member_chat_msg', [ 'chatId' => $recvChat['id'], 'senderMemberUserId' => $fromMemberUserId, 'isRead' => false, 'type' => $type, 'content' => $content, ]); ModelUtil::update('member_chat', ['id' => $chat['id']], [ 'msgCount' => ModelUtil::count('member_chat_msg', ['chatId' => $chat['id']]), 'unreadMsgCount' => 0, 'lastMsgId' => $msg['id'], ]); ModelUtil::update('member_chat', ['id' => $recvChat['id']], [ 'msgCount' => ModelUtil::count('member_chat_msg', ['chatId' => $recvChat['id']]), 'unreadMsgCount' => ModelUtil::count('member_chat_msg', ['chatId' => $recvChat['id'], 'isRead' => false,]), 'lastMsgId' => $recvMsg['id'], ]); return Response::generate(0, null, [ 'msg' => $msg, 'recvMsg' => $recvChat, ]); } public static function sendText($fromMemberUserId, $toMemberUserId, $content) { $content = HtmlConverter::convertToHtml(HtmlType::SIMPLE_TEXT, $content, [ SimpleEmotionConverterInterceptor::class, ]); return self::send($fromMemberUserId, $toMemberUserId, MemberChatMsgType::TEXT, $content); } public static function sendImage($fromMemberUserId, $toMemberUserId, $content) { $content = '<img data-image-preview src="' . $content . '" />'; return self::send($fromMemberUserId, $toMemberUserId, MemberChatMsgType::IMAGE, $content); } public static function listNewMsgsWithChatIdAndMaxId($chatId, $msgMaxId, $limit = 999) { $newMsgs = ModelUtil::model('member_chat_msg') ->where('chatId', $chatId) ->where('id', '>', $msgMaxId) ->orderBy('id', 'asc') ->limit($limit)->get() ->toArray(); return $newMsgs; } public static function setChatMsgAsRead($chatId, $msgIds = []) { if (empty($msgIds)) { return; } ModelUtil::model('member_chat_msg') ->where('chatId', $chatId) ->whereIn('id', $msgIds) ->update(['isRead' => true]); ModelUtil::update( 'member_chat', ['id' => $chatId], [ 'unreadMsgCount' => ModelUtil::count('member_chat_msg', ['chatId' => $chatId, 'isRead' => false,]), ] ); } public static function paginateChatMsg($chatId, $page, $pageSize, $option = []) { $option['where']['chatId'] = $chatId; $paginateData = ModelUtil::paginate('member_chat_msg', $page, $pageSize, $option); return $paginateData; } public static function paginateChat($memberUserId, $page, $pageSize, $option = []) { $option['search'] = []; $option['where']['memberUserId'] = $memberUserId; $paginateData = ModelUtil::paginate('member_chat', $page, $pageSize, $option); ModelUtil::join($paginateData['records'], 'chatMemberUserId', '_chatMemberUser', 'member_user', 'id'); ModelUtil::join($paginateData['records'], 'lastMsgId', '_lastMsg', 'member_chat_msg', 'id'); return $paginateData; } public static function markReadAll($memberUserId) { $chats = ModelUtil::all('member_chat', ['memberUserId' => $memberUserId]); $chatIds = array_fetch($chats, function ($k, $v) { return [$k, $v['id']]; }); ModelUtil::model('member_chat_msg')->whereIn('chatId', $chatIds)->update(['isRead' => true]); ModelUtil::model('member_chat')->where('memberUserId', $memberUserId)->update(['unreadMsgCount' => 0]); } public static function deleteMemberChat($memberUserId, $chatId) { $chat = ModelUtil::get('member_chat', ['id' => $chatId, 'memberUserId' => $memberUserId]); if (empty($chat)) { return; } ModelUtil::delete('member_chat', ['id' => $chat['id']]); ModelUtil::delete('member_chat_msg', ['chatId' => $chat['id']]); } public static function summary($msg) { switch ($msg['type']) { case MemberChatMsgType::TEXT: $msg['content'] = preg_replace('/<img class="emotion".*?>/', '[表情]', $msg['content']); return HtmlUtil::text($msg['content']); case MemberChatMsgType::IMAGE: return '[图片]'; } return ''; } }