<?php
 namespace TechSoft\Laravel\Shop\Jobs; use Illuminate\Support\Facades\Log; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Job\BaseJob; use TechSoft\Laravel\Shop\Types\OrderStatus; class OrderExpireCheckJob extends BaseJob { public $orderId; public $param; public static function create($orderId, $param = [], $delay = 0) { $job = new OrderExpireCheckJob(); $job->orderId = $orderId; $job->param = $param; $job->onQueue('OrderExpireCheckJob'); if ($delay > 0) { $job->delay($delay); } app('Illuminate\Contracts\Bus\Dispatcher')->dispatch($job); } public function handle() { Log::info('OrderExpireCheckJob.' . sprintf('%05d', getmypid()) . '.Execute ->' . $this->orderId . ' -> ' . json_encode($this->param)); ModelUtil::transactionBegin(); $order = ModelUtil::getWithLock('order', ['id' => $this->orderId]); if (empty($order)) { ModelUtil::transactionCommit(); return; } if ($order['status'] != OrderStatus::WAIT_PAY) { ModelUtil::transactionCommit(); return; } OrderCancelJob::create($this->orderId, ['expire' => true]); ModelUtil::transactionCommit(); } } 