<?php
 namespace TechSoft\Laravel\SoftApi; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Config\ConfigUtil; class SoftApiUtil { private static function instance($configPrefix) { return SoftApi::instance(ConfigUtil::get("${configPrefix}AppId"), ConfigUtil::get("${configPrefix}AppSecret")); } public static function audioConvert($from, $to, $contentBin) { $appId = ConfigUtil::get('softApiAudioConvertAppId'); $appSecret = ConfigUtil::get('softApiAudioConvertAppSecret'); if (empty($appId)) { $appId = ConfigUtil::get('softApiDefaultAppId'); $appSecret = ConfigUtil::get('softApiDefaultAppSecret'); } $softApi = SoftApi::instance($appId, $appSecret); $ret = $softApi->audioConvert($from, $to, base64_encode($contentBin)); if ($ret['code']) { return null; } return base64_decode($ret['data']['content']); } public static function asr($type, $contentBin) { $appId = ConfigUtil::get('softApiAsrAppId'); $appSecret = ConfigUtil::get('softApiAsrAppSecret'); if (empty($appId)) { $appId = ConfigUtil::get('softApiDefaultAppId'); $appSecret = ConfigUtil::get('softApiDefaultAppSecret'); } $softApi = SoftApi::instance($appId, $appSecret); $ret = $softApi->asr($type, base64_encode($contentBin)); if ($ret['code']) { return null; } return $ret['data']['text']; } public static function express($type, $no) { $appId = ConfigUtil::get('softApiExpressAppId'); $appSecret = ConfigUtil::get('softApiExpressAppSecret'); if (empty($appId)) { $appId = ConfigUtil::get('softApiDefaultAppId'); $appSecret = ConfigUtil::get('softApiDefaultAppSecret'); } $softApi = SoftApi::instance($appId, $appSecret); $ret = $softApi->express($type, $no); if ($ret['code']) { return []; } return $ret['data']['list']; } public static function captchaIsEnable() { return !!ConfigUtil::get('softApiCaptchaEnable', false); } public static function captchaScript() { return '<script src="https://api.' . __BASE_SITE__ . '/lib/captcha/base-1.0.0.js?20200410"></script>'; } public static function captchaAppId() { return ConfigUtil::get('softApiCaptchaAppId'); } public static function captchaVerify() { $input = InputPackage::buildFromInput(); return self::instance('softApiCaptcha')->captchaVerify( $input->getTrimString('action'), $input->getTrimString('key'), $input->getTrimString('data'), $input->getTrimString('runtime'), $input->getTrimString('types') ); } public static function captchaValidate($captchaKey) { $ret = self::instance('softApiCaptcha')->captchaValidate($captchaKey); if ($ret['code']) { return false; } return true; } }