local assets =
{
	Asset("ANIM", "anim/gravestones.zip"),
	}

local prefabs = 
{
	"ghost",
	"mound", 
}
local function onsave(inst, data)
	

	if inst.mound then
		data.mounddata = inst.mound:GetSaveRecord()
	end


	if inst.setepitaph then
		data.setepitaph = inst.setepitaph
	end
end	

local function onload(inst, data, newents)
	if data then

		if inst.mound and data.mounddata then
	        if newents and data.mounddata.id then
	            newents[data.mounddata.id] = {entity=inst.mound, data=data.mounddata} 
	        end
			inst.mound:SetPersistData(data.mounddata.data, newents)
		end


		if data.setepitaph then	
			--this handles custom epitaphs set in the tile editor		
	    	inst.components.inspectable:SetDescription("'"..data.setepitaph.."'")
	    	inst.setepitaph = data.setepitaph
		end
	end
end	

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local minimap = inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()
	minimap:SetIcon( "gravestones.png" )

    MakeObstaclePhysics(inst, .25)
    
    anim:SetBank("gravestone")
    anim:SetBuild("gravestones")
    anim:PlayAnimation("grave" .. tostring( math.random(4)))

    inst:AddComponent("inspectable")	
    inst.components.inspectable:SetDescription( STRINGS.EPITAPHS[math.random(#STRINGS.EPITAPHS)] )	    	

	inst:AddTag("grave")
-----------
inst:AddTag("skelbones")
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({"rocks","flint"})
	inst.components.lootdropper:AddChanceLoot("redgem", 0.33)
	inst.components.lootdropper:AddChanceLoot("bluegem", 0.33)


	inst:AddComponent("inspectable")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.MINE)
	inst.components.workable:SetWorkLeft(TUNING.MARBLEPILLAR_MINE)
	inst.components.workable:SetOnWorkCallback(          
		function(inst, worker, workleft)

	        local pt = Point(inst.Transform:GetWorldPosition())
	        if workleft <= 0 then
				inst.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
					            inst.components.lootdropper:DropLoot(pt)
	            inst:Remove()
	        else	            

--[[ No useable images
	            if workleft < TUNING.MARBLEPILLAR_MINE*(1/3) then
	                inst.AnimState:PlayAnimation("grave"..3)
	            elseif workleft < TUNING.MARBLEPILLAR_MINE*(2/3) then
	                inst.AnimState:PlayAnimation("grave"..3)
	            else
	                inst.AnimState:PlayAnimation("grave"..3)
	            end
--]]

-------------------------------
				if math.random() < .01 then
			local ghost = SpawnPrefab("ghost")
			local pos = Point(inst.Transform:GetWorldPosition())
			pos.x = pos.x -.3
			pos.z = pos.z -.3
			if ghost then
				ghost.Transform:SetPosition(pos.x, pos.y, pos.z)
			end
		end
-------------------------
	        end
	    end)
-----------
    inst.mound = inst:SpawnChild("mound") --no longer spawing mounds on load

    --local pos = Vector3(0,0,0)
    --pos.x = pos.x -.407
    --pos.z = pos.z -.407
    
	inst.OnLoad = onload
	inst.OnSave = onsave
    
   inst.mound.Transform:SetPosition((TheCamera:GetDownVec()*.5):Get())
     
    return inst
end

return Prefab( "common/objects/gravestone", fn, assets, prefabs ) 
