local assets =
{
    Asset("ANIM", "anim/hound_base.zip"),
}

local names = {"piece1","piece2","piece3","piece4"}

local function onsave(inst, data)
	data.anim = inst.animname
end

local function onload(inst, data)
    if data and data.anim then
        inst.animname = data.anim
	    inst.AnimState:PlayAnimation(inst.animname)
	end
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    inst.entity:AddSoundEmitter()

    inst.AnimState:SetBuild("hound_base")
    inst.AnimState:SetBank("houndbase")
    inst.animname = names[math.random(#names)]
    inst.AnimState:PlayAnimation(inst.animname)

    --inst:AddTag("bone")

    -------------------
    inst:AddComponent("inspectable")
    
	--MakeSnowCovered(inst)
    inst.OnSave = onsave 
    inst.OnLoad = onload 
-----------
inst:AddTag("skelbones")
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({"ash","wetgoop","beardhair"})
	inst.components.lootdropper:AddChanceLoot("redgem", 0.33)
	inst.components.lootdropper:AddChanceLoot("bluegem", 0.33)
	inst.components.lootdropper:AddChanceLoot("walrus_tusk", 0.10)
	inst.components.lootdropper:AddChanceLoot("goldnugget", 0.33)
	inst.components.lootdropper:AddChanceLoot("krampus_sack", 0.01)
	inst.components.lootdropper:AddChanceLoot("poop", 0.33)
	inst.components.lootdropper:AddChanceLoot("walrushat", 0.02)
	inst.components.lootdropper:AddChanceLoot("spoiled_food", 0.33)

	inst:AddComponent("inspectable")
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.MINE)
	inst.components.workable:SetWorkLeft(TUNING.MARBLEPILLAR_MINE)
	inst.components.workable:SetOnWorkCallback(          
		function(inst, worker, workleft)
		--inst.SoundEmitter:PlaySound("dontstarve/wilson/use_axe_tree")
	        local pt = Point(inst.Transform:GetWorldPosition())
	        if workleft <= 0 then
				inst.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
					            inst.components.lootdropper:DropLoot(pt)
	            inst:Remove()
	        else	            
	            if workleft < TUNING.MARBLEPILLAR_MINE*(1/3) then
	                inst.AnimState:PlayAnimation("piece1")
	            elseif workleft < TUNING.MARBLEPILLAR_MINE*(2/3) then
	                inst.AnimState:PlayAnimation("piece3")
	            else
	                inst.AnimState:PlayAnimation("piece2")
	            end
-------------------------------
				if math.random() < .01 then
			local ghost = SpawnPrefab("ghost")
			local pos = Point(inst.Transform:GetWorldPosition())
			pos.x = pos.x -.3
			pos.z = pos.z -.3
			if ghost then
				ghost.Transform:SetPosition(pos.x, pos.y, pos.z)
			end
		end
-------------------------
	        end
	    end)
-----------
	return inst
end

return Prefab( "forest/monsters/houndbone", fn, assets) 

