Option Explicit

Dim strPathToCompiler
Dim strCompileOptions
Dim strSourceCodeExt
Dim strCurPath
Dim strCommandOutput
strCommandOutput = ""
strCurPath = CreateObject("Scripting.FileSystemObject").GetAbsolutePathName(".")
strPathToCompiler = GetNewestInstalledFrameworkPath() & "\csc.exe"
strCompileOptions = "/target:winexe /nologo"
strSourceCodeExt = ".cs"
Dim objFs
Dim objFolder
Dim objFile
Set objFs = CreateObject("Scripting.FileSystemObject")
Set objFolder = objFs.GetFolder(strCurPath)
For Each objFile in objFolder.Files
  If Right(objFile.Name, 3) = strSourceCodeExt Then
    strCommandOutput = runCMD(strPathToCompiler & " /out:""" & strCurPath & "\" & Left(objFile.Name, InStr(objFile.Name, strSourceCodeExt)) & "exe"" " & strCompileOptions & " """ & objFile.Name & """")
    If strCommandOutput <> "" Then
      Wscript.Echo(strCommandOutput)
    End If
  End If
Next

Function GetNewestInstalledFrameworkPath()
  Dim objWsh
  Set objWsh = CreateObject("Wscript.Shell")
  Dim strFoundPath
  Dim objFs
  Set objFs = CreateObject("Scripting.FileSystemObject")
  Dim i
  Dim strArrayPaths
  Dim strArrayRegKeys
  strFoundPath = ""
  strArrayPaths = _
    Array("C:\Windows\Microsoft.NET\Framework64\v4.0.30319", _
          "C:\Windows\Microsoft.NET\Framework64\v2.0.50727", _
          "C:\Windows\Microsoft.NET\Framework\v4.0.30319", _
          "C:\Windows\Microsoft.NET\Framework\v2.0.50727")
  strArrayRegKeys = _
    Array("HKLM\Software\Microsoft\NET Framework Setup\NDP\v4\Full\Install", _
          "HKLM\Software\Microsoft\NET Framework Setup\NDP\v2.0.50727\Install", _
          "HKLM\Software\Microsoft\NET Framework Setup\NDP\v4\Full\Install", _
          "HKLM\Software\Microsoft\NET Framework Setup\NDP\v2.0.50727\Install")
  For i = 0 To Ubound(strArrayPaths)
    If objFs.FileExists(strArrayPaths(i) & "\csc.exe") Then
      On Error Resume Next
      If objWsh.RegRead(strArrayRegKeys(i)) = 1 Then
        If Err.number = 0 Then
          strFoundPath = strArrayPaths(i)
          Exit For
        End If
      End If
      On Error Goto 0
    End If
  Next
  Set objFs = Nothing
  Set objWsh = Nothing
  GetNewestInstalledFrameworkPath = strFoundPath
End Function

Function runCMD(strRunCmd)
  Dim objShell, objExec, strOut
  Set objShell = WScript.CreateObject("WScript.Shell")
  Set objExec = objShell.Exec(strRunCmd)
  strOut = ""
  Do While Not objExec.StdOut.AtEndOfStream
    strOut = strOut & objExec.StdOut.ReadLine() & vbcrlf
  Loop
  Set objShell = Nothing
  Set objExec = Nothing
  runCMD = strOut
End Function 