﻿using Shell32;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NeteaseMusicTools
{
    

    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        #region methods

        private string Getjson(string url)
        {
            try
            {
                WebClient myclinet = new WebClient() ;
                myclinet.Credentials = CredentialCache.DefaultCredentials;
                Byte[] page = myclinet.DownloadData(url);
                //string pagedata = Encoding.Default.GetString(page);
                string pagedata = Encoding.UTF8.GetString(page); 
                return pagedata;
            }
            catch(WebException webex)
            {
                MessageBox.Show(webex.Message.ToString());
                return null;
            }            
        }

        private MatchCollection Getlist (string text,string exp)
        {
            MatchCollection mc = Regex.Matches(text, exp);
            return mc;
        }

        public static string GetMediaDetailInfo(string path, int icolumn)
        {
            try
            {
                ShellClass sh = new ShellClass();
                Folder folder = sh.NameSpace(path.Substring(0, path.LastIndexOf("\\")));
                FolderItem folderItem = folder.ParseName(path.Substring(path.LastIndexOf("\\") + 1));
                return folder.GetDetailsOf(folderItem, icolumn);
            }
            catch (Exception ex)
            {
                ex.Message.ToString();
                return null;
            }
        }


        private List<string> GetFiles(DirectoryInfo directory, string pattern)
        {
            List<string> result = new List<string>();
            if (directory.Exists || pattern.Trim() != string.Empty)
            {
                try
                {
                    foreach (FileInfo info in directory.GetFiles(pattern))
                    {
                        result.Add(info.FullName.ToString());
                       // num++;
                    }
                }
                catch { }
                foreach (DirectoryInfo info in directory.GetDirectories())
                {
                    GetFiles(info, pattern);
                }
            }
            return result;
        }


        private void FileCopy(string path1, string path2)
        {
            //父目录
            string filename = path2;
            string path = Path.GetDirectoryName(filename);
            

            if (!System.IO.Directory.Exists(path))
            {
                // 目录不存在，建立目录
                System.IO.Directory.CreateDirectory(path);
            }
            String sourcePath = path1;
            String targetPath = path2;
            File.Copy(sourcePath, targetPath, true);

        }

        //mode将在按键时获取textbox目录
        string mode = "";
        
        private void rename()
        {
            string maex = textBox8.Text;
            

            List<string> loclist;
            if(String.IsNullOrEmpty(textBox5.Text))
            {
                MessageBox.Show("未选择路径");
                return;
            }
            DirectoryInfo df = new DirectoryInfo(textBox5.Text);
            loclist = GetFiles(df, "*.*");

            if (!String.IsNullOrEmpty(mode))
            {
                if (MessageBox.Show("本次操作会按格式命名目录下所有歌曲，目录为本页顶端选择的 网易云下载目录，是否继续？", "注意", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                {
                    this.Invoke(new Action(() =>
                    {
                        button5.Text = "开始";
                        button3.Enabled = false;
                    }));
                    return;
                }
                
                if (String.IsNullOrEmpty(textBox5.Text))
                {
                    MessageBox.Show("请选择目录,帮助详见关于页");
                    return;
                }
                if (mode == "歌曲 - 歌手")
                {
                    //textBox6.Text = "";
                    this.Invoke(new Action(() =>
                    {
                        textBox6.Text = "";
                    }));
                    for (int i = 0; i < loclist.Count; i++)
                    {
                        if(backgroundWorker2.CancellationPending)
                        {
                            this.Invoke(new Action(() =>
                            {
                                textBox6.AppendText("用户已取消操作");
                                textBox6.ScrollToCaret();
                                button3.Enabled = true;
                            }));
                            return;
                        }
                        string name = GetMediaDetailInfo(loclist[i], 21) + " - " + GetMediaDetailInfo(loclist[i], 13);
                        string path = Path.GetDirectoryName(loclist[i]);
                        string ex = Path.GetExtension(loclist[i]);
                        

                        this.Invoke(new Action(() =>
                        {
                            textBox6.AppendText("执行：" + name + "\n");
                            textBox6.ScrollToCaret();
                        }));

                        if (name == " - ")
                        {
                            continue;
                        }
                        else if (!string.IsNullOrEmpty(Regex.Match(name, maex).Value.ToString()))
                        {
                            
                            this.Invoke(new Action(() =>
                            {
                                textBox6.AppendText("失败：" + name + "\n");
                                textBox6.ScrollToCaret();
                            }));
                            continue;
                        }
                        File.Move(loclist[i], path + "\\" + name + ex);
                        //textBox6.AppendText("执行：" + name);
                        this.Invoke(new Action(() =>
                        {
                            textBox6.AppendText("成功：" + name + "\n");
                            textBox6.ScrollToCaret();
                        }));
                       // backgroundWorker2.ReportProgress(name);
                    }


                }
                if (mode == "歌手 - 歌曲")
                {
                    //textBox6.Text = "";
                    this.Invoke(new Action(() =>
                    {
                        textBox6.Text = "";
                    }));
                    for (int i = 0; i < loclist.Count; i++)
                    {
                        if(backgroundWorker2.CancellationPending)
                        {
                            this.Invoke(new Action(() =>
                            {
                                textBox6.AppendText("用户已取消操作");
                                textBox6.ScrollToCaret();
                                button3.Enabled = true;
                            }));
                            return;
                        }
                        string name = GetMediaDetailInfo(loclist[i], 13) + " - " + GetMediaDetailInfo(loclist[i], 21);
                        string path = Path.GetDirectoryName(loclist[i]);
                        string ex = Path.GetExtension(loclist[i]);
                        

                        this.Invoke(new Action(() =>
                        {
                            textBox6.AppendText("执行：" + name + "\n");
                            textBox6.ScrollToCaret();
                        }));

                        if (name == " - ")
                        {
                            continue;
                        }
                        else if (!string.IsNullOrEmpty(Regex.Match(name, maex).Value.ToString()))
                        {

                            this.Invoke(new Action(() =>
                            {
                                textBox6.AppendText("失败：" + name + "\n");
                                textBox6.ScrollToCaret();
                            }));
                            continue;
                        }

                        File.Move(loclist[i], path + "\\" + name + ex);
                        //textBox6.AppendText("执行：" + name);
                        this.Invoke(new Action(() =>
                        {
                            textBox6.AppendText("成功：" + name + "\n");
                            textBox6.ScrollToCaret();
                        }));
                    }

                }
                this.Invoke(new Action(() =>
                {
                    button5.Text = "开始";
                    textBox6.AppendText("完成" + "\n");
                    textBox6.ScrollToCaret();
                    button3.Enabled = true;
                    b5 = 0;
                }));
            }
            else
            {
                MessageBox.Show("请选择格式");
            }
        }


        int k;       
        private void rank()
        {

            List<string> loclist;
            DirectoryInfo df = new DirectoryInfo(ipath);
            loclist = GetFiles(df, "*.*");

            
            string lcpath=string.Empty;
            //t为列表数量
            for (int i = 0; i < t - 1; i++)
            {
                if(backgroundWorker1.CancellationPending)
                {
                    return;
                }
                //progressBar1.Value = i;
                backgroundWorker1.ReportProgress(i+1);
                for (int j = 0; j < loclist.Count; j++)
                {
                    //MessageBox.Show(GetMediaDetailInfo(loclist[j], 13));
                    //MessageBox.Show(loclist[j]);
                    if (GetMediaDetailInfo(loclist[j], 13) == dt.Rows[i][2].ToString() && GetMediaDetailInfo(loclist[j], 21) == dt.Rows[i][1].ToString())
                    {
                        string ex = Path.GetExtension(loclist[j]);
                        string path = Path.GetDirectoryName(loclist[j]);
                        string filename = Path.GetFileName(loclist[j]);
                        string pre = dt.Rows[i][0].ToString().PadLeft(3, '0');
                        string name = textBox3.Text;
                        lcpath = path + "\\" + name;
                        if (checkBox4.Checked==false)
                        {
                            pre = string.Empty;
                        }
                        bool judge = string.IsNullOrEmpty(Regex.Match(dt.Rows[i][2].ToString() + dt.Rows[i][1].ToString(), textBox8.Text).Value.ToString());
                        //保持文件名
                        if (k==0||judge!=true)
                        {
                            FileCopy(loclist[j], path + "\\" + name + "\\" + pre + filename);
                            continue;
                        }
                        //歌曲-歌手
                        else if(k==1)
                        {

                            FileCopy(loclist[j], path + "\\" + name + "\\" + pre + dt.Rows[i][1]+" - "+dt.Rows[i][2]+ex);

                        }
                        //歌手-歌曲
                        else
                        {
                            FileCopy(loclist[j], path + "\\" + name + "\\" + pre + dt.Rows[i][2] + " - " + dt.Rows[i][1]+ex);
                        }
                        
                    }
                }
            }
            //MessageBox.Show("完成！");
            this.Invoke(new Action(() =>
            {
                button3.Text = "开始！";
                button5.Enabled = true;
            }));
            if (MessageBox.Show("完成！！是否打开文件目录？", "完成", MessageBoxButtons.OKCancel) == DialogResult.OK)

            {

                System.Diagnostics.Process.Start("explorer.exe", lcpath);

            }


        }

        private bool isbool(string str)
        {
            if(str=="False")
            {
                return false;
            }
            else
            {
                return true;
            }
        }



        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            string path1 =Application.StartupPath+ @"\mntsetting.ini";
            comboBox1.Text = "歌曲 - 歌手";
            if (File.Exists(path1))
            {
                iniop op = new iniop();
                op.path = path1;
                textBox5.Text = op.readini("User", "Path");
                checkBox1.Checked = isbool(op.readini("User", "key1"));
                checkBox2.Checked = isbool(op.readini("User", "key2"));
                checkBox3.Checked = isbool(op.readini("User", "key3"));
                checkBox4.Checked = isbool(op.readini("User", "key4"));
                
            }

            

        }
        DataTable dt = new DataTable();
        int t = 1;
        private void button1_Click(object sender, EventArgs e)
        {
            t = 1;
            dataGridView1.DataSource = null;
            dt = new DataTable();
            dt.Columns.Add("序号");
            dt.Columns.Add("歌曲名");
            dt.Columns.Add("歌手");

            string iniurl = textBox2.Text;

            Match urlt = Regex.Match(iniurl, "=[0-9].+");
            string url = (@"http://music.163.com/api/playlist/detail?id" + urlt.Value);
            string exp1 = textBox1.Text;
            string strjson = Getjson(url);
            MatchCollection lst = Getlist(strjson, exp1);
            MatchCollection lstn = Getlist(strjson, textBox4.Text);
            foreach (Match item in lstn)
            {
                textBox3.Text = item.Groups[1].Value;
            }

            
            foreach (Match item in lst)
            {
                dt.Rows.Add(t++.ToString(), item.Groups[1].Value, item.Groups[2].Value);
                
            }
           
            dataGridView1.DataSource = dt;
            dataGridView1.RowHeadersVisible = false;
            //dataGridView1.ColumnHeadersVisible = false;
            
            dataGridView1.Columns[0].Width = 30;
            dataGridView1.Columns[1].Width = 180;
            dataGridView1.Columns[0].ReadOnly = true;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog()==DialogResult.OK)
            {
                textBox5.Text=folderBrowserDialog1.SelectedPath;
            }
        }
        string ipath;
        int b1 = 0;
        private void button3_Click(object sender, EventArgs e)
        {
            backgroundWorker1.WorkerSupportsCancellation = true;
            if (b1==1)
            {
                backgroundWorker1.CancelAsync();
                b1 = 0;
                this.Invoke(new Action(() =>
                {
                    button3.Text = "开始！";
                    button5.Enabled = true;
                }));
                //textBox3.Text = "开始！";
                return;
            }
            else
            {
                this.Invoke(new Action(() =>
                {
                    button5.Enabled = false;
                    button3.Text = "取消";
                }));
                //textBox3.Text = "取消";
                b1 = 1;
            }
            //得到存储路径
            progressBar1.Minimum = 0;
            progressBar1.Maximum = t - 1;
            ipath ="";
            if(String.IsNullOrEmpty(textBox5.Text))
            {
                MessageBox.Show("请选择目录！");
                tabControl1.SelectedTab = tabControl1.TabPages[1];
                this.Invoke(new Action(() =>
                {
                    button3.Text = "开始！";
                    button5.Enabled = true;
                }));
                return;

            }
            else if (dataGridView1.DataSource==null)
            {
                MessageBox.Show("你的歌单还没有拿给我！！");
                this.Invoke(new Action(() =>
                {
                    button3.Text = "开始！";
                    button5.Enabled = true;
                }));
                return;
            }
            else
            {
                ipath = textBox5.Text;
            }
            k = 0;
            if(checkBox1.Checked==true)
            {
                k = 0;
            }
            else if(checkBox2.Checked==true)
            {
                k = 1;
            }
            else if(checkBox3.Checked==true)
            {
                k = 2;
            }
            else
            {
                MessageBox.Show("请选择一种归类命名方式");
                return;
            }
            
            backgroundWorker1.RunWorkerAsync();
            //ThreadStart sot = new ThreadStart(rank);
            //Thread th1 = new Thread(sot);
            //th1.Start();
            //rank();
            #region rank
            // //获取本地歌曲路径
            // List<string> loclist;
            // DirectoryInfo df = new DirectoryInfo(ipath);
            // loclist = GetFiles(df, "*.*");
            // //获取信息
            // //把json与本地信息进行对比
            // for (int i = 0; i < t-1; i++)
            // {
            //     for (int j = 0; j < loclist.Count; j++)
            //     {
            //         if (GetMediaDetailInfo(loclist[j], 13) == dt.Rows[i][2].ToString() && GetMediaDetailInfo(loclist[j], 21)== dt.Rows[i][1].ToString())
            //         {
            //             string path = Path.GetDirectoryName(loclist[j]);
            //             string filename = Path.GetFileName(loclist[j]);
            //             string pre = dt.Rows[i][0].ToString().PadLeft(3, '0');
            //             string name = textBox3.Text;
            //             FileCopy(loclist[j], path + "\\" + name + "\\" + pre + filename);
            //         }
            //     }
            // }
            // MessageBox.Show("ok");
            // //如果正确开始归类
            //   //序号
            //   //重命名
            //   //歌单名
            ////进度条&弹窗
            #endregion


        }

        private void button4_Click(object sender, EventArgs e)
        {
            string path1 =Application.StartupPath+@"\mntsetting.ini";
            if (!File.Exists(path1))
            {
                File.Create(path1).Close();
                
            }

            iniop op = new iniop();
            op.path = path1;
            op.writeini("User", "Path", textBox5.Text);
            op.writeini("User", "key1", checkBox1.Checked.ToString());
            op.writeini("User", "key2", checkBox2.Checked.ToString());
            op.writeini("User", "key3", checkBox3.Checked.ToString());
            op.writeini("User", "key4", checkBox4.Checked.ToString());
            MessageBox.Show("ok");

        }

        private void checkBox1_Click(object sender, EventArgs e)
        {
            checkBox1.Checked = true;
            checkBox2.Checked = false;
            checkBox3.Checked = false;
        }

        private void checkBox2_Click(object sender, EventArgs e)
        {
            checkBox1.Checked = false;
            checkBox2.Checked = true;
            checkBox3.Checked = false;
        }
        private void checkBox3_Click(object sender, EventArgs e)
        {
            checkBox1.Checked = false;
            checkBox2.Checked = false;
            checkBox3.Checked = true;
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            rank();
        }
        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            progressBar1.Value = e.ProgressPercentage;
        }

        int b5 = 0;//可用
        private void button5_Click(object sender, EventArgs e)
        {
            backgroundWorker1.WorkerSupportsCancellation = true;
            if (string.IsNullOrEmpty(comboBox1.SelectedItem.ToString()))
            {
                MessageBox.Show("请选择模式");
                return;
            }
            mode = comboBox1.SelectedItem.ToString();
            if (b5 == 0) 
            {
                b5 = 1;
                this.Invoke(new Action(() =>
                {
                    button5.Text = "取消";
                    button3.Enabled = false;
                }));
            }
            else
            {
                b5 = 0;
                this.Invoke(new Action(() =>
                {
                    button5.Text = "开始";
                    button3.Enabled = true;
                }));
                backgroundWorker1.CancelAsync();
                return;
            }


            #region
            //List<string> loclist;
            //DirectoryInfo df = new DirectoryInfo(textBox5.Text);
            //loclist = GetFiles(df, "*.*");
            //if (!String.IsNullOrEmpty(comboBox1.SelectedItem.ToString()))
            //{
            //    if (MessageBox.Show("本次操作会按格式命名目录下所有歌曲，目录为本页顶端选择的 网易云下载目录，是否继续？", "注意", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
            //    {
            //        return;                    
            //    }
            //    if (String.IsNullOrEmpty( textBox5.Text))
            //    {
            //        MessageBox.Show("请选择目录,帮助详见关于页");
            //        return;
            //    }
            //    if (comboBox1.SelectedItem.ToString() == "歌曲 - 歌手")
            //    {
            //        textBox6.Text = "";
            //        for (int i = 0; i < loclist.Count; i++)
            //        {
            //            string name = GetMediaDetailInfo(loclist[i], 21) + " - "+GetMediaDetailInfo(loclist[i], 13);
            //            string path = Path.GetDirectoryName(loclist[i]);
            //            string ex = Path.GetExtension(loclist[i]);
            //            File.Move(loclist[i], path + "\\" + name + ex);
            //            textBox6.AppendText("执行：" + name);
            //        }


            //    }
            //    if (comboBox1.SelectedItem.ToString() == "歌手 - 歌曲") 
            //    {
            //        textBox6.Text = "";
            //        for (int i = 0; i < loclist.Count; i++)
            //        {
            //            string name = GetMediaDetailInfo(loclist[i], 13) + " - " + GetMediaDetailInfo(loclist[i], 21);
            //            string path = Path.GetDirectoryName(loclist[i]);
            //            string ex = Path.GetExtension(loclist[i]);                        
            //            File.Move(loclist[i], path + "\\" + name + ex);
            //            textBox6.AppendText("执行：" + name);
            //        }

            //    }
            //}
            //else
            //{
            //    MessageBox.Show("请选择格式");
            //}
            #endregion
            
            backgroundWorker2.RunWorkerAsync();

        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://music.163.com/#/user/home?id=30457340");
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start("http://bbs.luobotou.org/forum.php?mod=viewthread&tid=12224#lastpost");
        
        }

        private void backgroundWorker2_DoWork(object sender, DoWorkEventArgs e)
        {
            rename();
        }

        private void backgroundWorker2_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            //string cen = e.ProgressPercentage.ToString();
            //textBox6.AppendText("执行：" + cen);
        }
    }


    class iniop
    {
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(
            string section, string key, string defVal, StringBuilder reVal, int size, string filePath
            );
        [DllImport("kernel32")]
        private static extern int WritePrivateProfileString(
            string section, string key, string val, string filePath
            );

        public string path { get; set; }
        public string readini(string section, string key)
        {
            string defVal = string.Empty;
            StringBuilder reVal = new StringBuilder();
            int size = 10240;
            string rt = string.Empty;
            try
            {
                GetPrivateProfileString(section, key, defVal, reVal, size, this.path);
                rt = reVal.ToString();
            }
            catch
            {

                rt = string.Empty;
            }
            return rt;
        }
        public bool writeini(string section, string key, string val)
        {
            try
            {
                WritePrivateProfileString(section, key, val, this.path);
                return true;
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.ToString());
                return false;
            }
        }
    }
}
