import AINetrunnersConfig.*

// Intercept the status effects being applied and change them
@replaceMethod(BaseScriptableAction)
protected func ProcessStatusEffects(actionEffects: array<wref<ObjectActionEffect_Record>>, gameInstance: GameInstance) -> Void {
  let i: Int32;
  let instigator: ref<GameObject>;
  instigator = this.GetExecutor();
  i = 0;
  while i < ArraySize(actionEffects) {
    switch actionEffects[i].Recipient().Type() {
      case gamedataObjectActionReference.Instigator:
        StatusEffectHelper.ApplyStatusEffect(this.GetExecutor(), actionEffects[i].StatusEffect().GetID(), instigator.GetEntityID());
        break;
      case gamedataObjectActionReference.Target:
        // replace/add status effects
        let statusEffectID: TweakDBID = actionEffects[i].StatusEffect().GetID();
        if statusEffectID == t"AIQuickHackStatusEffect.HackWeaponMalfunction" {
          // working AIQuickHack but needs status effect swapped to one that works
          GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"AIQuickHackStatusEffect.HackJamWeapon", GameObject.GetTDBID(instigator), instigator.GetEntityID());
          break;
        };
        if statusEffectID == t"AIQuickHackStatusEffect.HackLocomotion" {
          // working AIQuickHack but needs status effect swapped to one that works
          GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"BaseStatusEffect.LocomotionMalfunction", GameObject.GetTDBID(instigator), instigator.GetEntityID());
          break;
        };
        if statusEffectID == t"BaseStatusEffect.Overload" {
          // this one needs a new status effect but we are also using it as placeholder for any custom hacks
          let target: ref<ScriptedPuppet> = GameInstance.FindEntityByID(gameInstance, this.m_requesterID) as ScriptedPuppet;
          if IsDefined(target) {
            let customHack: AINetrunnerHack = target.AI_Netrunners_lastHackApplied;
            switch customHack {
              case AINetrunnerHack.ShortCircuit:
                GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"BaseStatusEffect.PlayerElectrocuted", GameObject.GetTDBID(instigator), instigator.GetEntityID());
                break;
              case AINetrunnerHack.RebootOptics:
                GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"BaseStatusEffect.Blind", GameObject.GetTDBID(instigator), instigator.GetEntityID()); 
                break;
              case AINetrunnerHack.Contagion:
                GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"BaseStatusEffect.PlayerPoisoned", GameObject.GetTDBID(instigator), instigator.GetEntityID());
                break;
              case AINetrunnerHack.SynapseBurnout:
                let statPoolsSystem: ref<StatPoolsSystem> = GameInstance.GetStatPoolsSystem(gameInstance);
                let targetID: StatsObjectID = Cast(this.m_requesterID);
                let percValueToDrain: Float;
                percValueToDrain = getSynapseBurnoutDamagePerc(statPoolsSystem.GetStatPoolValue(targetID, gamedataStatPoolType.Health));
                statPoolsSystem.RequestChangingStatPoolValue(targetID, gamedataStatPoolType.Health, -percValueToDrain, instigator, true);
                // just a slight visual effect
                GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, t"BaseStatusEffect.Overload", GameObject.GetTDBID(instigator), instigator.GetEntityID());
                break;
            };
            // unset this:
            target.AI_Netrunners_lastHackApplied = AINetrunnerHack.Undefined;
          };
        };

        // default
        GameInstance.GetStatusEffectSystem(gameInstance).ApplyStatusEffect(this.m_requesterID, statusEffectID, GameObject.GetTDBID(instigator), instigator.GetEntityID());   
        break;
      case gamedataObjectActionReference.Source:
    };
    i += 1;
  };
}

// change which icon is displayed in the buff/debuff list
@replaceMethod(buffListGameController)
private final func UpdateBuffDebuffList() -> Void {
  let i: Int32 = 0;
  let currBuffWidget: wref<inkWidget>;
  let iconPath: String;
  let data: ref<StatusEffect_Record>;
  let dispayName: String;
  let onScreenBuffsCount: Int32;
  let incomingBuffsCount: Int32;
  let currBuffLoc: wref<buffListItemLogicController>;
  let buffTimeRemaining: Float;
  let buffList: array<BuffInfo>;
  while i < ArraySize(this.m_buffDataList) {
    ArrayPush(buffList, this.m_buffDataList[i]);
    i = i + 1;
  };
  i = 0;
  while i < ArraySize(this.m_debuffDataList) {
    ArrayPush(buffList, this.m_debuffDataList[i]);
    i = i + 1;
  };
  incomingBuffsCount = ArraySize(buffList);
  onScreenBuffsCount = inkCompoundRef.GetNumChildren(this.m_buffsList);
  this.SendVisibilityUpdate(inkWidgetRef.IsVisible(this.m_buffsList), incomingBuffsCount > 0);
  inkWidgetRef.SetVisible(this.m_buffsList, incomingBuffsCount > 0);
  if incomingBuffsCount != 0 {
    if onScreenBuffsCount > incomingBuffsCount {
      i = incomingBuffsCount - 1;
      while i < onScreenBuffsCount {
        currBuffWidget = this.m_buffWidgets[i];
        currBuffWidget.SetVisible(false);
        i = i + 1;
      };
    } else {
      if onScreenBuffsCount < incomingBuffsCount {
        while onScreenBuffsCount < incomingBuffsCount {
          onScreenBuffsCount = onScreenBuffsCount + 1;
          currBuffWidget = this.SpawnFromLocal(inkWidgetRef.Get(this.m_buffsList), n"Buff");
          currBuffWidget.SetVisible(false);
          ArrayPush(this.m_buffWidgets, currBuffWidget);
        };
      };
    };
  };
  i = 0;
  while i < incomingBuffsCount {
    data = TweakDBInterface.GetStatusEffectRecord(buffList[i].buffID);
    buffTimeRemaining = buffList[i].timeRemaining;
    if IsDefined(data) && IsDefined(data.UiData()) {
      iconPath = data.UiData().IconPath();
      dispayName = data.UiData().DisplayName();
    };
    if !IsDefined(data) || !IsDefined(data.UiData()) || Equals(data.UiData().IconPath(), "") {
    } else {
      currBuffWidget = this.m_buffWidgets[i];
      currBuffWidget.SetVisible(true);
      currBuffLoc = currBuffWidget.GetController() as buffListItemLogicController;
      // Swap out icons that don't work
      if Equals(data.UiData().IconPath(), "stagger") {
        // for cripple movement
        currBuffLoc.SetData(StringToName("LocomotionMalfunction"), buffTimeRemaining);
      } else {
        currBuffLoc.SetData(StringToName(data.UiData().IconPath()), buffTimeRemaining);
      };
    };
    i = i + 1;
  };
}
