module AINetrunnersUtils

import AINetrunnersConfig.*

public func GetValueFromCurve(xVals: array<Float>, yVals: array<Float>, input: Float) -> Float {
  if ArraySize(xVals) > ArraySize(yVals) || ArraySize(yVals) == 0 {
    return 0;
  };
  
  let i: Int32 = 0;
  while i < ArraySize(xVals) {
    if input < xVals[i] {
      if i == 0 {
        return yVals[i];
      };
      return linearInterpolate(input, xVals[i - 1], yVals[i - 1], xVals[i], yVals[i]);
    };
    i += 1;
  }
  return yVals[i - 1];
}

public func linearInterpolate(x: Float, x0: Float, y0: Float, x1: Float, y1: Float) -> Float {
  if x1 == x0 {
    return y0;
  };
  return (y0 * (x1 - x) + y1 * (x - x0)) / (x1 - x0);
}

public func getIDForCustomAINetrunnerHack(hack: AINetrunnerHack) -> TweakDBID {
  switch hack {
    case AINetrunnerHack.Overheat:
      return t"AIQuickHack.HackOverheat";
    case AINetrunnerHack.CyberwareMalfunction:
      return t"AIQuickHack.HackCyberware";
    case AINetrunnerHack.ShortCircuit:
      return t"AIQuickHack.HackOverload";
    case AINetrunnerHack.CrippleMovement:
      return t"AIQuickHack.HackLocomotion";
    case AINetrunnerHack.WeaponGlitch:
      return t"AIQuickHack.HackWeaponMalfunction";
    case AINetrunnerHack.Burning:
      return t"AIQuickHack.HackBurning";
    case AINetrunnerHack.ImminentSystemFailure:
      return t"AIQuickHack.HackDeath";
    default:
      // Use Overload for custom hacks. Choice is somewhat arbitrary.
      return t"AIQuickHack.HackOverload";
  };
}

public func chooseFromKnownHacks(hacks: array<AINetrunnerHack>) -> AINetrunnerHack {
  let weights: array<Float>;
  let sum: Float = 0;
  let i: Int32 = 0;
  
  while i < ArraySize(hacks) {
    let weight: Float = getHackWeight(hacks[i]);
    ArrayPush(weights, weight);
    sum += weight;
    i += 1;
  };
  let val: Float = RandRangeF(0, sum);
  i = 0;
  sum = 0;
  while i < ArraySize(hacks) {
    sum += weights[i];
    if val <= sum {
      return hacks[i];
    };
    i += 1;
  };
  // shouldn't happen
  return hacks[ArraySize(hacks) - 1];
}
