function guessRootDomainFromMainAddr(mainAddr){
	var reg=  new RegExp("(\/\/)?(www\.)?([^/]*?)\/*$","i");
	var regRe=reg.exec(mainAddr);
	if(regRe==null){
		return '';
	}
	var rootDomain=regRe[3];
	return rootDomain;
}
function getRootDomainFromHost(host){
	var reg= /[(\.)|(\/\/)]([^\/.]*)\.(com|com\.cn|cn|net|org|co|me|biz|net\.cn|org\.cn|gov.cn|name|info|so|tel|mobi|asia|cc|tv|公司|网络|中国)$/i;
	console.log(reg);
	var regRe=reg.exec(host);
	if(regRe==null){
		return '';
	}
	console.log('host:'+host);
	console.log(regRe);
	
	var rootDomain=regRe[1]+'.'+regRe[2];
	return rootDomain;
}
function getWsnFromRootDomain(rd){
	var ws=ls.get('g_websites');
	if(ws==null){
		return '';
	}
	var result='';
	$.each(ws,function(k,v){
		if(v.rootDomain==rd){
			result=v.name;
			return false;
		}
	});
	return result;
};

function getRootDomain(wn){
	var ws=ls.get('g_websites');
	if(ws==null){
		return '';
	}
	var result='';
	$.each(ws,function(k,v){
		if(v.name==wn){
			result=v.rootDomain;
			return false;
		}
	});
	return result;
};

function getCurANFromHost(host){
	var rd=getRootDomainFromHost(host);
	var ws=ls.get('g_websites');
	if(ws==null){
		return '';
	}
	var result='';
	var curAccountIndex=-1;
	var wsn='';
	$.each(ws,function(k,v){
		if(v.rootDomain==rd){
			curAccountIndex=v.curAccountIndex;
			wsn=v.name;
			return false;
		}
	});
	result=Account.getNameFromIndex(wsn,curAccountIndex);
	return result;
}

function printCookie(c){
	console.log('url:'+c.url);
	console.log('name:'+c.name);
	console.log('value:'+c.value);
	//console.log('');
}

function printCookies(wn,an) {	
	var cookies=ls.get(wn+'.'+an+'.'+'cookies');
	if(cookies==null){
		return;
	}
	console.log('len:'+cookies.length);
    for (var a = 0; a < cookies.length; a++) {
        try {
            var d = cookies[a];
            var b = {};
            b.url = ((b.secure) ? "https://": "http://") + d.domain;
            b.name = d.name;
            b.storeId = d.storeId;
            b.value = d.value;
            if (!d.hostOnly) {
                b.domain = d.domain
            }
            b.path = d.path;
            b.secure = d.secure;
            b.httpOnly = d.httpOnly;
            if (!d.session) {
                b.expirationDate = d.expirationDate
            }           
	printCookie(b);
        } catch(c) {
            console.error("Error catched restoring cookie:\n" + c.description)
        }
    }
};
function printCurCookies(){
	var d={domain:'sina.com.cn'};
	var c=chrome.cookies.getAll(d,function(cks) {
		console.log('cks.length:'+cks.length);
		$.each(cks,function(key,value){
			printCookie(value);
		});
	});
}

function checkLS(){//检查localstorage数据的合法性
	var wss=ls.get('g_websites');
	$.each(wss,function(key,value){
		var acs=ls.get(value['name']);
		if(acs==null){
			console.log('acs==null');return true;
		}
		if($(this)[0]['curAccountIndex']>=acs.length||
		$(this)[0]['curAccountIndex']<0){
			$(this)[0]['curAccountIndex']=0;
		}
	});
	ls.set('g_websites',wss);
	g_websites=ls.get('g_websites');
}

function getAutoRefreshFromRootDomain(_rootDomain){
	var g_websites=ls.get('g_websites');
	if(g_websites==null){
		return '';
	}
	var result=false;
	$.each(g_websites,function(k,v){
		if(v.rootDomain==_rootDomain){
			result=v.autoRefresh;
			return false;
		}
	});
	return result;
}