/*
 * Decompiled with CFR 0.152.
 */
package com.cym.config;

import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.model.Basic;
import com.cym.model.Http;
import com.cym.model.Stream;
import com.cym.service.BasicService;
import com.cym.service.SettingService;
import com.cym.utils.SystemTool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class InitConfig {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String acmeSh = "/root/.acme.sh/acme.sh";
    public static String home;
    @Autowired
    SettingService settingService;
    @Autowired
    BasicService basicService;
    @Autowired
    SqlHelper sqlHelper;

    @Value(value="${project.home}")
    public void setHome(String home) {
        InitConfig.home = home;
    }

    @PostConstruct
    public void init() throws IOException {
        List<Http> https;
        Long count = this.sqlHelper.findAllCount(Basic.class);
        if (count == 0L) {
            ArrayList<Basic> basics = new ArrayList<Basic>();
            basics.add(new Basic("worker_processes", "auto", Long.valueOf(1L)));
            basics.add(new Basic("events", "{\r\n    worker_connections  1024;\r\n}", Long.valueOf(2L)));
            this.sqlHelper.insertAll(basics);
        }
        if ((count = this.sqlHelper.findAllCount(Http.class)) == 0L) {
            https = new ArrayList<Http>();
            https.add(new Http("include", "mime.types", Long.valueOf(0L)));
            https.add(new Http("default_type", "application/octet-stream", Long.valueOf(1L)));
            this.sqlHelper.insertAll(https);
        }
        if (SystemTool.isLinux().booleanValue()) {
            this.logger.info("----------------release acme.sh--------------");
            if (!FileUtil.exist((String)"/root/.acme.sh")) {
                if (FileUtil.exist((String)(home + ".acme.sh"))) {
                    FileUtil.copy((String)(home + ".acme.sh"), (String)"/root/", (boolean)true);
                } else {
                    ClassPathResource resource = new ClassPathResource("acme.zip");
                    InputStream inputStream = resource.getInputStream();
                    FileUtil.writeFromStream((InputStream)inputStream, (String)"/root/acme.zip");
                    FileUtil.mkdir((String)"/root/.acme.sh");
                    ZipUtil.unzip((String)"/root/acme.zip", (String)"/root/.acme.sh");
                    FileUtil.del((String)"/root/acme.zip");
                    RuntimeUtil.exec((String[])new String[]{"chmod 777 " + acmeSh});
                }
            }
            if (!this.basicService.contain("ngx_stream_module.so")) {
                List list = RuntimeUtil.execForLines((Charset)CharsetUtil.systemCharset(), (String[])new String[]{"find / -name ngx_stream_module.so"});
                for (String path : list) {
                    if (!path.contains("ngx_stream_module.so") || path.length() >= 80) continue;
                    Basic basic = new Basic("load_module", path, Long.valueOf(-10L));
                    this.sqlHelper.insert((Object)basic);
                    break;
                }
            }
            this.logger.info("----------------find nginx.conf--------------");
            String nginxPath = this.settingService.get("nginxPath");
            if (StrUtil.isEmpty((CharSequence)nginxPath)) {
                try {
                    if (this.inDocker().booleanValue()) {
                        this.logger.info("----------------release nginx.conf--------------");
                        nginxPath = home + "nginx.conf";
                        ClassPathResource resource = new ClassPathResource("nginxOrg.conf");
                        InputStream inputStream = resource.getInputStream();
                        FileUtil.writeFromStream((InputStream)inputStream, (String)nginxPath);
                        this.settingService.set("nginxPath", nginxPath);
                        this.settingService.set("nginxExe", "nginx");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.inDocker().booleanValue()) {
                RuntimeUtil.exec((String[])new String[]{"nginx"});
            }
        }
        https = this.sqlHelper.findAll(Http.class);
        List streams = this.sqlHelper.findAll(Stream.class);
        for (Http http : https) {
            if (http.getSeq() != null) continue;
            http.setSeq(Long.valueOf(Long.parseLong(http.getId())));
            this.sqlHelper.updateById((Object)http);
        }
        for (Stream stream : streams) {
            if (stream.getSeq() != null) continue;
            stream.setSeq(Long.valueOf(Long.parseLong(stream.getId())));
            this.sqlHelper.updateById((Object)stream);
        }
    }

    private Boolean inDocker() {
        return FileUtil.exist((String)"/etc/nginx/nginx.conf") && FileUtil.readUtf8String((String)"/etc/nginx/nginx.conf").contains("include " + home + "nginx.conf");
    }
}

