/*
 * Decompiled with CFR 0.152.
 */
package com.cym.config;

import cn.craccd.sqlHelper.utils.SqlHelper;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.config.InitConfig;
import com.cym.controller.adminPage.CertController;
import com.cym.controller.adminPage.ConfController;
import com.cym.controller.adminPage.RemoteController;
import com.cym.model.Cert;
import com.cym.model.Remote;
import com.cym.model.Upstream;
import com.cym.model.UpstreamServer;
import com.cym.service.LogService;
import com.cym.service.RemoteService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.utils.MessageUtils;
import com.cym.utils.SendMailUtils;
import com.cym.utils.TelnetUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class ScheduleTask {
    @Value(value="${server.port}")
    Integer port;
    final SqlHelper sqlHelper;
    final CertController certController;
    final SettingService settingService;
    final ConfController confController;
    final RemoteController remoteController;
    final RemoteService remoteService;
    final UpstreamService upstreamService;
    final LogService logInfoService;
    final SendMailUtils sendMailUtils;
    final MessageUtils m;

    public ScheduleTask(MessageUtils m, UpstreamService upstreamService, RemoteService remoteService, SendMailUtils sendMailUtils, RemoteController remoteController, SqlHelper sqlHelper, CertController certController, SettingService settingService, ConfController confController, LogService logInfoService) {
        this.sqlHelper = sqlHelper;
        this.upstreamService = upstreamService;
        this.remoteService = remoteService;
        this.certController = certController;
        this.settingService = settingService;
        this.confController = confController;
        this.logInfoService = logInfoService;
        this.remoteController = remoteController;
        this.sendMailUtils = sendMailUtils;
        this.m = m;
    }

    @Scheduled(cron="0 0 2 * * ?")
    public void certTasks() {
        List certList = this.sqlHelper.findAll(Cert.class);
        long time = System.currentTimeMillis();
        for (Cert cert : certList) {
            if (cert.getMakeTime() == null || cert.getAutoRenew() != 1 || time - cert.getMakeTime() <= TimeUnit.DAYS.toMillis(50L)) continue;
            this.certController.apply(cert.getId(), "renew");
        }
    }

    @Scheduled(cron="0 55 23 * * ?")
    public void diviLog() {
        if (FileUtil.exist((String)(InitConfig.home + "log/access.log"))) {
            String date = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            File dist = new File(InitConfig.home + "log/access." + date + ".log");
            FileUtil.move((File)new File(InitConfig.home + "log/access.log"), (File)dist, (boolean)true);
            ZipUtil.zip((File)dist);
            FileUtil.del((File)dist);
            this.confController.reload(null, null, null);
            this.logInfoService.buildDataGroup(InitConfig.home + "log/access." + date + ".zip");
            this.logInfoService.clearDb();
        }
        long time = System.currentTimeMillis();
        File dir = new File(InitConfig.home + "log/");
        for (File file : dir.listFiles()) {
            if (!file.getName().contains("access.") || !file.getName().endsWith(".zip")) continue;
            String dateStr = file.getName().replace("access.", "").replace(".zip", "");
            DateTime date = null;
            if (dateStr.length() != 10) {
                FileUtil.del((File)file);
                continue;
            }
            date = DateUtil.parse((CharSequence)dateStr, (String)"yyyy-MM-dd");
            if (time - date.getTime() <= TimeUnit.DAYS.toMillis(8L)) continue;
            FileUtil.del((File)file);
        }
    }

    @Scheduled(cron="0/30 * * * * ?")
    public void nginxTasks() {
        String lastNginxSend = this.settingService.get("lastNginxSend");
        String mail = this.settingService.get("mail");
        String nginxMonitor = this.settingService.get("nginxMonitor");
        if ("true".equals(nginxMonitor) && StrUtil.isNotEmpty((CharSequence)mail) && (StrUtil.isEmpty((CharSequence)lastNginxSend) || System.currentTimeMillis() - Long.parseLong(lastNginxSend) > TimeUnit.MINUTES.toMillis(30L))) {
            Map map;
            ArrayList<String> names = new ArrayList<String>();
            List remoteList = this.remoteService.getMonitorRemoteList();
            for (Remote remote : remoteList) {
                try {
                    String json = HttpUtil.get((String)(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/adminPage/remote/version?creditKey=" + remote.getCreditKey()), (int)1000);
                    Map map2 = (Map)JSONUtil.toBean((String)json, (Type)new /* Unavailable Anonymous Inner Class!! */.getType(), (boolean)false);
                    if ((Integer)map2.get("nginx") != 0 || remote.getMonitor() != 1) continue;
                    names.add(remote.getDescr() + "[" + remote.getIp() + ":" + remote.getPort() + "]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    names.add(remote.getDescr() + "[" + remote.getIp() + ":" + remote.getPort() + "]");
                }
            }
            if ("1".equals(this.settingService.get("monitorLocal")) && (Integer)(map = this.remoteController.version()).get("nginx") == 0) {
                names.add(0, this.m.get("remoteStr.local") + "[127.0.0.1:" + this.port + "]");
            }
            if (names.size() > 0) {
                this.sendMailUtils.sendMailSmtp(mail, this.m.get("mailStr.nginxFail"), this.m.get("mailStr.nginxTips") + StrUtil.join((CharSequence)" ", (Object[])new Object[]{names}));
                this.settingService.set("lastNginxSend", String.valueOf(System.currentTimeMillis()));
            }
        }
    }

    @Scheduled(cron="0/30 * * * * ?")
    public void nodeTasks() {
        String lastUpstreamSend = this.settingService.get("lastUpstreamSend");
        String mail = this.settingService.get("mail");
        String upstreamMonitor = this.settingService.get("upstreamMonitor");
        if ("true".equals(upstreamMonitor)) {
            List upstreamServers = this.upstreamService.getAllServer();
            ArrayList<String> ips = new ArrayList<String>();
            for (UpstreamServer upstreamServer : upstreamServers) {
                if (!TelnetUtils.isRunning((String)upstreamServer.getServer(), (int)upstreamServer.getPort())) {
                    Upstream upstream = (Upstream)this.sqlHelper.findById(upstreamServer.getUpstreamId(), Upstream.class);
                    if (upstream.getMonitor() == 1 && StrUtil.isNotEmpty((CharSequence)mail) && (StrUtil.isEmpty((CharSequence)lastUpstreamSend) || System.currentTimeMillis() - Long.parseLong(lastUpstreamSend) > TimeUnit.MINUTES.toMillis(30L))) {
                        ips.add(upstreamServer.getServer() + ":" + upstreamServer.getPort());
                    }
                    upstreamServer.setMonitorStatus(Integer.valueOf(0));
                } else {
                    upstreamServer.setMonitorStatus(Integer.valueOf(1));
                }
                this.sqlHelper.updateById((Object)upstreamServer);
            }
            if (ips.size() > 0) {
                this.sendMailUtils.sendMailSmtp(mail, this.m.get("mailStr.upstreamFail"), this.m.get("mailStr.upstreamTips") + StrUtil.join((CharSequence)" ", (Object[])new Object[]{ips}));
                this.settingService.set("lastUpstreamSend", String.valueOf(System.currentTimeMillis()));
            }
        }
    }
}

