/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.cym.config.InitConfig;
import com.cym.model.Remote;
import com.cym.utils.AsyncUtils;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={""})
@Controller
public class MainController
extends BaseController {
    @Autowired
    AsyncUtils asyncUtils;
    private static final Logger LOG = LoggerFactory.getLogger(MainController.class);

    @RequestMapping(value={""})
    public ModelAndView index(ModelAndView modelAndView, String keywords) {
        modelAndView.setViewName("redirect:/adminPage/admin/");
        return modelAndView;
    }

    @ResponseBody
    @RequestMapping(value={"/upload"})
    public JsonResult upload(@RequestParam(value="file") MultipartFile file, HttpSession httpSession) {
        try {
            File temp = new File(FileUtil.getTmpDir() + "/" + file.getOriginalFilename());
            file.transferTo(temp);
            File dest = new File(InitConfig.home + "cert/" + file.getOriginalFilename());
            FileUtil.move((File)temp, (File)dest, (boolean)true);
            String localType = (String)httpSession.getAttribute("localType");
            if ("remote".equals(localType)) {
                Remote remote = (Remote)httpSession.getAttribute("remote");
                HashMap<String, File> paramMap = new HashMap<String, File>();
                paramMap.put("file", dest);
                String rs = HttpUtil.post((String)(remote.getProtocol() + "://" + remote.getIp() + ":" + remote.getPort() + "/upload"), paramMap);
                JsonResult jsonResult = (JsonResult)JSONUtil.toBean((String)rs, JsonResult.class);
                FileUtil.del((File)dest);
                return jsonResult;
            }
            return this.renderSuccess((Object)dest.getPath().replace("\\", "/"));
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            return this.renderError();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/autoUpdate"})
    public JsonResult autoUpdate(String url) {
        if (!SystemTool.isLinux().booleanValue()) {
            return this.renderError(this.m.get("commonStr.updateTips"));
        }
        ApplicationHome home = new ApplicationHome(this.getClass());
        File jar = home.getSource();
        String path = jar.getParent() + "/nginxWebUI.jar.update";
        LOG.info("download:" + path);
        HttpUtil.downloadFile((String)url, (String)path);
        this.asyncUtils.run(path);
        return this.renderSuccess();
    }
}

