/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.craccd.sqlHelper.bean.Page;
import cn.hutool.core.util.StrUtil;
import com.cym.model.Admin;
import com.cym.service.AdminService;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SendMailUtils;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/admin"})
public class AdminController
extends BaseController {
    @Autowired
    AdminService adminService;
    @Autowired
    SettingService settingService;
    @Autowired
    SendMailUtils sendCloudUtils;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView, Page page) {
        page = this.adminService.search(page);
        modelAndView.addObject("page", (Object)page);
        modelAndView.setViewName("/adminPage/admin/index");
        return modelAndView;
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(Admin admin) {
        Long count;
        if (StrUtil.isEmpty((CharSequence)admin.getId()) ? (count = this.adminService.getCountByName(admin.getName())) > 0L : (count = this.adminService.getCountByNameWithOutId(admin.getName(), admin.getId())) > 0L) {
            return this.renderError(this.m.get("adminStr.nameRepetition"));
        }
        this.sqlHelper.insertOrUpdate((Object)admin);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Admin.class));
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        this.sqlHelper.deleteById(id, Admin.class);
        return this.renderSuccess();
    }

    @RequestMapping(value={"getMailSetting"})
    @ResponseBody
    public JsonResult getMailSetting() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mail_host", this.settingService.get("mail_host"));
        map.put("mail_port", this.settingService.get("mail_port"));
        map.put("mail_from", this.settingService.get("mail_from"));
        map.put("mail_user", this.settingService.get("mail_user"));
        map.put("mail_pass", this.settingService.get("mail_pass"));
        map.put("mail_ssl", this.settingService.get("mail_ssl"));
        return this.renderSuccess(map);
    }

    @RequestMapping(value={"updateMailSetting"})
    @ResponseBody
    public JsonResult updateMailSetting(String mailType, String mail_user, String mail_host, String mail_port, String mail_from, String mail_pass, String mail_ssl) {
        this.settingService.set("mail_host", mail_host);
        this.settingService.set("mail_port", mail_port);
        this.settingService.set("mail_user", mail_user);
        this.settingService.set("mail_from", mail_from);
        this.settingService.set("mail_pass", mail_pass);
        this.settingService.set("mail_ssl", mail_ssl);
        return this.renderSuccess();
    }

    @RequestMapping(value={"testMail"})
    @ResponseBody
    public JsonResult testMail(String mail) {
        if (StrUtil.isEmpty((CharSequence)mail)) {
            return this.renderError(this.m.get("adminStr.emailEmpty"));
        }
        try {
            this.sendCloudUtils.sendMailSmtp(mail, this.m.get("adminStr.emailTest"), this.m.get("adminStr.emailTest"));
            return this.renderSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(e.getMessage());
        }
    }
}

