/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import com.cym.config.InitConfig;
import com.cym.model.Bak;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/bak"})
public class BakController
extends BaseController {
    @Autowired
    SettingService settingService;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView) {
        List bakList = this.getBakList();
        CollectionUtil.sort((List)bakList, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        modelAndView.addObject("bakList", (Object)bakList);
        modelAndView.setViewName("/adminPage/bak/index");
        return modelAndView;
    }

    private List<Bak> getBakList() {
        File dir;
        File[] fileList;
        ArrayList<Bak> list = new ArrayList<Bak>();
        String bakPath = InitConfig.home + "/bak";
        if (StrUtil.isNotEmpty((CharSequence)bakPath) && FileUtil.exist((String)bakPath) && (fileList = (dir = new File(bakPath)).listFiles()) != null) {
            for (File file : fileList) {
                if (!file.getName().contains("nginx.conf") || !file.getName().endsWith(".bak")) continue;
                Bak bak = new Bak();
                bak.setPath(file.getPath().replace("\\", "/"));
                DateTime date = DateUtil.parse((CharSequence)file.getName().replace("nginx.conf.", "").replace(".bak", ""), (String)"yyyy-MM-dd_HH-mm-ss");
                bak.setTime(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                list.add(bak);
            }
        }
        return list;
    }

    @RequestMapping(value={"content"})
    @ResponseBody
    public JsonResult content(String path) {
        String str = FileUtil.readString((String)path, (Charset)Charset.forName("UTF-8"));
        return this.renderSuccess((Object)str);
    }

    @RequestMapping(value={"replace"})
    @ResponseBody
    public JsonResult replace(String path) {
        String nginxPath = this.settingService.get("nginxPath");
        if (StrUtil.isNotEmpty((CharSequence)nginxPath)) {
            File pathFile = new File(nginxPath);
            FileUtil.copy((String)path, (String)nginxPath, (boolean)true);
            FileUtil.del((String)(pathFile.getParent() + "/conf.d"));
            ZipUtil.unzip((String)path.replace(".bak", ".zip"), (String)(pathFile.getParent() + "/conf.d"));
            return this.renderSuccess();
        }
        return this.renderError(this.m.get("bakStr.pathNotice"));
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String path) {
        FileUtil.del((String)path);
        FileUtil.del((String)path.replace(".bak", ".zip"));
        return this.renderSuccess();
    }

    @RequestMapping(value={"delAll"})
    @ResponseBody
    public JsonResult delAll() {
        List list = this.getBakList();
        for (Bak bak : list) {
            this.del(bak.getPath());
        }
        return this.renderSuccess();
    }
}

