/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import com.cym.config.InitConfig;
import com.cym.model.Cert;
import com.cym.service.SettingService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.SystemTool;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/cert"})
public class CertController
extends BaseController {
    @Autowired
    SettingService settingService;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Boolean isInApply = false;

    @RequestMapping(value={""})
    public ModelAndView index(HttpSession httpSession, ModelAndView modelAndView) {
        List certs = this.sqlHelper.findAll(Cert.class);
        modelAndView.addObject("certs", (Object)certs);
        modelAndView.setViewName("/adminPage/cert/index");
        return modelAndView;
    }

    @RequestMapping(value={"addOver"})
    @ResponseBody
    public JsonResult addOver(Cert cert) {
        this.sqlHelper.insertOrUpdate((Object)cert);
        return this.renderSuccess();
    }

    @RequestMapping(value={"setAutoRenew"})
    @ResponseBody
    public JsonResult setAutoRenew(Cert cert) {
        this.sqlHelper.updateById((Object)cert);
        return this.renderSuccess();
    }

    @RequestMapping(value={"detail"})
    @ResponseBody
    public JsonResult detail(String id) {
        return this.renderSuccess(this.sqlHelper.findById(id, Cert.class));
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public JsonResult del(String id) {
        Cert cert = (Cert)this.sqlHelper.findById(id, Cert.class);
        if (cert.getKey() != null) {
            FileUtil.del((String)cert.getKey());
        }
        if (cert.getPem() != null) {
            FileUtil.del((String)cert.getPem());
        }
        this.sqlHelper.deleteById(id, Cert.class);
        return this.renderSuccess();
    }

    @RequestMapping(value={"apply"})
    @ResponseBody
    public JsonResult apply(String id, String type) {
        if (!SystemTool.isLinux().booleanValue()) {
            return this.renderError(this.m.get("certStr.error2"));
        }
        Cert cert = (Cert)this.sqlHelper.findById(id, Cert.class);
        if (cert.getDnsType() == null) {
            return this.renderError(this.m.get("certStr.error3"));
        }
        if (this.isInApply.booleanValue()) {
            return this.renderError(this.m.get("certStr.error4"));
        }
        this.isInApply = true;
        String rs = "";
        try {
            this.setEnv(cert);
            String cmd = "";
            if (type.equals("issue") || StrUtil.isEmpty((CharSequence)cert.getPem())) {
                String dnsType = "";
                if (cert.getDnsType().equals("ali")) {
                    dnsType = "dns_ali";
                } else if (cert.getDnsType().equals("dp")) {
                    dnsType = "dns_dp";
                }
                cmd = InitConfig.acmeSh + " --issue --dns " + dnsType + " -d " + cert.getDomain();
            } else if (type.equals("renew")) {
                String domain = cert.getDomain().split(",")[0];
                cmd = InitConfig.acmeSh + " --renew --force -d " + domain;
            }
            this.logger.info(cmd);
            rs = RuntimeUtil.execForStr((String[])new String[]{cmd});
            this.logger.info(rs);
        }
        catch (Exception e) {
            e.printStackTrace();
            rs = e.getMessage();
        }
        FileUtil.del((String)(InitConfig.home + ".acme.sh"));
        FileUtil.copy((String)"/root/.acme.sh", (String)InitConfig.home, (boolean)true);
        if (rs.contains("Your cert is in")) {
            try {
                String domain = cert.getDomain().split(",")[0];
                String certDir = "/root/.acme.sh/" + domain + "/";
                String dest = InitConfig.home + "cert/" + domain + ".fullchain.cer";
                FileUtil.copy((File)new File(certDir + "fullchain.cer"), (File)new File(dest), (boolean)true);
                cert.setPem(dest);
                dest = InitConfig.home + "cert/" + domain + ".key";
                FileUtil.copy((File)new File(certDir + domain + ".key"), (File)new File(dest), (boolean)true);
                cert.setKey(dest);
                cert.setMakeTime(Long.valueOf(System.currentTimeMillis()));
                this.sqlHelper.updateById((Object)cert);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isInApply = false;
            return this.renderSuccess();
        }
        this.isInApply = false;
        return this.renderError(rs.replace("\n", "<br>"));
    }

    private void setEnv(Cert cert) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("UPGRADE_HASH='" + UUID.randomUUID().toString().replace("-", "") + "'");
        if (cert.getDnsType().equals("ali")) {
            list.add("SAVED_Ali_Key='" + cert.getAliKey() + "'");
            list.add("SAVED_Ali_Secret='" + cert.getAliSecret() + "'");
        }
        if (cert.getDnsType().equals("dp")) {
            list.add("SAVED_DP_Id='" + cert.getDpId() + "'");
            list.add("SAVED_DP_Key='" + cert.getDpKey() + "'");
        }
        list.add("USER_PATH='/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/snap/bin'");
        FileUtil.writeLines(list, (File)new File(InitConfig.acmeSh.replace("/acme.sh", "/account.conf")), (Charset)Charset.defaultCharset());
    }
}

