/*
 * Decompiled with CFR 0.152.
 */
package com.cym.controller.adminPage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RuntimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.cym.config.VersionConfig;
import com.cym.controller.MainController;
import com.cym.ext.ConfExt;
import com.cym.ext.ConfFile;
import com.cym.service.ConfService;
import com.cym.service.ServerService;
import com.cym.service.SettingService;
import com.cym.service.UpstreamService;
import com.cym.utils.BaseController;
import com.cym.utils.JsonResult;
import com.cym.utils.NginxUtils;
import com.cym.utils.SystemTool;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/adminPage/conf"})
public class ConfController
extends BaseController {
    final UpstreamService upstreamService;
    final SettingService settingService;
    final ServerService serverService;
    final ConfService confService;
    final MainController mainController;
    @Autowired
    VersionConfig versionConfig;
    @Value(value="${project.version}")
    String currentVersion;

    public ConfController(UpstreamService upstreamService, SettingService settingService, ServerService serverService, ConfService confService, MainController mainController) {
        this.upstreamService = upstreamService;
        this.settingService = settingService;
        this.serverService = serverService;
        this.confService = confService;
        this.mainController = mainController;
    }

    @RequestMapping(value={""})
    public ModelAndView index(ModelAndView modelAndView) {
        String nginxPath = this.settingService.get("nginxPath");
        modelAndView.addObject("nginxPath", (Object)nginxPath);
        String nginxExe = this.settingService.get("nginxExe");
        modelAndView.addObject("nginxExe", (Object)nginxExe);
        String nginxDir = this.settingService.get("nginxDir");
        modelAndView.addObject("nginxDir", (Object)nginxDir);
        String decompose = this.settingService.get("decompose");
        modelAndView.addObject("decompose", (Object)decompose);
        modelAndView.setViewName("/adminPage/conf/index");
        return modelAndView;
    }

    @RequestMapping(value={"nginxStatus"})
    @ResponseBody
    public JsonResult nginxStatus() {
        if (NginxUtils.isRun()) {
            return this.renderSuccess((Object)(this.m.get("confStr.nginxStatus") + "\uff1a<span class='green'>" + this.m.get("confStr.running") + "</span>"));
        }
        return this.renderSuccess((Object)(this.m.get("confStr.nginxStatus") + "\uff1a<span class='red'>" + this.m.get("confStr.stopped") + "</span>"));
    }

    @RequestMapping(value={"replace"})
    @ResponseBody
    public JsonResult replace(String json) {
        JSONObject jsonObject = JSONUtil.parseObj((String)json);
        String nginxPath = jsonObject.getStr((Object)"nginxPath");
        String nginxContent = jsonObject.getStr((Object)"nginxContent");
        List subContent = jsonObject.getJSONArray((Object)"subContent").toList(String.class);
        List subName = jsonObject.getJSONArray((Object)"subName").toList(String.class);
        if (nginxPath == null) {
            nginxPath = this.settingService.get("nginxPath");
        }
        if (!FileUtil.exist((String)nginxPath)) {
            return this.renderError(this.m.get("confStr.error1"));
        }
        if (FileUtil.isDirectory((String)nginxPath)) {
            return this.renderError(this.m.get("confStr.error2"));
        }
        try {
            this.confService.replace(nginxPath, nginxContent, subContent, subName);
            return this.renderSuccess((Object)this.m.get("confStr.replaceSuccess"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(this.m.get("confStr.error3") + ":" + e.getMessage());
        }
    }

    @RequestMapping(value={"check"})
    @ResponseBody
    public JsonResult check(String nginxPath, String nginxExe, String nginxDir) {
        String rs;
        if (nginxPath == null) {
            nginxPath = this.settingService.get("nginxPath");
        }
        if (nginxExe == null) {
            nginxExe = this.settingService.get("nginxExe");
        }
        if (nginxDir == null) {
            nginxDir = this.settingService.get("nginxDir");
        }
        String cmd = null;
        try {
            if (SystemTool.isWindows().booleanValue()) {
                cmd = nginxExe + " -t -c " + nginxPath + " -p " + nginxDir;
            } else {
                cmd = nginxExe + " -t";
                if (nginxExe.contains("/")) {
                    cmd = cmd + " -c " + nginxPath + " -p " + nginxDir;
                }
            }
            rs = RuntimeUtil.execForStr((String[])new String[]{cmd});
        }
        catch (Exception e) {
            e.printStackTrace();
            rs = e.getMessage().replace("\n", "<br>");
        }
        cmd = "<span class='blue'>" + cmd + "</span>";
        if (rs.contains("successful")) {
            return this.renderSuccess((Object)(cmd + "<br>" + this.m.get("confStr.verifySuccess") + "<br>" + rs.replace("\n", "<br>")));
        }
        return this.renderError(cmd + "<br>" + this.m.get("confStr.verifyFail") + "<br>" + rs.replace("\n", "<br>"));
    }

    @RequestMapping(value={"saveCmd"})
    @ResponseBody
    public JsonResult saveCmd(String nginxPath, String nginxExe, String nginxDir) {
        nginxPath = nginxPath.replace("\\", "/");
        this.settingService.set("nginxPath", nginxPath);
        nginxExe = nginxExe.replace("\\", "/");
        this.settingService.set("nginxExe", nginxExe);
        nginxDir = nginxDir.replace("\\", "/");
        this.settingService.set("nginxDir", nginxDir);
        return this.renderSuccess();
    }

    @RequestMapping(value={"reload"})
    @ResponseBody
    public synchronized JsonResult reload(String nginxPath, String nginxExe, String nginxDir) {
        if (nginxPath == null) {
            nginxPath = this.settingService.get("nginxPath");
        }
        if (nginxExe == null) {
            nginxExe = this.settingService.get("nginxExe");
        }
        if (nginxDir == null) {
            nginxDir = this.settingService.get("nginxDir");
        }
        try {
            String cmd;
            if (SystemTool.isWindows().booleanValue()) {
                cmd = nginxExe + " -s reload -c " + nginxPath + " -p " + nginxDir;
            } else {
                cmd = nginxExe + " -s reload";
                if (nginxExe.contains("/") && StrUtil.isNotEmpty((CharSequence)nginxPath) && StrUtil.isNotEmpty((CharSequence)nginxDir)) {
                    cmd = cmd + " -c " + nginxPath + " -p " + nginxDir;
                }
            }
            String rs = RuntimeUtil.execForStr((String[])new String[]{cmd});
            cmd = "<span class='blue'>" + cmd + "</span>";
            if (StrUtil.isEmpty((CharSequence)rs) || rs.contains("signal process started")) {
                return this.renderSuccess((Object)(cmd + "<br>" + this.m.get("confStr.reloadSuccess") + "<br>" + rs.replace("\n", "<br>")));
            }
            if (rs.contains("The system cannot find the file specified") || rs.contains("nginx.pid") || rs.contains("PID")) {
                rs = rs + this.m.get("confStr.mayNotRun");
            }
            return this.renderError(cmd + "<br>" + this.m.get("confStr.reloadFail") + "<br>" + rs.replace("\n", "<br>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(this.m.get("confStr.reloadFail") + "<br>" + e.getMessage().replace("\n", "<br>"));
        }
    }

    @RequestMapping(value={"start"})
    @ResponseBody
    public JsonResult start(String nginxPath, String nginxExe, String nginxDir) {
        if (nginxPath == null) {
            nginxPath = this.settingService.get("nginxPath");
        }
        if (nginxExe == null) {
            nginxExe = this.settingService.get("nginxExe");
        }
        if (nginxDir == null) {
            nginxDir = this.settingService.get("nginxDir");
        }
        try {
            String cmd;
            String rs = "";
            if (SystemTool.isWindows().booleanValue()) {
                cmd = "cmd /c start nginx.exe -c " + nginxPath + " -p " + nginxDir;
                RuntimeUtil.exec((String[])new String[0], (File)new File(nginxDir), (String[])new String[]{cmd});
            } else {
                cmd = nginxExe;
                if (nginxExe.contains("/") && StrUtil.isNotEmpty((CharSequence)nginxPath) && StrUtil.isNotEmpty((CharSequence)nginxDir)) {
                    cmd = cmd + " -c " + nginxPath + " -p " + nginxDir;
                }
                rs = RuntimeUtil.execForStr((String[])new String[]{cmd});
            }
            cmd = "<span class='blue'>" + cmd + "</span>";
            if (StrUtil.isEmpty((CharSequence)rs) || rs.contains("signal process started")) {
                return this.renderSuccess((Object)(cmd + "<br>" + this.m.get("confStr.startSuccess") + "<br>" + rs.replace("\n", "<br>")));
            }
            return this.renderError(cmd + "<br>" + this.m.get("confStr.startFail") + "<br>" + rs.replace("\n", "<br>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(this.m.get("confStr.startFail") + "<br>" + e.getMessage().replace("\n", "<br>"));
        }
    }

    @RequestMapping(value={"stop"})
    @ResponseBody
    public JsonResult stop(String nginxExe, String nginxDir) {
        if (nginxExe == null) {
            nginxExe = this.settingService.get("nginxExe");
        }
        if (nginxDir == null) {
            nginxDir = this.settingService.get("nginxDir");
        }
        try {
            String cmd;
            if (SystemTool.isWindows().booleanValue()) {
                cmd = "taskkill /im nginx.exe /f";
            } else {
                cmd = nginxExe + " -s stop";
                if (nginxExe.contains("/") && StrUtil.isNotEmpty((CharSequence)nginxDir)) {
                    cmd = cmd + " -p " + nginxDir;
                }
            }
            String rs = RuntimeUtil.execForStr((String[])new String[]{cmd});
            cmd = "<span class='blue'>" + cmd + "</span>";
            if (StrUtil.isEmpty((CharSequence)rs) || rs.contains("\u5df2\u7ec8\u6b62\u8fdb\u7a0b") || rs.toLowerCase().contains("terminated process")) {
                return this.renderSuccess((Object)(cmd + "<br>" + this.m.get("confStr.stopSuccess") + "<br>" + rs.replace("\n", "<br>")));
            }
            return this.renderError(cmd + "<br>" + this.m.get("confStr.stopFail") + "<br>" + rs.replace("\n", "<br>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.renderError(this.m.get("confStr.stopFail") + "<br>" + e.getMessage().replace("\n", "<br>"));
        }
    }

    @RequestMapping(value={"loadConf"})
    @ResponseBody
    public JsonResult loadConf() {
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.confService.buildConf(Boolean.valueOf(StrUtil.isNotEmpty((CharSequence)decompose) && decompose.equals("true")));
        return this.renderSuccess((Object)confExt);
    }

    @RequestMapping(value={"loadOrg"})
    @ResponseBody
    public JsonResult loadOrg(String nginxPath) {
        String decompose = this.settingService.get("decompose");
        ConfExt confExt = this.confService.buildConf(Boolean.valueOf(StrUtil.isNotEmpty((CharSequence)decompose) && decompose.equals("true")));
        if (StrUtil.isNotEmpty((CharSequence)nginxPath) && FileUtil.exist((String)nginxPath) && FileUtil.isFile((String)nginxPath)) {
            String orgStr = FileUtil.readString((String)nginxPath, (Charset)StandardCharsets.UTF_8);
            confExt.setConf(orgStr);
            for (ConfFile confFile : confExt.getFileList()) {
                confFile.setConf("");
                String filePath = nginxPath.replace("nginx.conf", "conf.d/" + confFile.getName());
                if (!FileUtil.exist((String)filePath)) continue;
                confFile.setConf(FileUtil.readString((String)filePath, (Charset)StandardCharsets.UTF_8));
            }
            return this.renderSuccess((Object)confExt);
        }
        if (FileUtil.isDirectory((String)nginxPath)) {
            return this.renderError(this.m.get("confStr.error2"));
        }
        return this.renderError(this.m.get("confStr.notExist"));
    }

    @RequestMapping(value={"decompose"})
    @ResponseBody
    public JsonResult decompose(String decompose) {
        this.settingService.set("decompose", decompose);
        return this.renderSuccess();
    }

    @RequestMapping(value={"update"})
    @ResponseBody
    public JsonResult update() {
        this.versionConfig.getNewVersion();
        if (Integer.parseInt(this.currentVersion.replace(".", "").replace("v", "")) < Integer.parseInt(this.versionConfig.getVersion().getVersion().replace(".", "").replace("v", ""))) {
            this.mainController.autoUpdate(this.versionConfig.getVersion().getUrl());
            return this.renderSuccess((Object)this.m.get("confStr.updateSuccess"));
        }
        return this.renderSuccess((Object)this.m.get("confStr.noNeedUpdate"));
    }
}

